# coding: utf-8

"""
    Infoblox FW API

    Infoblox Threat Defense Cloud is an extension of the Infoblox Suite that provides visibility into infected and compromised off-premises devices, roaming users, remote sites, and branch offices. You can subscribe to Infoblox Cloud and use its functionality to mitigate and control malware as well as provide unprecedented insight into your network security posture and enable timely action. Infoblox Cloud also offers unified policy management, reporting, and threat analytics across the entire spectrum. Using automated and high-quality threat intelligence feeds and unique behavioral analytics, it automatically stops device communications with C&Cs/botnets and prevents DNS based data exfiltration.  The mission-critical DNS infrastructure can become a vulnerable component in your network when it is inadequately protected by traditional security solutions and consequently used as an attack surface. Compromised DNS services can result in catastrophic network and system failures. To fully protect your network in today’s cyber security threat environment, Infoblox sets a new DNS security standard by offering scalable, enterprise-grade, and integrated protection for your DNS infrastructure.  Through the Infoblox Cloud Services Portal, you can view the status of your subscription and threat intelligence feeds, manage your network scope and roaming end users, and learn more about threats on your networks through the Infoblox Threat Lookup tool and predefined reports. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import unittest

from fw.api.security_policies_api import SecurityPoliciesApi

from universal_ddi_client.api_client import ApiClient


class TestSecurityPoliciesApi(unittest.TestCase):
    """SecurityPoliciesApi unit test stubs"""

    def setUp(self) -> None:
        api_instance = ApiClient()
        self.api = SecurityPoliciesApi(api_instance)

    def tearDown(self) -> None:
        pass

    def test_create_security_policy(self) -> None:
        """Test case for create_security_policy

        Create Security Policy.
        """
        pass

    def test_delete_security_policy(self) -> None:
        """Test case for delete_security_policy

        Delete Security Policies.
        """
        pass

    def test_delete_single_security_policy(self) -> None:
        """Test case for delete_single_security_policy

        Delete Security Policy.
        """
        pass

    def test_list_security_policies(self) -> None:
        """Test case for list_security_policies

        List Security Policies.
        """
        pass

    def test_read_security_policy(self) -> None:
        """Test case for read_security_policy

        Read Security Policy.
        """
        pass

    def test_update_security_policy(self) -> None:
        """Test case for update_security_policy

        Update Security Policy.
        """
        pass


if __name__ == '__main__':
    unittest.main()
