# coding: utf-8

# flake8: noqa
"""
    Infrastructure Management API

    The **Infrastructure Management API** provides a RESTful interface to manage Infrastructure Hosts and Services objects.  The following is a list of the different Services and their string types (the string types are to be used with the APIs for the `service_type` field):  | Service name | Service type |   | ------ | ------ |   | Access Authentication | authn |   | Anycast | anycast |   | Data Connector | cdc |   | DHCP | dhcp |   | DNS | dns |   | DNS Forwarding Proxy | dfp |   | NIOS Grid Connector | orpheus |   | MS AD Sync | msad |   | NTP | ntp |   | BGP | bgp |   | RIP | rip |   | OSPF | ospf |    ---   ### Hosts API  The Hosts API is used to manage the Infrastructure Host resources. These include various operations related to hosts such as viewing, creating, updating, replacing, disconnecting, and deleting Hosts. Management of Hosts is done from the Cloud Services Portal (CSP) by navigating to the Manage -> Infrastructure -> Hosts tab.  ---   ### Services API  The Services API is used to manage the Infrastructure Service resources (a.k.a. NIOS-X applications). These include various operations related to hosts such as viewing, creating, updating, starting/stopping, configuring, and deleting Services. Management of Services is done from the Cloud Services Portal (CSP) by navigating to the Manage -> Infrastructure -> Services tab.  ---   ### Detail APIs  The Detail APIs are read-only APIs used to list all the Infrastructure resources (Hosts and Services). Each resource record returned also contains information about its other associated resources and the status information for itself and the associated resource(s) (i.e., Host/Service status).  ---   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

# import models into model package
from infra_mgmt.models.api_page_info import ApiPageInfo
from infra_mgmt.models.applications import Applications
from infra_mgmt.models.applications_response import ApplicationsResponse
from infra_mgmt.models.assign_tags_request import AssignTagsRequest
from infra_mgmt.models.create_host_response import CreateHostResponse
from infra_mgmt.models.create_service_response import CreateServiceResponse
from infra_mgmt.models.detail_host import DetailHost
from infra_mgmt.models.detail_host_service_config import DetailHostServiceConfig
from infra_mgmt.models.detail_location import DetailLocation
from infra_mgmt.models.detail_service import DetailService
from infra_mgmt.models.detail_service_host import DetailServiceHost
from infra_mgmt.models.detail_service_host_config import DetailServiceHostConfig
from infra_mgmt.models.disconnect_request import DisconnectRequest
from infra_mgmt.models.get_host_response import GetHostResponse
from infra_mgmt.models.get_service_response import GetServiceResponse
from infra_mgmt.models.host import Host
from infra_mgmt.models.list_detail_hosts_response import ListDetailHostsResponse
from infra_mgmt.models.list_detail_services_response import ListDetailServicesResponse
from infra_mgmt.models.list_host_response import ListHostResponse
from infra_mgmt.models.list_service_response import ListServiceResponse
from infra_mgmt.models.pool_info import PoolInfo
from infra_mgmt.models.replace_host_request import ReplaceHostRequest
from infra_mgmt.models.service import Service
from infra_mgmt.models.service_host_config import ServiceHostConfig
from infra_mgmt.models.short_service_status import ShortServiceStatus
from infra_mgmt.models.unassign_tags_request import UnassignTagsRequest
from infra_mgmt.models.update_host_response import UpdateHostResponse
from infra_mgmt.models.update_service_response import UpdateServiceResponse
