# coding: utf-8

"""
    Host Activation Service

    Host activation service provides a RESTful interface to manage cert and join token object. Join tokens are essentially a password that allows on-prem hosts to auto-associate themselves to a customer's account and receive a signed cert.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from infra_provision.models.csr_state import CSRState
from infra_provision.models.join_token import JoinToken
from infra_provision.models.types_inet_value import TypesInetValue
from typing import Optional, Set
from typing_extensions import Self


class CSR(BaseModel):
    """
    Represents a certificate signing request from an on-prem host.
    """ # noqa: E501
    activation_code: Optional[StrictStr] = None
    client_ip: Optional[TypesInetValue] = None
    created_at: Optional[datetime] = None
    csr: Optional[Union[Annotated[bytes, Field(strict=True)],
                        Annotated[str, Field(strict=True)]]] = None
    host_serial: Optional[StrictStr] = None
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    join_token: Optional[JoinToken] = None
    ophid: Optional[StrictStr] = None
    signature: Optional[StrictStr] = None
    src_ip: Optional[TypesInetValue] = None
    state: Optional[CSRState] = None
    updated_at: Optional[datetime] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "activation_code", "client_ip", "created_at", "csr", "host_serial",
        "id", "join_token", "ophid", "signature", "src_ip", "state",
        "updated_at"
    ]

    @field_validator('csr')
    def csr_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(
                r"^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$",
                value):
            raise ValueError(
                r"must validate the regular expression /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CSR from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "id",
            "updated_at",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client_ip
        if self.client_ip:
            _dict['client_ip'] = self.client_ip.to_dict()
        # override the default output from pydantic by calling `to_dict()` of join_token
        if self.join_token:
            _dict['join_token'] = self.join_token.to_dict()
        # override the default output from pydantic by calling `to_dict()` of src_ip
        if self.src_ip:
            _dict['src_ip'] = self.src_ip.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CSR from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activation_code":
            obj.get("activation_code"),
            "client_ip":
            TypesInetValue.from_dict(obj["client_ip"])
            if obj.get("client_ip") is not None else None,
            "created_at":
            obj.get("created_at"),
            "csr":
            obj.get("csr"),
            "host_serial":
            obj.get("host_serial"),
            "id":
            obj.get("id"),
            "join_token":
            JoinToken.from_dict(obj["join_token"])
            if obj.get("join_token") is not None else None,
            "ophid":
            obj.get("ophid"),
            "signature":
            obj.get("signature"),
            "src_ip":
            TypesInetValue.from_dict(obj["src_ip"])
            if obj.get("src_ip") is not None else None,
            "state":
            obj.get("state"),
            "updated_at":
            obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
