# coding: utf-8

"""
    Host Activation Service

    Host activation service provides a RESTful interface to manage cert and join token object. Join tokens are essentially a password that allows on-prem hosts to auto-associate themselves to a customer's account and receive a signed cert.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infra_provision.models.join_token_join_token_status import JoinTokenJoinTokenStatus
from typing import Optional, Set
from typing_extensions import Self


class JoinToken(BaseModel):
    """
    JoinToken
    """

  # noqa: E501
    deleted_at: Optional[datetime] = None
    description: Optional[StrictStr] = None
    expires_at: Optional[datetime] = None
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    last_used_at: Optional[datetime] = None
    name: Optional[StrictStr] = None
    status: Optional[JoinTokenJoinTokenStatus] = Field(
        default=None,
        description=
        "derived field, \"active\" when expires_at and deleted_at are null.")
    tags: Optional[Dict[str, Any]] = None
    token_id: Optional[StrictStr] = Field(
        default=None, description="first half of the token.")
    use_counter: Optional[StrictInt] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "deleted_at", "description", "expires_at", "id", "last_used_at",
        "name", "status", "tags", "token_id", "use_counter"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JoinToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "deleted_at",
            "id",
            "last_used_at",
            "status",
            "token_id",
            "use_counter",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JoinToken from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deleted_at": obj.get("deleted_at"),
            "description": obj.get("description"),
            "expires_at": obj.get("expires_at"),
            "id": obj.get("id"),
            "last_used_at": obj.get("last_used_at"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "token_id": obj.get("token_id"),
            "use_counter": obj.get("use_counter")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
