# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.ignore_item import IgnoreItem
from typing import Optional, Set
from typing_extensions import Self


class DHCPConfig(BaseModel):
    """
    A DHCP Config object (_dhcp/dhcp_config_) represents a shared DHCP configuration that controls how leases are issued.
    """ # noqa: E501
    abandoned_reclaim_time: Optional[StrictInt] = Field(
        default=3600,
        description="The abandoned reclaim time in seconds for IPV4 clients.")
    abandoned_reclaim_time_v6: Optional[StrictInt] = Field(
        default=3600,
        description="The abandoned reclaim time in seconds for IPV6 clients.")
    allow_unknown: Optional[StrictBool] = Field(
        default=True,
        description=
        "Disable to allow leases only for known IPv4 clients, those for which a fixed address is configured."
    )
    allow_unknown_v6: Optional[StrictBool] = Field(
        default=True,
        description=
        "Disable to allow leases only for known IPV6 clients, those for which a fixed address is configured."
    )
    echo_client_id: Optional[StrictBool] = Field(
        default=False,
        description=
        "Enable/disable to include/exclude the client id when responding to discover or request."
    )
    filters: Optional[List[StrictStr]] = Field(
        default=None, description="The resource identifier.")
    filters_large_selection: Optional[List[StrictStr]] = Field(
        default=None, description="The resource identifier.")
    filters_v6: Optional[List[StrictStr]] = Field(
        default=None, description="The resource identifier.")
    ignore_client_uid: Optional[StrictBool] = Field(
        default=False,
        description=
        "Enable to ignore the client UID when issuing a DHCP lease. Use this option to prevent assigning two IP addresses for a client which does not have a UID during one phase of PXE boot but acquires one for the other phase."
    )
    ignore_list: Optional[List[IgnoreItem]] = Field(
        default=None,
        description="The list of clients to ignore requests from.")
    lease_time: Optional[StrictInt] = Field(
        default=3600, description="The lease duration in seconds.")
    lease_time_v6: Optional[StrictInt] = Field(
        default=3600,
        description="The lease duration in seconds for IPV6 clients.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "abandoned_reclaim_time", "abandoned_reclaim_time_v6", "allow_unknown",
        "allow_unknown_v6", "echo_client_id", "filters",
        "filters_large_selection", "filters_v6", "ignore_client_uid",
        "ignore_list", "lease_time", "lease_time_v6"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DHCPConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ignore_list (list)
        _items = []
        if self.ignore_list:
            for _item in self.ignore_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ignore_list'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DHCPConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "abandoned_reclaim_time":
            obj.get("abandoned_reclaim_time")
            if obj.get("abandoned_reclaim_time") is not None else 3600,
            "abandoned_reclaim_time_v6":
            obj.get("abandoned_reclaim_time_v6")
            if obj.get("abandoned_reclaim_time_v6") is not None else 3600,
            "allow_unknown":
            obj.get("allow_unknown")
            if obj.get("allow_unknown") is not None else True,
            "allow_unknown_v6":
            obj.get("allow_unknown_v6")
            if obj.get("allow_unknown_v6") is not None else True,
            "echo_client_id":
            obj.get("echo_client_id")
            if obj.get("echo_client_id") is not None else False,
            "filters":
            obj.get("filters"),
            "filters_large_selection":
            obj.get("filters_large_selection"),
            "filters_v6":
            obj.get("filters_v6"),
            "ignore_client_uid":
            obj.get("ignore_client_uid")
            if obj.get("ignore_client_uid") is not None else False,
            "ignore_list":
            [IgnoreItem.from_dict(_item) for _item in obj["ignore_list"]]
            if obj.get("ignore_list") is not None else None,
            "lease_time":
            obj.get("lease_time")
            if obj.get("lease_time") is not None else 3600,
            "lease_time_v6":
            obj.get("lease_time_v6")
            if obj.get("lease_time_v6") is not None else 3600
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
