# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class DNSUsage(BaseModel):
    """
    The __DNSUsage__ object tracks DNS usage of a resource record on an address.
    """ # noqa: E501
    absolute_name: Optional[StrictStr] = Field(
        default=None,
        description=
        "The absolute name of the resource record in associated zone.")
    address: Optional[StrictStr] = Field(
        default=None, description="The address of the referenced record.")
    dns_rdata: Optional[StrictStr] = Field(
        default=None, description="The DNS rdata of the referenced record.")
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    name: Optional[StrictStr] = Field(
        default=None, description="The name in zone of the referenced record.")
    record: Optional[StrictStr] = Field(default=None,
                                        description="The resource identifier.")
    space: Optional[StrictStr] = Field(default=None,
                                       description="The resource identifier.")
    type: Optional[StrictStr] = Field(
        default=None, description="The type of the referenced record.")
    view: Optional[StrictStr] = Field(default=None,
                                      description="The resource identifier.")
    zone: Optional[StrictStr] = Field(default=None,
                                      description="The resource identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "absolute_name", "address", "dns_rdata", "id", "name", "record",
        "space", "type", "view", "zone"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DNSUsage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "absolute_name",
            "address",
            "dns_rdata",
            "id",
            "name",
            "type",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DNSUsage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "absolute_name": obj.get("absolute_name"),
            "address": obj.get("address"),
            "dns_rdata": obj.get("dns_rdata"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "record": obj.get("record"),
            "space": obj.get("space"),
            "type": obj.get("type"),
            "view": obj.get("view"),
            "zone": obj.get("zone")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
