# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.inheritance_inherited_string import InheritanceInheritedString
from ipam.models.inherited_dhcp_option_list import InheritedDHCPOptionList
from typing import Optional, Set
from typing_extensions import Self


class FixedAddressInheritance(BaseModel):
    """
    The __FixedAddressInheritance__ object specifies how and which fields _FixedAddress_ object inherits from the parent.
    """ # noqa: E501
    dhcp_options: Optional[InheritedDHCPOptionList] = Field(
        default=None,
        description="The inheritance configuration for _dhcp_options_ field.")
    header_option_filename: Optional[InheritanceInheritedString] = Field(
        default=None,
        description=
        "The inheritance configuration for _header_option_filename_ field.")
    header_option_server_address: Optional[InheritanceInheritedString] = Field(
        default=None,
        description=
        "The inheritance configuration for _header_option_server_address_ field."
    )
    header_option_server_name: Optional[InheritanceInheritedString] = Field(
        default=None,
        description=
        "The inheritance configuration for _header_option_server_name_ field.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "dhcp_options", "header_option_filename",
        "header_option_server_address", "header_option_server_name"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FixedAddressInheritance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dhcp_options
        if self.dhcp_options:
            _dict['dhcp_options'] = self.dhcp_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of header_option_filename
        if self.header_option_filename:
            _dict[
                'header_option_filename'] = self.header_option_filename.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of header_option_server_address
        if self.header_option_server_address:
            _dict[
                'header_option_server_address'] = self.header_option_server_address.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of header_option_server_name
        if self.header_option_server_name:
            _dict[
                'header_option_server_name'] = self.header_option_server_name.to_dict(
                )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FixedAddressInheritance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dhcp_options":
            InheritedDHCPOptionList.from_dict(obj["dhcp_options"])
            if obj.get("dhcp_options") is not None else None,
            "header_option_filename":
            InheritanceInheritedString.from_dict(obj["header_option_filename"])
            if obj.get("header_option_filename") is not None else None,
            "header_option_server_address":
            InheritanceInheritedString.from_dict(
                obj["header_option_server_address"])
            if obj.get("header_option_server_address") is not None else None,
            "header_option_server_name":
            InheritanceInheritedString.from_dict(
                obj["header_option_server_name"])
            if obj.get("header_option_server_name") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
