# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.host_associated_server import HostAssociatedServer
from typing import Optional, Set
from typing_extensions import Self


class Host(BaseModel):
    """
    A DHCP __Host__ (_dhcp/host_) object associates a DHCP Config Profile with an on-prem host.
    """ # noqa: E501
    address: Optional[StrictStr] = Field(
        default=None,
        description="The primary IP address of the on-prem host.")
    anycast_addresses: Optional[List[StrictStr]] = Field(
        default=None,
        description=
        "Anycast address configured to the host. Order is not significant.")
    associated_server: Optional[HostAssociatedServer] = Field(
        default=None,
        description="The DHCP Config Profile for the on-prem host.")
    comment: Optional[StrictStr] = Field(
        default=None, description="The description for the on-prem host.")
    current_version: Optional[StrictStr] = Field(
        default=None,
        description="Current dhcp application version of the host.")
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    ip_space: Optional[StrictStr] = Field(
        default=None, description="The resource identifier.")
    name: Optional[StrictStr] = Field(
        default=None, description="The display name of the on-prem host.")
    ophid: Optional[StrictStr] = Field(default=None,
                                       description="The on-prem host ID.")
    provider_id: Optional[StrictStr] = Field(
        default=None, description="External provider identifier.")
    server: Optional[StrictStr] = Field(default=None,
                                        description="The resource identifier.")
    tags: Optional[Dict[str, Any]] = Field(
        default=None,
        description="The tags of the on-prem host in JSON format.")
    type: Optional[StrictStr] = Field(
        default=None,
        description=
        "Defines the type of host. Allowed values:  * _bloxone_ddi_: host type is BloxOne DDI,  * _microsoft_azure_: host type is Microsoft Azure,  * _amazon_web_service_: host type is Amazon Web Services.  * _microsoft_active_directory_: host type is Microsoft Active Directory."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "address", "anycast_addresses", "associated_server", "comment",
        "current_version", "id", "ip_space", "name", "ophid", "provider_id",
        "server", "tags", "type"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Host from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "address",
            "anycast_addresses",
            "comment",
            "current_version",
            "id",
            "name",
            "ophid",
            "provider_id",
            "type",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of associated_server
        if self.associated_server:
            _dict['associated_server'] = self.associated_server.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Host from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "address":
            obj.get("address"),
            "anycast_addresses":
            obj.get("anycast_addresses"),
            "associated_server":
            HostAssociatedServer.from_dict(obj["associated_server"])
            if obj.get("associated_server") is not None else None,
            "comment":
            obj.get("comment"),
            "current_version":
            obj.get("current_version"),
            "id":
            obj.get("id"),
            "ip_space":
            obj.get("ip_space"),
            "name":
            obj.get("name"),
            "ophid":
            obj.get("ophid"),
            "provider_id":
            obj.get("provider_id"),
            "server":
            obj.get("server"),
            "tags":
            obj.get("tags"),
            "type":
            obj.get("type")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
