# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.inheritance_inherited_u_int32 import InheritanceInheritedUInt32
from ipam.models.inherited_asm_enable_block import InheritedAsmEnableBlock
from ipam.models.inherited_asm_growth_block import InheritedAsmGrowthBlock
from typing import Optional, Set
from typing_extensions import Self


class InheritedASMConfig(BaseModel):
    """
    The inheritance configuration for the __ASMConfig__ object.
    """ # noqa: E501
    asm_enable_block: Optional[InheritedAsmEnableBlock] = Field(
        default=None,
        description=
        "The block of ASM fields: _enable_, _enable_notification_, _reenable_date_."
    )
    asm_growth_block: Optional[InheritedAsmGrowthBlock] = Field(
        default=None,
        description="The block of ASM fields: _growth_factor_, _growth_type_.")
    asm_threshold: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "ASM shows the number of addresses forecast to be used _forecast_period_ days in the future, if it is greater than _asm_threshold_percent_ * _dhcp_total_ (see _dhcp_utilization_) then the subnet is flagged."
    )
    forecast_period: Optional[InheritanceInheritedUInt32] = Field(
        default=None, description="The forecast period in days.")
    history: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The minimum amount of history needed before ASM can run on this subnet."
    )
    min_total: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The minimum size of range needed for ASM to run on this subnet.")
    min_unused: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The minimum percentage of addresses that must be available outside of the DHCP ranges and fixed addresses when making a suggested change."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "asm_enable_block", "asm_growth_block", "asm_threshold",
        "forecast_period", "history", "min_total", "min_unused"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InheritedASMConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of asm_enable_block
        if self.asm_enable_block:
            _dict['asm_enable_block'] = self.asm_enable_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asm_growth_block
        if self.asm_growth_block:
            _dict['asm_growth_block'] = self.asm_growth_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asm_threshold
        if self.asm_threshold:
            _dict['asm_threshold'] = self.asm_threshold.to_dict()
        # override the default output from pydantic by calling `to_dict()` of forecast_period
        if self.forecast_period:
            _dict['forecast_period'] = self.forecast_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of history
        if self.history:
            _dict['history'] = self.history.to_dict()
        # override the default output from pydantic by calling `to_dict()` of min_total
        if self.min_total:
            _dict['min_total'] = self.min_total.to_dict()
        # override the default output from pydantic by calling `to_dict()` of min_unused
        if self.min_unused:
            _dict['min_unused'] = self.min_unused.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InheritedASMConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asm_enable_block":
            InheritedAsmEnableBlock.from_dict(obj["asm_enable_block"])
            if obj.get("asm_enable_block") is not None else None,
            "asm_growth_block":
            InheritedAsmGrowthBlock.from_dict(obj["asm_growth_block"])
            if obj.get("asm_growth_block") is not None else None,
            "asm_threshold":
            InheritanceInheritedUInt32.from_dict(obj["asm_threshold"])
            if obj.get("asm_threshold") is not None else None,
            "forecast_period":
            InheritanceInheritedUInt32.from_dict(obj["forecast_period"])
            if obj.get("forecast_period") is not None else None,
            "history":
            InheritanceInheritedUInt32.from_dict(obj["history"])
            if obj.get("history") is not None else None,
            "min_total":
            InheritanceInheritedUInt32.from_dict(obj["min_total"])
            if obj.get("min_total") is not None else None,
            "min_unused":
            InheritanceInheritedUInt32.from_dict(obj["min_unused"])
            if obj.get("min_unused") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
