# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ipam.models.ddns_zone import DDNSZone
from ipam.models.dhcp_config import DHCPConfig
from ipam.models.kerberos_key import KerberosKey
from ipam.models.option_item import OptionItem
from ipam.models.server_inheritance import ServerInheritance
from typing import Optional, Set
from typing_extensions import Self


class Server(BaseModel):
    """
    A DHCP Config Profile (_dhcp/server_) is a named configuration for specified list of hosts.
    """ # noqa: E501
    client_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name. It uses the typical Kerberos notation: <SERVICE-NAME>/<server-domain-name>@<REALM>.  Defaults to empty."
    )
    comment: Optional[StrictStr] = Field(
        default=None,
        description=
        "The description for the DHCP Config Profile. May contain 0 to 1024 characters. Can include UTF-8."
    )
    created_at: Optional[datetime] = Field(
        default=None, description="Time when the object has been created.")
    ddns_client_update: Optional[StrictStr] = Field(
        default=None,
        description=
        "Controls who does the DDNS updates.  Valid values are: * _client_: DHCP server updates DNS if requested by client. * _server_: DHCP server always updates DNS, overriding an update request from the client, unless the client requests no updates. * _ignore_: DHCP server always updates DNS, even if the client says not to. * _over_client_update_: Same as _server_. DHCP server always updates DNS, overriding an update request from the client, unless the client requests no updates. * _over_no_update_: DHCP server updates DNS even if the client requests that no updates be done. If the client requests to do the update, DHCP server allows it.  Defaults to _client_."
    )
    ddns_conflict_resolution_mode: Optional[StrictStr] = Field(
        default=None,
        description=
        "The mode used for resolving conflicts while performing DDNS updates.  Valid values are: * _check_with_dhcid_: It includes adding a DHCID record and checking that record via conflict detection as per RFC 4703. * _no_check_with_dhcid_: This will ignore conflict detection but add a DHCID record when creating/updating an entry. * _check_exists_with_dhcid_: This will check if there is an existing DHCID record but does not verify the value of the record matches the update. This will also update the DHCID record for the entry. * _no_check_without_dhcid_: This ignores conflict detection and will not add a DHCID record when creating/updating a DDNS entry.  Defaults to _check_with_dhcid_."
    )
    ddns_domain: Optional[StrictStr] = Field(
        default=None,
        description=
        "The domain suffix for DDNS updates. FQDN, may be empty.  Required if _ddns_enabled_ is true.  Defaults to empty."
    )
    ddns_enabled: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates if DDNS updates should be performed for leases. All other _ddns_*_ configuration is ignored when this flag is unset.  At a minimum, _ddns_domain_ and _ddns_zones_ must be configured to enable DDNS.  Defaults to _false_."
    )
    ddns_generate_name: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates if DDNS should generate a hostname when not supplied by the client.  Defaults to _false_."
    )
    ddns_generated_prefix: Optional[StrictStr] = Field(
        default=None,
        description=
        "The prefix used in the generation of an FQDN.  When generating a name, DHCP server will construct the name in the format: [ddns-generated-prefix]-[address-text].[ddns-qualifying-suffix]. where address-text is simply the lease IP address converted to a hyphenated string.  Defaults to \"myhost\"."
    )
    ddns_send_updates: Optional[StrictBool] = Field(
        default=None,
        description=
        "Determines if DDNS updates are enabled at the server level. Defaults to _true_."
    )
    ddns_ttl_percent: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description=
        "DDNS TTL value - to be calculated as a simple percentage of the lease's lifetime, using the parameter's value as the percentage. It is specified as a percentage (e.g. 25, 75). Defaults to unspecified."
    )
    ddns_update_on_renew: Optional[StrictBool] = Field(
        default=None,
        description=
        "Instructs the DHCP server to always update the DNS information when a lease is renewed even if its DNS information has not changed.  Defaults to _false_."
    )
    ddns_use_conflict_resolution: Optional[StrictBool] = Field(
        default=None,
        description=
        "When true, DHCP server will apply conflict resolution, as described in RFC 4703, when attempting to fulfill the update request.  When false, DHCP server will simply attempt to update the DNS entries per the request, regardless of whether or not they conflict with existing entries owned by other DHCP4 clients.  Defaults to _true_."
    )
    ddns_zones: Optional[List[DDNSZone]] = Field(
        default=None,
        description=
        "The DNS zones that DDNS updates can be sent to. There is no resolver fallback. The target zone must be explicitly configured for the update to be performed.  Updates are sent to the closest enclosing zone.  Error if _ddns_enabled_ is _true_ and the _ddns_domain_ does not have a corresponding entry in _ddns_zones_.  Error if there are items with duplicate zone in the list.  Defaults to empty list."
    )
    dhcp_config: Optional[DHCPConfig] = Field(
        default=None,
        description=
        "The DHCP configuration for the profile. This controls how leases are issued."
    )
    dhcp_options: Optional[List[OptionItem]] = Field(
        default=None,
        description=
        "The list of DHCP options or group of options for IPv4. An option list is ordered and may include both option groups and specific options. Multiple occurences of the same option or group is not an error. The last occurence of an option in the list will be used.  Error if the graph of referenced groups contains cycles.  Defaults to empty list."
    )
    dhcp_options_v6: Optional[List[OptionItem]] = Field(
        default=None,
        description=
        "The list of DHCP options or group of options for IPv6. An option list is ordered and may include both option groups and specific options. Multiple occurences of the same option or group is not an error. The last occurence of an option in the list will be used.  Error if the graph of referenced groups contains cycles.  Defaults to empty list."
    )
    gss_tsig_fallback: Optional[StrictBool] = Field(
        default=None,
        description=
        "The behavior when GSS-TSIG should be used (a matching external DNS server is configured) but no GSS-TSIG key is available. If configured to _false_ (the default) this DNS server is skipped, if configured to _true_ the DNS server is ignored and the DNS update is sent with the configured DHCP-DDNS protection e.g. TSIG key or without any protection when none was configured.  Defaults to _false_."
    )
    header_option_filename: Optional[StrictStr] = Field(
        default=None,
        description="The configuration for header option filename field.")
    header_option_server_address: Optional[StrictStr] = Field(
        default=None,
        description="The configuration for header option server address field."
    )
    header_option_server_name: Optional[StrictStr] = Field(
        default=None,
        description="The configuration for header option server name field.")
    hostname_rewrite_char: Optional[StrictStr] = Field(
        default=None,
        description=
        "The character to replace non-matching characters with, when hostname rewrite is enabled.  Any single ASCII character or no character if the invalid characters should be removed without replacement.  Defaults to \"-\"."
    )
    hostname_rewrite_enabled: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates if client supplied hostnames will be rewritten prior to DDNS update by replacing every character that does not match _hostname_rewrite_regex_ by _hostname_rewrite_char_.  Defaults to _false_."
    )
    hostname_rewrite_regex: Optional[StrictStr] = Field(
        default=None,
        description=
        "The regex bracket expression to match valid characters.  Must begin with \"[\" and end with \"]\" and be a compilable POSIX regex.  Defaults to \"[^a-zA-Z0-9_.]\"."
    )
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    inheritance_sources: Optional[ServerInheritance] = Field(
        default=None, description="The inheritance configuration.")
    kerberos_kdc: Optional[StrictStr] = Field(
        default=None,
        description=
        "Address of Kerberos Key Distribution Center.  Defaults to empty.")
    kerberos_keys: Optional[List[KerberosKey]] = Field(
        default=None,
        description=
        "_kerberos_keys_ contains a list of keys for GSS-TSIG signed dynamic updates.  Defaults to empty."
    )
    kerberos_rekey_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) the keys for each configured external DNS server are checked for rekeying, i.e. a new key is created to replace the current usable one when its age is greater than the _kerberos_rekey_interval_ value.  Defaults to 120 seconds."
    )
    kerberos_retry_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) to retry to create a key if any error occurred previously for any configured external DNS server.  Defaults to 30 seconds."
    )
    kerberos_tkey_lifetime: Optional[StrictInt] = Field(
        default=None,
        description=
        "Lifetime (in seconds) of GSS-TSIG keys in the TKEY protocol.  Defaults to 160 seconds."
    )
    kerberos_tkey_protocol: Optional[StrictStr] = Field(
        default=None,
        description=
        "Determines which protocol is used to establish the security context with the external DNS servers, TCP or UDP.  Defaults to _tcp_."
    )
    name: StrictStr = Field(
        description=
        "The name of the DHCP Config Profile. Must contain 1 to 256 characters. Can include UTF-8."
    )
    profile_type: Optional[StrictStr] = Field(
        default=None,
        description=
        "The type of server object.  Defaults to _server_.  Valid values are: * _server_: The server profile type. * _subnet_: The subnet profile type."
    )
    server_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name of the external DNS server that will receive updates.  Defaults to empty."
    )
    tags: Optional[Dict[str, Any]] = Field(
        default=None,
        description="The tags for the DHCP Config Profile in JSON format.")
    updated_at: Optional[datetime] = Field(
        default=None,
        description=
        "Time when the object has been updated. Equals to _created_at_ if not updated after creation."
    )
    vendor_specific_option_option_space: Optional[StrictStr] = Field(
        default=None, description="The resource identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "client_principal", "comment", "created_at", "ddns_client_update",
        "ddns_conflict_resolution_mode", "ddns_domain", "ddns_enabled",
        "ddns_generate_name", "ddns_generated_prefix", "ddns_send_updates",
        "ddns_ttl_percent", "ddns_update_on_renew",
        "ddns_use_conflict_resolution", "ddns_zones", "dhcp_config",
        "dhcp_options", "dhcp_options_v6", "gss_tsig_fallback",
        "header_option_filename", "header_option_server_address",
        "header_option_server_name", "hostname_rewrite_char",
        "hostname_rewrite_enabled", "hostname_rewrite_regex", "id",
        "inheritance_sources", "kerberos_kdc", "kerberos_keys",
        "kerberos_rekey_interval", "kerberos_retry_interval",
        "kerberos_tkey_lifetime", "kerberos_tkey_protocol", "name",
        "profile_type", "server_principal", "tags", "updated_at",
        "vendor_specific_option_option_space"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Server from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "id",
            "updated_at",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ddns_zones (list)
        _items = []
        if self.ddns_zones:
            for _item in self.ddns_zones:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ddns_zones'] = _items
        # override the default output from pydantic by calling `to_dict()` of dhcp_config
        if self.dhcp_config:
            _dict['dhcp_config'] = self.dhcp_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dhcp_options (list)
        _items = []
        if self.dhcp_options:
            for _item in self.dhcp_options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dhcp_options'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dhcp_options_v6 (list)
        _items = []
        if self.dhcp_options_v6:
            for _item in self.dhcp_options_v6:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dhcp_options_v6'] = _items
        # override the default output from pydantic by calling `to_dict()` of inheritance_sources
        if self.inheritance_sources:
            _dict['inheritance_sources'] = self.inheritance_sources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in kerberos_keys (list)
        _items = []
        if self.kerberos_keys:
            for _item in self.kerberos_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['kerberos_keys'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Server from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_principal":
            obj.get("client_principal"),
            "comment":
            obj.get("comment"),
            "created_at":
            obj.get("created_at"),
            "ddns_client_update":
            obj.get("ddns_client_update"),
            "ddns_conflict_resolution_mode":
            obj.get("ddns_conflict_resolution_mode"),
            "ddns_domain":
            obj.get("ddns_domain"),
            "ddns_enabled":
            obj.get("ddns_enabled"),
            "ddns_generate_name":
            obj.get("ddns_generate_name"),
            "ddns_generated_prefix":
            obj.get("ddns_generated_prefix"),
            "ddns_send_updates":
            obj.get("ddns_send_updates"),
            "ddns_ttl_percent":
            obj.get("ddns_ttl_percent"),
            "ddns_update_on_renew":
            obj.get("ddns_update_on_renew"),
            "ddns_use_conflict_resolution":
            obj.get("ddns_use_conflict_resolution"),
            "ddns_zones":
            [DDNSZone.from_dict(_item) for _item in obj["ddns_zones"]]
            if obj.get("ddns_zones") is not None else None,
            "dhcp_config":
            DHCPConfig.from_dict(obj["dhcp_config"])
            if obj.get("dhcp_config") is not None else None,
            "dhcp_options":
            [OptionItem.from_dict(_item) for _item in obj["dhcp_options"]]
            if obj.get("dhcp_options") is not None else None,
            "dhcp_options_v6":
            [OptionItem.from_dict(_item) for _item in obj["dhcp_options_v6"]]
            if obj.get("dhcp_options_v6") is not None else None,
            "gss_tsig_fallback":
            obj.get("gss_tsig_fallback"),
            "header_option_filename":
            obj.get("header_option_filename"),
            "header_option_server_address":
            obj.get("header_option_server_address"),
            "header_option_server_name":
            obj.get("header_option_server_name"),
            "hostname_rewrite_char":
            obj.get("hostname_rewrite_char"),
            "hostname_rewrite_enabled":
            obj.get("hostname_rewrite_enabled"),
            "hostname_rewrite_regex":
            obj.get("hostname_rewrite_regex"),
            "id":
            obj.get("id"),
            "inheritance_sources":
            ServerInheritance.from_dict(obj["inheritance_sources"])
            if obj.get("inheritance_sources") is not None else None,
            "kerberos_kdc":
            obj.get("kerberos_kdc"),
            "kerberos_keys":
            [KerberosKey.from_dict(_item) for _item in obj["kerberos_keys"]]
            if obj.get("kerberos_keys") is not None else None,
            "kerberos_rekey_interval":
            obj.get("kerberos_rekey_interval"),
            "kerberos_retry_interval":
            obj.get("kerberos_retry_interval"),
            "kerberos_tkey_lifetime":
            obj.get("kerberos_tkey_lifetime"),
            "kerberos_tkey_protocol":
            obj.get("kerberos_tkey_protocol"),
            "name":
            obj.get("name"),
            "profile_type":
            obj.get("profile_type"),
            "server_principal":
            obj.get("server_principal"),
            "tags":
            obj.get("tags"),
            "updated_at":
            obj.get("updated_at"),
            "vendor_specific_option_option_space":
            obj.get("vendor_specific_option_option_space")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
