# coding: utf-8

"""
    IPAM Federation API

    The DDI IPAM Federation application enables a SaaS administrator to manage multiple IPAM systems from one central control point CSP.    

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from ipam_federation.models.create_next_available_federated_block_response import CreateNextAvailableFederatedBlockResponse
from ipam_federation.models.create_next_available_overlapping_block_response import CreateNextAvailableOverlappingBlockResponse
from ipam_federation.models.create_next_available_reserved_block_response import CreateNextAvailableReservedBlockResponse
from ipam_federation.models.list_next_available_federated_block_response import ListNextAvailableFederatedBlockResponse
from ipam_federation.models.next_available_block_request import NextAvailableBlockRequest
from ipam_federation import models

from universal_ddi_client.api_client import ApiClient, RequestSerialized
from universal_ddi_client.api_response import ApiResponse
from universal_ddi_client.rest import RESTResponseType


class NextAvailableFederatedBlockApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_next_available_federated_blocks(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateNextAvailableFederatedBlockResponse:
        """Retrieve the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_federated_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_next_available_federated_blocks_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateNextAvailableFederatedBlockResponse]:
        """Retrieve the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_federated_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_next_available_federated_blocks_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_federated_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_next_available_federated_blocks_serialize(
        self,
        id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = self.api_client.path_param_value('id', id)
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['ApiKeyAuth']

        return self.api_client.param_serialize(
            method='POST',
            base_path='/api/ddi/v1',
            resource_path=
            '/federation/federated_block/{id}/next_available_federated_block',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def create_next_available_overlapping_blocks(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateNextAvailableOverlappingBlockResponse:
        """Retrieve the next available overlapping block.

        Use this method to generate the next \"n\" available __OverlappingBlock__ object with user specified predicates. The response will be \"n\" __OverlappingBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_overlapping_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableOverlappingBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_next_available_overlapping_blocks_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateNextAvailableOverlappingBlockResponse]:
        """Retrieve the next available overlapping block.

        Use this method to generate the next \"n\" available __OverlappingBlock__ object with user specified predicates. The response will be \"n\" __OverlappingBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_overlapping_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableOverlappingBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_next_available_overlapping_blocks_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve the next available overlapping block.

        Use this method to generate the next \"n\" available __OverlappingBlock__ object with user specified predicates. The response will be \"n\" __OverlappingBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_overlapping_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableOverlappingBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_next_available_overlapping_blocks_serialize(
        self,
        id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = self.api_client.path_param_value('id', id)
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['ApiKeyAuth']

        return self.api_client.param_serialize(
            method='POST',
            base_path='/api/ddi/v1',
            resource_path=
            '/federation/federated_block/{id}/next_available_overlapping_block',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def create_next_available_reserved_blocks(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateNextAvailableReservedBlockResponse:
        """Retrieve the next available reserved block.

        Use this method to generate the next \"n\" available __ReservedBlock__ object with user specified predicates. The response will be \"n\" __ReservedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_reserved_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableReservedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_next_available_reserved_blocks_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateNextAvailableReservedBlockResponse]:
        """Retrieve the next available reserved block.

        Use this method to generate the next \"n\" available __ReservedBlock__ object with user specified predicates. The response will be \"n\" __ReservedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_reserved_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableReservedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_next_available_reserved_blocks_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        body: NextAvailableBlockRequest,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve the next available reserved block.

        Use this method to generate the next \"n\" available __ReservedBlock__ object with user specified predicates. The response will be \"n\" __ReservedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param body: (required)
        :type body: NextAvailableBlockRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_next_available_reserved_blocks_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateNextAvailableReservedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_next_available_reserved_blocks_serialize(
        self,
        id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = self.api_client.path_param_value('id', id)
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['ApiKeyAuth']

        return self.api_client.param_serialize(
            method='POST',
            base_path='/api/ddi/v1',
            resource_path=
            '/federation/federated_block/{id}/next_available_reserved_block',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_next_available_federated_blocks(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        cidr: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The CIDR of the federated block. This is required, if _address_ does not specify it in its input."
            )] = None,
        count: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The count of __Block__ required. If not provided, it will default to 1."
            )] = None,
        name: Annotated[Optional[StrictStr],
                        Field(description="The name to be provided.")] = None,
        comment: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListNextAvailableFederatedBlockResponse:
        """List the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param cidr: The CIDR of the federated block. This is required, if _address_ does not specify it in its input.
        :type cidr: int
        :param count: The count of __Block__ required. If not provided, it will default to 1.
        :type count: int
        :param name: The name to be provided.
        :type name: str
        :param comment: The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8.
        :type comment: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_next_available_federated_blocks_serialize(
            id=id,
            cidr=cidr,
            count=count,
            name=name,
            comment=comment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_next_available_federated_blocks_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        cidr: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The CIDR of the federated block. This is required, if _address_ does not specify it in its input."
            )] = None,
        count: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The count of __Block__ required. If not provided, it will default to 1."
            )] = None,
        name: Annotated[Optional[StrictStr],
                        Field(description="The name to be provided.")] = None,
        comment: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListNextAvailableFederatedBlockResponse]:
        """List the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param cidr: The CIDR of the federated block. This is required, if _address_ does not specify it in its input.
        :type cidr: int
        :param count: The count of __Block__ required. If not provided, it will default to 1.
        :type count: int
        :param name: The name to be provided.
        :type name: str
        :param comment: The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8.
        :type comment: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_next_available_federated_blocks_serialize(
            id=id,
            cidr=cidr,
            count=count,
            name=name,
            comment=comment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_next_available_federated_blocks_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(description=
                  "An application specific resource identity of a resource")],
        cidr: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The CIDR of the federated block. This is required, if _address_ does not specify it in its input."
            )] = None,
        count: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "The count of __Block__ required. If not provided, it will default to 1."
            )] = None,
        name: Annotated[Optional[StrictStr],
                        Field(description="The name to be provided.")] = None,
        comment: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List the next available federated block.

        Use this method to generate the next \"n\" available __FederatedBlock__ object with user specified predicates. The response will be \"n\" __FederatedBlock__ objects.

        :param id: An application specific resource identity of a resource (required)
        :type id: str
        :param cidr: The CIDR of the federated block. This is required, if _address_ does not specify it in its input.
        :type cidr: int
        :param count: The count of __Block__ required. If not provided, it will default to 1.
        :type count: int
        :param name: The name to be provided.
        :type name: str
        :param comment: The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8.
        :type comment: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_next_available_federated_blocks_serialize(
            id=id,
            cidr=cidr,
            count=count,
            name=name,
            comment=comment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListNextAvailableFederatedBlockResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_next_available_federated_blocks_serialize(
        self,
        id,
        cidr,
        count,
        name,
        comment,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = self.api_client.path_param_value('id', id)
        # process the query parameters
        if cidr is not None:

            _query_params.append(('cidr', cidr))

        if count is not None:

            _query_params.append(('count', count))

        if name is not None:

            _query_params.append(('name', name))

        if comment is not None:

            _query_params.append(('comment', comment))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # authentication setting
        _auth_settings: List[str] = ['ApiKeyAuth']

        return self.api_client.param_serialize(
            method='GET',
            base_path='/api/ddi/v1',
            resource_path=
            '/federation/federated_block/{id}/next_available_federated_block',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)
