# coding: utf-8

"""
    IPAM Federation API

    The DDI IPAM Federation application enables a SaaS administrator to manage multiple IPAM systems from one central control point CSP.    

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self


class NextAvailableBlockRequest(BaseModel):
    """
    NextAvailableBlockRequest
    """

  # noqa: E501
    cidr: Optional[Annotated[int, Field(le=128, strict=True, ge=1)]] = Field(
        default=None,
        description=
        "The CIDR of the federated block. This is required, if _address_ does not specify it in its input."
    )
    comment: Optional[StrictStr] = Field(
        default=None,
        description=
        "The description for the _federation/federated_block_. May contain 0 to 1024 characters. Can include UTF-8."
    )
    count: Optional[StrictInt] = Field(
        default=None,
        description=
        "The count of __Block__ required. If not provided, it will default to 1."
    )
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    name: Optional[StrictStr] = Field(default=None,
                                      description="The name to be provided.")
    tags: Optional[Dict[str, Any]] = Field(
        default=None,
        description="The tags for the federated block in JSON format.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "cidr", "comment", "count", "id", "name", "tags"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NextAvailableBlockRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "id",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NextAvailableBlockRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cidr": obj.get("cidr"),
            "comment": obj.get("comment"),
            "count": obj.get("count"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "tags": obj.get("tags")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
