"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentAlias = exports.AgentAliasBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const iam = require("aws-cdk-lib/aws-iam");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/******************************************************************************
 *                        ABSTRACT BASE CLASS
 *****************************************************************************/
/**
 * Abstract base class for an Agent.
 * Contains methods and attributes valid for Agents either created with CDK or imported.
 */
class AgentAliasBase extends aws_cdk_lib_1.Resource {
    /**
     * Grant the given principal identity permissions to perform actions on this agent alias.
     * Note: This grant will only work when the grantee is in the same AWS account
     * where the agent alias is defined. Cross-account grant is not supported.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.aliasArn],
            scope: this,
        });
    }
    /**
     * Grant the given identity permissions to invoke the agent alias.
     * Note: This grant will only work when the grantee is in the same AWS account
     * where the agent alias is defined. Cross-account invocation is not supported.
     */
    grantInvoke(grantee) {
        return this.grant(grantee, 'bedrock:InvokeAgent');
    }
    /**
     * Grant the given identity permissions to get the agent alias.
     * Note: This grant will only work when the grantee is in the same AWS account
     * where the agent alias is defined. Cross-account agent read is not supported.
     */
    grantGet(grantee) {
        return this.grant(grantee, 'bedrock:GetAgentAlias');
    }
    /**
     * Define an EventBridge rule that triggers when something happens to this agent alias
     *
     * Requires that there exists at least one CloudTrail Trail in your account
     * that captures the event. This method will not create the Trail.
     *
     * @param id The id of the rule
     * @param options Options for adding the rule
     */
    onCloudTrailEvent(id, options = {}) {
        const rule = new events.Rule(this, id, options);
        rule.addTarget(options.target);
        rule.addEventPattern({
            source: ['aws.bedrock'],
            detailType: ['AWS API Call via CloudTrail'],
            detail: {
                requestParameters: {
                    agentAliasId: [this.aliasId],
                },
            },
        });
        return rule;
    }
}
exports.AgentAliasBase = AgentAliasBase;
_a = JSII_RTTI_SYMBOL_1;
AgentAliasBase[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.AgentAliasBase", version: "2.204.0-alpha.0" };
/******************************************************************************
 *                        NEW CONSTRUCT DEFINITION
 *****************************************************************************/
/**
 * Class to create an Agent Alias with CDK.
 * @cloudformationResource AWS::Bedrock::AgentAlias
 */
let AgentAlias = class AgentAlias extends AgentAliasBase {
    // ------------------------------------------------------
    // Imports
    // ------------------------------------------------------
    /**
     * Brings an Agent Alias from an existing one created outside of CDK.
     */
    static fromAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_AgentAliasAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAttributes);
            }
            throw error;
        }
        class Import extends AgentAliasBase {
            constructor() {
                super(...arguments);
                this.agent = attrs.agent;
                this.aliasId = attrs.aliasId;
                this.aliasName = attrs.aliasName;
                this.aliasArn = aws_cdk_lib_1.Stack.of(scope).formatArn({
                    resource: 'agent-alias',
                    service: 'bedrock',
                    resourceName: `${attrs.agent.agentId}/${attrs.aliasId}`,
                    arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
                });
            }
        }
        return new Import(scope, id);
    }
    // ------------------------------------------------------
    // CONSTRUCTOR
    // ------------------------------------------------------
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_AgentAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AgentAlias);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        // ------------------------------------------------------
        // Set properties or defaults
        // ------------------------------------------------------
        // see https://github.com/awslabs/generative-ai-cdk-constructs/issues/947 - The default name without any version update may result in this error.
        // see https://github.com/awslabs/generative-ai-cdk-constructs/pull/1116 - If no agent version is provided then update the agent description for a new version.
        this.aliasName = props.agentAliasName ?? 'latest';
        this.agent = props.agent;
        // ------------------------------------------------------
        // L1 Instantiation
        // ------------------------------------------------------
        const alias = new aws_cdk_lib_1.aws_bedrock.CfnAgentAlias(this, 'Resource', {
            agentAliasName: this.aliasName,
            agentId: this.agent.agentId,
            description: props.description,
            routingConfiguration: props.agentVersion
                ? [
                    {
                        agentVersion: props.agentVersion,
                    },
                ]
                : undefined,
        });
        this.aliasId = alias.attrAgentAliasId;
        this.aliasArn = alias.attrAgentAliasArn;
    }
};
exports.AgentAlias = AgentAlias;
_b = JSII_RTTI_SYMBOL_1;
AgentAlias[_b] = { fqn: "@aws-cdk/aws-bedrock-alpha.AgentAlias", version: "2.204.0-alpha.0" };
/** Uniquely identifies this class. */
AgentAlias.PROPERTY_INJECTION_ID = '@aws-cdk.aws-bedrock-alpha.AgentAlias';
exports.AgentAlias = AgentAlias = __decorate([
    prop_injectable_1.propertyInjectable
], AgentAlias);
//# sourceMappingURL=data:application/json;base64,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