"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentCollaboration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Class to manage agent collaboration configuration.
 */
class AgentCollaboration {
    constructor(config) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_bedrock_alpha_AgentCollaborationConfig(config);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AgentCollaboration);
            }
            throw error;
        }
        this.type = config.type;
        this.collaborators = config.collaborators;
    }
}
exports.AgentCollaboration = AgentCollaboration;
_a = JSII_RTTI_SYMBOL_1;
AgentCollaboration[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.AgentCollaboration", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWdlbnQtY29sbGFib3JhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFnZW50LWNvbGxhYm9yYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBaUJBOztHQUVHO0FBQ0gsTUFBYSxrQkFBa0I7SUFXN0IsWUFBWSxNQUFnQzs7Ozs7OytDQVhqQyxrQkFBa0I7Ozs7UUFZM0IsSUFBSSxDQUFDLElBQUksR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztLQUMzQzs7QUFkSCxnREFlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFnZW50Q29sbGFib3JhdG9yLCBBZ2VudENvbGxhYm9yYXRvclR5cGUgfSBmcm9tICcuL2FnZW50LWNvbGxhYm9yYXRvcic7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBmb3IgYWdlbnQgY29sbGFib3JhdGlvbiBzZXR0aW5ncy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBZ2VudENvbGxhYm9yYXRpb25Db25maWcge1xuICAvKipcbiAgICogVGhlIGNvbGxhYm9yYXRpb24gdHlwZSBmb3IgdGhlIGFnZW50LlxuICAgKi9cbiAgcmVhZG9ubHkgdHlwZTogQWdlbnRDb2xsYWJvcmF0b3JUeXBlO1xuXG4gIC8qKlxuICAgKiBDb2xsYWJvcmF0b3JzIHRoYXQgdGhpcyBhZ2VudCB3aWxsIHdvcmsgd2l0aC5cbiAgICovXG4gIHJlYWRvbmx5IGNvbGxhYm9yYXRvcnM6IEFnZW50Q29sbGFib3JhdG9yW107XG59XG5cbi8qKlxuICogQ2xhc3MgdG8gbWFuYWdlIGFnZW50IGNvbGxhYm9yYXRpb24gY29uZmlndXJhdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIEFnZW50Q29sbGFib3JhdGlvbiB7XG4gIC8qKlxuICAgKiBUaGUgY29sbGFib3JhdGlvbiB0eXBlIGZvciB0aGUgYWdlbnQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdHlwZTogQWdlbnRDb2xsYWJvcmF0b3JUeXBlO1xuXG4gIC8qKlxuICAgKiBDb2xsYWJvcmF0b3JzIHRoYXQgdGhpcyBhZ2VudCB3aWxsIHdvcmsgd2l0aC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBjb2xsYWJvcmF0b3JzOiBBZ2VudENvbGxhYm9yYXRvcltdO1xuXG4gIGNvbnN0cnVjdG9yKGNvbmZpZzogQWdlbnRDb2xsYWJvcmF0aW9uQ29uZmlnKSB7XG4gICAgdGhpcy50eXBlID0gY29uZmlnLnR5cGU7XG4gICAgdGhpcy5jb2xsYWJvcmF0b3JzID0gY29uZmlnLmNvbGxhYm9yYXRvcnM7XG4gIH1cbn1cbiJdfQ==