import { Duration } from 'aws-cdk-lib/core';
import { CfnAgent } from 'aws-cdk-lib/aws-bedrock';
/**
 * Properties for SessionSummaryConfiguration.
 */
export interface SessionSummaryMemoryProps {
    /**
     * Duration for which session summaries are retained (between 1 and 365 days)
     * @default Duration.days(30)
     */
    readonly memoryDuration?: Duration;
    /**
     * Maximum number of recent session summaries to include (min 1)
     * @default 20
     */
    readonly maxRecentSessions?: number;
}
/**
 * Memory class for managing Bedrock Agent memory configurations. Enables conversational context retention
 * across multiple sessions through session identifiers. Memory context is stored with unique
 * memory IDs per user, allowing access to conversation history and summaries. Supports viewing
 * stored sessions and clearing memory.
 *
 * @see https://docs.aws.amazon.com/bedrock/latest/userguide/agents-memory.html
 */
export declare class Memory {
    /**
     * Returns session summary memory with default configuration.
     * @default memoryDuration=Duration.days(30), maxRecentSessions=20
     */
    static readonly SESSION_SUMMARY: Memory;
    /**
     * Creates a session summary memory with custom configuration.
     * @param props Optional memory configuration properties
     * @returns Memory instance
     */
    static sessionSummary(props: SessionSummaryMemoryProps): Memory;
    private readonly memoryDuration?;
    private readonly maxRecentSessions?;
    constructor(props: SessionSummaryMemoryProps);
    /**
     * Render the memory configuration to a CloudFormation property.
     * @internal
     */
    _render(): CfnAgent.MemoryConfigurationProperty;
}
