"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomOrchestrationExecutor = exports.OrchestrationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum for orchestration types available for agents.
 */
var OrchestrationType;
(function (OrchestrationType) {
    /**
     * Default orchestration by the agent.
     */
    OrchestrationType["DEFAULT"] = "DEFAULT";
    /**
     * Custom orchestration using Lambda.
     */
    OrchestrationType["CUSTOM_ORCHESTRATION"] = "CUSTOM_ORCHESTRATION";
})(OrchestrationType || (exports.OrchestrationType = OrchestrationType = {}));
/******************************************************************************
 *                         Custom Orchestration Executor
 *****************************************************************************/
/**
 * Contains details about the Lambda function containing the orchestration logic carried
 * out upon invoking the custom orchestration.
 */
class CustomOrchestrationExecutor {
    /**
     * Defines an orchestration executor with a Lambda function containing the business logic.
     * @param lambdaFunction - Lambda function to be called by the orchestration.
     */
    static fromLambda(lambdaFunction) {
        return new CustomOrchestrationExecutor(lambdaFunction);
    }
    constructor(lambdaFunction) {
        /**
         * The type of orchestration this executor performs.
         */
        this.type = OrchestrationType.CUSTOM_ORCHESTRATION;
        this.lambdaFunction = lambdaFunction;
    }
    /**
     * Format as CFN properties
     *
     * @internal This is an internal core function and should not be called directly.
     */
    _render() {
        return {
            lambda: this.lambdaFunction?.functionArn,
        };
    }
}
exports.CustomOrchestrationExecutor = CustomOrchestrationExecutor;
_a = JSII_RTTI_SYMBOL_1;
CustomOrchestrationExecutor[_a] = { fqn: "@aws-cdk/aws-bedrock-alpha.CustomOrchestrationExecutor", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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