/**
 * Error thrown when validation fails
 */
export declare class ValidationError extends Error {
    constructor(message: string);
}
interface IntervalValidation {
    fieldName: string;
    minLength: number;
    maxLength: number;
}
interface StringLengthValidation extends IntervalValidation {
    value: string;
}
/**
 * Validates the length of a string field against minimum and maximum constraints.
 * @param value - The string value to validate
 * @param fieldName - Name of the field being validated (for error messages)
 * @param minLength - Minimum allowed length (defaults to 0)
 * @param maxLength - Maximum allowed length
 * @returns true if validation passes
 * @throws Error if validation fails with current length information
 */
export declare function validateStringFieldLength(params: StringLengthValidation): string[];
/**
 * Validates a string field against a regex pattern.
 * @param value - The string value to validate
 * @param fieldName - Name of the field being validated (for error messages)
 * @param pattern - Regular expression pattern to test against
 * @param customMessage - Optional custom error message
 * @returns true if validation passes
 * @throws Error if validation fails with detailed message
 */
export declare function validateFieldPattern(value: string, fieldName: string, pattern: RegExp, customMessage?: string): string[];
export type ValidationFn<T> = (param: T) => string[];
export declare function throwIfInvalid<T>(validationFn: ValidationFn<T>, param: T): T;
export {};
