"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3CodeCommitBackup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class S3CodeCommitBackup extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { backupBucket, schedule, computeType, repository } = props;
        const { repositoryName, repositoryCloneUrlHttp, repositoryArn } = repository;
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_5_0;
        this.backupProject = new aws_codebuild_1.Project(this, 'BackupProject', {
            environment: {
                buildImage,
                computeType: computeType || buildImage.defaultComputeType,
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                env: {
                    'git-credential-helper': 'yes',
                },
                phases: {
                    pre_build: {
                        commands: [
                            `echo "[===== Clone repository: ${repositoryName} =====]"`,
                            `git clone "${repositoryCloneUrlHttp}"`,
                        ],
                    },
                    build: {
                        commands: [
                            "dt=$(date -u '+%Y_%m_%d_%H_%M')",
                            `zipfile="${repositoryName}_backup_\${dt}_UTC.tar.gz"`,
                            `echo "Compressing repository: ${repositoryName} into file: \${zipfile} and uploading to S3 bucket: ${backupBucket.bucketName}/${repositoryName}"`,
                            `tar -zcvf "\${zipfile}" "${repositoryName}/"`,
                            `aws s3 cp "\${zipfile}" "s3://${backupBucket.bucketName}/${repositoryName}/\${zipfile}"`,
                        ],
                    },
                },
            }),
        });
        backupBucket.grantPut(this.backupProject);
        this.backupProject.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: [repositoryArn],
            actions: [
                'codecommit:BatchGet*',
                'codecommit:Get*',
                'codecommit:Describe*',
                'codecommit:List*',
                'codecommit:GitPull',
            ],
        }));
        new aws_events_1.Rule(this, 'ScheduleRule', {
            schedule,
            targets: [new aws_events_targets_1.CodeBuildProject(this.backupProject)],
        });
    }
    /**
     * Defines an event rule which triggers when a backup fails.
     */
    onBackupFailed(id, options) {
        return this.backupProject.onBuildFailed(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup starts.
     */
    onBackupStarted(id, options) {
        return this.backupProject.onBuildStarted(id, options);
    }
    /**
     * Defines an event rule which triggers when a backup complets successfully.
     */
    onBackupSucceeded(id, options) {
        return this.backupProject.onBuildSucceeded(id, options);
    }
}
exports.S3CodeCommitBackup = S3CodeCommitBackup;
_a = JSII_RTTI_SYMBOL_1;
S3CodeCommitBackup[_a] = { fqn: "@cloudcomponents/cdk-codecommit-backup.S3CodeCommitBackup", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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