from web3 import Web3
from typing import Union

class Web3Utils:
    """Utility class for Web3 operations"""
    
    @staticmethod
    def to_checksum_address(address: str) -> str:
        """Convert to checksum address"""
        return Web3.to_checksum_address(address)
    
    @staticmethod
    def is_valid_address(address: str) -> bool:
        """Check if address is valid"""
        return Web3.is_address(address)
    
    @staticmethod
    def wei_to_ether(wei_amount: int) -> float:
        """Convert wei to ether"""
        return Web3.from_wei(wei_amount, 'ether')
    
    @staticmethod
    def ether_to_wei(ether_amount: Union[float, str]) -> int:
        """Convert ether to wei"""
        return Web3.to_wei(ether_amount, 'ether')
    
    @staticmethod
    def format_transaction_value(value_wei: int, unit: str = 'ether') -> str:
        """Format transaction value for display"""
        value_eth = Web3.from_wei(value_wei, unit)
        return f"{value_eth} {unit}"