"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 5.11.1826
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_studio.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_studio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_studio.model.basic_process import BasicProcess
from vrt_lss_studio.model.experiment import Experiment
from vrt_lss_studio.model.experiment_settings import ExperimentSettings
from vrt_lss_studio.model.experiment_specification import ExperimentSpecification
from vrt_lss_studio.model.indicators import Indicators
from vrt_lss_studio.model.inline_response400 import InlineResponse400
from vrt_lss_studio.model.inline_response401 import InlineResponse401
from vrt_lss_studio.model.inline_response402 import InlineResponse402
from vrt_lss_studio.model.inline_response403 import InlineResponse403
from vrt_lss_studio.model.inline_response404 import InlineResponse404
from vrt_lss_studio.model.inline_response429 import InlineResponse429
from vrt_lss_studio.model.inline_response500 import InlineResponse500
from vrt_lss_studio.model.unique_key import UniqueKey
from vrt_lss_studio.model.universal_data import UniversalData


class ExperimentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_experiment_endpoint = _Endpoint(
            settings={
                'response_type': (UniqueKey,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments',
                'operation_id': 'create_experiment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_specification',
                ],
                'required': [
                    'experiment_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_specification':
                        (ExperimentSpecification,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'experiment_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_experiment_share_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/share',
                'operation_id': 'create_experiment_share',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_experiment_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}',
                'operation_id': 'delete_experiment',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_experiment_share_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/share',
                'operation_id': 'delete_experiment_share',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.duplicate_experiment_endpoint = _Endpoint(
            settings={
                'response_type': (UniqueKey,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/duplication',
                'operation_id': 'duplicate_experiment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'experiment_specification',
                ],
                'required': [
                    'experiment_key',
                    'experiment_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'experiment_specification':
                        (ExperimentSpecification,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'experiment_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.export_json_endpoint = _Endpoint(
            settings={
                'response_type': (UniversalData,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/export/json',
                'operation_id': 'export_json',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.export_xlsx_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/export/xlsx',
                'operation_id': 'export_xlsx',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'timezone',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'timezone',
                ]
            },
            root_map={
                'validations': {
                    ('timezone',): {

                        'inclusive_maximum': 12,
                        'inclusive_minimum': -12,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'timezone':
                        (int,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.import_json_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/import/json',
                'operation_id': 'import_json',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'universal_data',
                ],
                'required': [
                    'experiment_key',
                    'universal_data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'universal_data':
                        (UniversalData,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'universal_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.import_json_url_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/import/json_url',
                'operation_id': 'import_json_url',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'url',
                ],
                'required': [
                    'experiment_key',
                    'url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'url',
                ]
            },
            root_map={
                'validations': {
                    ('url',): {
                        'max_length': 512,
                        'min_length': 10,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'url':
                        (str,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'url': 'url',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'url': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.import_xlsx_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/import/xlsx',
                'operation_id': 'import_xlsx',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'body',
                    'timezone',
                ],
                'required': [
                    'experiment_key',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'timezone',
                ]
            },
            root_map={
                'validations': {
                    ('timezone',): {

                        'inclusive_maximum': 12,
                        'inclusive_minimum': -12,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'body':
                        (str,),
                    'timezone':
                        (int,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'timezone': 'timezone',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'body': 'body',
                    'timezone': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ]
            },
            api_client=api_client
        )
        self.read_experiment_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}',
                'operation_id': 'read_experiment',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.run_experiment_calculation_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/calculation/{process_name}',
                'operation_id': 'run_experiment_calculation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'process_name',
                ],
                'required': [
                    'experiment_key',
                    'process_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'process_name':
                        (BasicProcess,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'process_name': 'process_name',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'process_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.run_experiment_validation_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/validation/{process_name}',
                'operation_id': 'run_experiment_validation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'process_name',
                ],
                'required': [
                    'experiment_key',
                    'process_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'process_name':
                        (BasicProcess,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'process_name': 'process_name',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'process_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.stop_experiment_calculation_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/calculation',
                'operation_id': 'stop_experiment_calculation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_experiment_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}',
                'operation_id': 'update_experiment',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'experiment_specification',
                ],
                'required': [
                    'experiment_key',
                    'experiment_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'experiment_specification':
                        (ExperimentSpecification,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'experiment_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_experiment_indicators_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/indicators',
                'operation_id': 'update_experiment_indicators',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'indicators',
                ],
                'required': [
                    'experiment_key',
                    'indicators',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'indicators':
                        (Indicators,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'indicators': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_experiment_settings_endpoint = _Endpoint(
            settings={
                'response_type': (Experiment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/settings',
                'operation_id': 'update_experiment_settings',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'experiment_settings',
                ],
                'required': [
                    'experiment_key',
                    'experiment_settings',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'experiment_settings':
                        (ExperimentSettings,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'experiment_settings': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_experiment(
        self,
        experiment_specification,
        **kwargs
    ):
        """Create experiment  

        Create new experiment.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment(experiment_specification, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_specification (ExperimentSpecification): Experiment create request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UniqueKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_specification'] = \
            experiment_specification
        return self.create_experiment_endpoint.call_with_http_info(**kwargs)

    def create_experiment_share(
        self,
        experiment_key,
        **kwargs
    ):
        """Share experiment  

        Share experiment.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_experiment_share(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.create_experiment_share_endpoint.call_with_http_info(**kwargs)

    def delete_experiment(
        self,
        experiment_key,
        **kwargs
    ):
        """Experiment removal  

        Experiment removal by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.delete_experiment_endpoint.call_with_http_info(**kwargs)

    def delete_experiment_share(
        self,
        experiment_key,
        **kwargs
    ):
        """Stop sharing  

        Stop experiment sharing.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_experiment_share(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.delete_experiment_share_endpoint.call_with_http_info(**kwargs)

    def duplicate_experiment(
        self,
        experiment_key,
        experiment_specification,
        **kwargs
    ):
        """Experiment duplicate  

        Experiment duplicate.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_experiment(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            experiment_specification (ExperimentSpecification): Experiment duplicate request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UniqueKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['experiment_specification'] = \
            experiment_specification
        return self.duplicate_experiment_endpoint.call_with_http_info(**kwargs)

    def export_json(
        self,
        experiment_key,
        **kwargs
    ):
        """Export (JSON)  

        Export data from the experiment to a VRt.Universal JSON file.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_json(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UniversalData
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.export_json_endpoint.call_with_http_info(**kwargs)

    def export_xlsx(
        self,
        experiment_key,
        **kwargs
    ):
        """Export (XLSX)  

        Export (XLSX).  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.export_xlsx(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            timezone (int): Timezone.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.export_xlsx_endpoint.call_with_http_info(**kwargs)

    def import_json(
        self,
        experiment_key,
        universal_data,
        **kwargs
    ):
        """Import (JSON)  

        Importing new data from a VRt.Universal JSON file. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json(experiment_key, universal_data, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            universal_data (UniversalData): Data (JSON).

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['universal_data'] = \
            universal_data
        return self.import_json_endpoint.call_with_http_info(**kwargs)

    def import_json_url(
        self,
        experiment_key,
        url,
        **kwargs
    ):
        """Import (JSON) from URL  

        Importing new data from a VRt.Universal JSON file by url. If the entity is already present in the experiment (determined by its key), it is updated, if not, a new one is created.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_json_url(experiment_key, url, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            url (str): Url to json file.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['url'] = \
            url
        return self.import_json_url_endpoint.call_with_http_info(**kwargs)

    def import_xlsx(
        self,
        experiment_key,
        body,
        **kwargs
    ):
        """Import (XLSX)  

        Import (XLSX).  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.import_xlsx(experiment_key, body, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            body (str): Data (XLSX).

        Keyword Args:
            timezone (int): Timezone.. [optional] if omitted the server will use the default value of 0
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['body'] = \
            body
        return self.import_xlsx_endpoint.call_with_http_info(**kwargs)

    def read_experiment(
        self,
        experiment_key,
        **kwargs
    ):
        """Reading experiment  

        Getting experiment information by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_experiment(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.read_experiment_endpoint.call_with_http_info(**kwargs)

    def run_experiment_calculation(
        self,
        experiment_key,
        process_name,
        **kwargs
    ):
        """Run calculation  

        Experiment calculation run.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_calculation(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            process_name (BasicProcess): Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['process_name'] = \
            process_name
        return self.run_experiment_calculation_endpoint.call_with_http_info(**kwargs)

    def run_experiment_validation(
        self,
        experiment_key,
        process_name,
        **kwargs
    ):
        """Run validation  

        Experiment validation run.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_experiment_validation(experiment_key, process_name, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            process_name (BasicProcess): Process name:   * `PLAN` - планирование   * `REPLAN` - перепланирование   * `ACTUALIZE` - актуализация 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['process_name'] = \
            process_name
        return self.run_experiment_validation_endpoint.call_with_http_info(**kwargs)

    def stop_experiment_calculation(
        self,
        experiment_key,
        **kwargs
    ):
        """Calculation stop  

        Calculation stop.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_experiment_calculation(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.stop_experiment_calculation_endpoint.call_with_http_info(**kwargs)

    def update_experiment(
        self,
        experiment_key,
        experiment_specification,
        **kwargs
    ):
        """Experiment update  

        Rename \\ move experiment.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment(experiment_key, experiment_specification, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            experiment_specification (ExperimentSpecification): Experiment specification update request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['experiment_specification'] = \
            experiment_specification
        return self.update_experiment_endpoint.call_with_http_info(**kwargs)

    def update_experiment_indicators(
        self,
        experiment_key,
        indicators,
        **kwargs
    ):
        """Indicators update  

        Updating the experiment indicators.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_indicators(experiment_key, indicators, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            indicators (Indicators): Indicators update request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['indicators'] = \
            indicators
        return self.update_experiment_indicators_endpoint.call_with_http_info(**kwargs)

    def update_experiment_settings(
        self,
        experiment_key,
        experiment_settings,
        **kwargs
    ):
        """Settings update  

        Settings update.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_experiment_settings(experiment_key, experiment_settings, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            experiment_settings (ExperimentSettings): Experiment settings update request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Experiment
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['experiment_settings'] = \
            experiment_settings
        return self.update_experiment_settings_endpoint.call_with_http_info(**kwargs)

