"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 5.11.1826
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_studio.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_studio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_studio.model.experiment_list import ExperimentList
from vrt_lss_studio.model.filesystem import Filesystem
from vrt_lss_studio.model.folder_specification import FolderSpecification
from vrt_lss_studio.model.inline_response400 import InlineResponse400
from vrt_lss_studio.model.inline_response401 import InlineResponse401
from vrt_lss_studio.model.inline_response402 import InlineResponse402
from vrt_lss_studio.model.inline_response403 import InlineResponse403
from vrt_lss_studio.model.inline_response404 import InlineResponse404
from vrt_lss_studio.model.inline_response429 import InlineResponse429
from vrt_lss_studio.model.inline_response500 import InlineResponse500
from vrt_lss_studio.model.unique_key import UniqueKey


class ExplorerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_folder_endpoint = _Endpoint(
            settings={
                'response_type': (UniqueKey,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer',
                'operation_id': 'create_folder',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'folder_specification',
                ],
                'required': [
                    'folder_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'folder_specification':
                        (FolderSpecification,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'folder_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_folder_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer/{folder_key}',
                'operation_id': 'delete_folder',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'folder_key',
                ],
                'required': [
                    'folder_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'folder_key':
                        (UniqueKey,),
                },
                'attribute_map': {
                    'folder_key': 'folder_key',
                },
                'location_map': {
                    'folder_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.duplicate_folder_endpoint = _Endpoint(
            settings={
                'response_type': (UniqueKey,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer/{folder_key}/duplication',
                'operation_id': 'duplicate_folder',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'folder_key',
                    'folder_specification',
                ],
                'required': [
                    'folder_key',
                    'folder_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'folder_key':
                        (UniqueKey,),
                    'folder_specification':
                        (FolderSpecification,),
                },
                'attribute_map': {
                    'folder_key': 'folder_key',
                },
                'location_map': {
                    'folder_key': 'path',
                    'folder_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.read_filesystem_endpoint = _Endpoint(
            settings={
                'response_type': (Filesystem,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer',
                'operation_id': 'read_filesystem',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'filter',
                ]
            },
            root_map={
                'validations': {
                    ('filter',): {
                        'max_length': 64,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                },
                'location_map': {
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_folder_endpoint = _Endpoint(
            settings={
                'response_type': (ExperimentList,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer/{folder_key}',
                'operation_id': 'read_folder',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'folder_key',
                    'filter',
                ],
                'required': [
                    'folder_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'filter',
                ]
            },
            root_map={
                'validations': {
                    ('filter',): {
                        'max_length': 64,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'folder_key':
                        (UniqueKey,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'folder_key': 'folder_key',
                    'filter': 'filter',
                },
                'location_map': {
                    'folder_key': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_folder_endpoint = _Endpoint(
            settings={
                'response_type': (Filesystem,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/explorer/{folder_key}',
                'operation_id': 'update_folder',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'folder_key',
                    'folder_specification',
                ],
                'required': [
                    'folder_key',
                    'folder_specification',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'folder_key':
                        (UniqueKey,),
                    'folder_specification':
                        (FolderSpecification,),
                },
                'attribute_map': {
                    'folder_key': 'folder_key',
                },
                'location_map': {
                    'folder_key': 'path',
                    'folder_specification': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_folder(
        self,
        folder_specification,
        **kwargs
    ):
        """Create folder  

        Create new folder.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_folder(folder_specification, async_req=True)
        >>> result = thread.get()

        Args:
            folder_specification (FolderSpecification): Folder create request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UniqueKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['folder_specification'] = \
            folder_specification
        return self.create_folder_endpoint.call_with_http_info(**kwargs)

    def delete_folder(
        self,
        folder_key,
        **kwargs
    ):
        """Folder removal  

        Folder removal by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_folder(folder_key, async_req=True)
        >>> result = thread.get()

        Args:
            folder_key (UniqueKey): Folder key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['folder_key'] = \
            folder_key
        return self.delete_folder_endpoint.call_with_http_info(**kwargs)

    def duplicate_folder(
        self,
        folder_key,
        folder_specification,
        **kwargs
    ):
        """Folder duplicate  

        Folder duplicate.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_folder(folder_key, folder_specification, async_req=True)
        >>> result = thread.get()

        Args:
            folder_key (UniqueKey): Folder key, unique identifier.
            folder_specification (FolderSpecification): Folder duplicate request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UniqueKey
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['folder_key'] = \
            folder_key
        kwargs['folder_specification'] = \
            folder_specification
        return self.duplicate_folder_endpoint.call_with_http_info(**kwargs)

    def read_filesystem(
        self,
        **kwargs
    ):
        """Getting a filesystem  

        Getting a filesystem.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_filesystem(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            filter (str): Filter for searching by text fields.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Filesystem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.read_filesystem_endpoint.call_with_http_info(**kwargs)

    def read_folder(
        self,
        folder_key,
        **kwargs
    ):
        """Experiment list  

        Getting a experiments list.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_folder(folder_key, async_req=True)
        >>> result = thread.get()

        Args:
            folder_key (UniqueKey): Folder key, unique identifier.

        Keyword Args:
            filter (str): Filter for searching by text fields.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ExperimentList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['folder_key'] = \
            folder_key
        return self.read_folder_endpoint.call_with_http_info(**kwargs)

    def update_folder(
        self,
        folder_key,
        folder_specification,
        **kwargs
    ):
        """Update folder  

        Rename \\ move folder.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_folder(folder_key, folder_specification, async_req=True)
        >>> result = thread.get()

        Args:
            folder_key (UniqueKey): Folder key, unique identifier.
            folder_specification (FolderSpecification): Folder update request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Filesystem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['folder_key'] = \
            folder_key
        kwargs['folder_specification'] = \
            folder_specification
        return self.update_folder_endpoint.call_with_http_info(**kwargs)

