"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 5.11.1826
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_studio.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_studio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_studio.model.basic_essence_key import BasicEssenceKey
from vrt_lss_studio.model.inline_response400 import InlineResponse400
from vrt_lss_studio.model.inline_response401 import InlineResponse401
from vrt_lss_studio.model.inline_response402 import InlineResponse402
from vrt_lss_studio.model.inline_response403 import InlineResponse403
from vrt_lss_studio.model.inline_response404 import InlineResponse404
from vrt_lss_studio.model.inline_response429 import InlineResponse429
from vrt_lss_studio.model.inline_response500 import InlineResponse500
from vrt_lss_studio.model.table_location_column_type import TableLocationColumnType
from vrt_lss_studio.model.table_location_filter_list import TableLocationFilterList
from vrt_lss_studio.model.table_location_list import TableLocationList
from vrt_lss_studio.model.unique_key import UniqueKey
from vrt_lss_studio.model.web_location import WebLocation
from vrt_lss_studio.model.web_location_geopoint_list import WebLocationGeopointList


class LocationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_location_endpoint = _Endpoint(
            settings={
                'response_type': (WebLocation,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations',
                'operation_id': 'create_location',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'web_location',
                ],
                'required': [
                    'experiment_key',
                    'web_location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'web_location':
                        (WebLocation,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'web_location': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_location_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations/{essence_key}',
                'operation_id': 'delete_location',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'essence_key',
                ],
                'required': [
                    'experiment_key',
                    'essence_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'essence_key':
                        (BasicEssenceKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'essence_key': 'essence_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'essence_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_location_endpoint = _Endpoint(
            settings={
                'response_type': (WebLocation,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations/{essence_key}',
                'operation_id': 'read_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'essence_key',
                ],
                'required': [
                    'experiment_key',
                    'essence_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'essence_key':
                        (BasicEssenceKey,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'essence_key': 'essence_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'essence_key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_locations_endpoint = _Endpoint(
            settings={
                'response_type': (TableLocationList,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations/list',
                'operation_id': 'read_locations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'offset',
                    'limit',
                    'sort_column',
                    'sort_direction',
                    'table_location_filter_list',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                    'sort_direction',
                ],
                'validation': [
                    'offset',
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('offset',): {

                        'inclusive_maximum': 10000000,
                        'inclusive_minimum': 0,
                    },
                    ('limit',): {

                        'inclusive_maximum': 10000000,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort_direction',): {

                        "ASC": "ASC",
                        "DESC": "DESC"
                    },
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'offset':
                        (int,),
                    'limit':
                        (int,),
                    'sort_column':
                        (TableLocationColumnType,),
                    'sort_direction':
                        (str,),
                    'table_location_filter_list':
                        (TableLocationFilterList,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                    'offset': 'offset',
                    'limit': 'limit',
                    'sort_column': 'sort_column',
                    'sort_direction': 'sort_direction',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'offset': 'query',
                    'limit': 'query',
                    'sort_column': 'query',
                    'sort_direction': 'query',
                    'table_location_filter_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.read_locations_geopoints_endpoint = _Endpoint(
            settings={
                'response_type': (WebLocationGeopointList,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations/geopoints',
                'operation_id': 'read_locations_geopoints',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'table_location_filter_list',
                ],
                'required': [
                    'experiment_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'table_location_filter_list':
                        (TableLocationFilterList,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'table_location_filter_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_location_endpoint = _Endpoint(
            settings={
                'response_type': (WebLocation,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/studio/experiments/{experiment_key}/locations',
                'operation_id': 'update_location',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'experiment_key',
                    'web_location',
                ],
                'required': [
                    'experiment_key',
                    'web_location',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'experiment_key':
                        (UniqueKey,),
                    'web_location':
                        (WebLocation,),
                },
                'attribute_map': {
                    'experiment_key': 'experiment_key',
                },
                'location_map': {
                    'experiment_key': 'path',
                    'web_location': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_location(
        self,
        experiment_key,
        web_location,
        **kwargs
    ):
        """Create location  

        Create location.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_location(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            web_location (WebLocation): New essence creation request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WebLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['web_location'] = \
            web_location
        return self.create_location_endpoint.call_with_http_info(**kwargs)

    def delete_location(
        self,
        experiment_key,
        essence_key,
        **kwargs
    ):
        """Remove location  

        Removing a location by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_location(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            essence_key (BasicEssenceKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['essence_key'] = \
            essence_key
        return self.delete_location_endpoint.call_with_http_info(**kwargs)

    def read_location(
        self,
        experiment_key,
        essence_key,
        **kwargs
    ):
        """Read location  

        Getting location information by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_location(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            essence_key (BasicEssenceKey): Key, unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WebLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['essence_key'] = \
            essence_key
        return self.read_location_endpoint.call_with_http_info(**kwargs)

    def read_locations(
        self,
        experiment_key,
        **kwargs
    ):
        """Locations list  

        Getting a locations list.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            offset (int): The number of items to skip before starting to collect the result set.. [optional] if omitted the server will use the default value of 0
            limit (int): The number of items to return.. [optional] if omitted the server will use the default value of 100
            sort_column (TableLocationColumnType): Locations table column name. . [optional]
            sort_direction (str): Sort direction.. [optional] if omitted the server will use the default value of "ASC"
            table_location_filter_list (TableLocationFilterList): locations filter.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TableLocationList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.read_locations_endpoint.call_with_http_info(**kwargs)

    def read_locations_geopoints(
        self,
        experiment_key,
        **kwargs
    ):
        """Location geopoints  

        Getting a geopoints.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations_geopoints(experiment_key, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.

        Keyword Args:
            table_location_filter_list (TableLocationFilterList): Locations filter.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WebLocationGeopointList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        return self.read_locations_geopoints_endpoint.call_with_http_info(**kwargs)

    def update_location(
        self,
        experiment_key,
        web_location,
        **kwargs
    ):
        """Update location  

        Updating the location by key.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_location(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        Args:
            experiment_key (UniqueKey): Key, unique identifier.
            web_location (WebLocation): Essence update request.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WebLocation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['experiment_key'] = \
            experiment_key
        kwargs['web_location'] = \
            web_location
        return self.update_location_endpoint.call_with_http_info(**kwargs)

