"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 5.11.1826
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_studio.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from vrt_lss_studio.exceptions import ApiAttributeError


def lazy_import():
    from vrt_lss_studio.model.basic_essence_key import BasicEssenceKey
    from vrt_lss_studio.model.basic_state import BasicState
    from vrt_lss_studio.model.basic_time_window import BasicTimeWindow
    from vrt_lss_studio.model.box_restrictions import BoxRestrictions
    from vrt_lss_studio.model.cargo_features import CargoFeatures
    from vrt_lss_studio.model.cargo_restrictions import CargoRestrictions
    from vrt_lss_studio.model.cargo_rotation import CargoRotation
    from vrt_lss_studio.model.order_features import OrderFeatures
    from vrt_lss_studio.model.order_restrictions import OrderRestrictions
    from vrt_lss_studio.model.performer_blacklist import PerformerBlacklist
    from vrt_lss_studio.model.performer_restrictions import PerformerRestrictions
    globals()['BasicEssenceKey'] = BasicEssenceKey
    globals()['BasicState'] = BasicState
    globals()['BasicTimeWindow'] = BasicTimeWindow
    globals()['BoxRestrictions'] = BoxRestrictions
    globals()['CargoFeatures'] = CargoFeatures
    globals()['CargoRestrictions'] = CargoRestrictions
    globals()['CargoRotation'] = CargoRotation
    globals()['OrderFeatures'] = OrderFeatures
    globals()['OrderRestrictions'] = OrderRestrictions
    globals()['PerformerBlacklist'] = PerformerBlacklist
    globals()['PerformerRestrictions'] = PerformerRestrictions


class TableOrderFields(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('essence_type',): {
            'ORDER': "ORDER",
            'DEMAND': "DEMAND",
        },
    }

    validations = {
        ('type',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('reward',): {
            'inclusive_minimum': 0,
        },
        ('mass',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('volume',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('capacity_a',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('capacity_b',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('capacity_c',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('width',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('height',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('length',): {
            'inclusive_maximum': 1000000,
            'inclusive_minimum': 0,
        },
        ('demands_count',): {
            'inclusive_maximum': 30001,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'essence_key': (BasicEssenceKey,),  
            'essence_type': (str,),  
            'enabled': (bool,),  
            'pristine': (bool,),  
            'state': (BasicState,),  
            'type': (str, none_type,),  
            'hard_time_window': (BasicTimeWindow,),  
            'soft_time_window': (BasicTimeWindow,),  
            'reward': (float,),  
            'mass': (float,),  
            'volume': (float,),  
            'capacity_a': (float,),  
            'capacity_b': (float,),  
            'capacity_c': (float,),  
            'order_features': (OrderFeatures,),  
            'order_restrictions': (OrderRestrictions,),  
            'performer_restrictions': (PerformerRestrictions,),  
            'performer_blacklist': (PerformerBlacklist,),  
            'width': (float,),  
            'height': (float,),  
            'length': (float,),  
            'rotation': (CargoRotation,),  
            'box_restrictions': (BoxRestrictions,),  
            'cargo_features': (CargoFeatures,),  
            'cargo_restrictions': (CargoRestrictions,),  
            'demands_count': (int,),  
            'trip_key': (BasicEssenceKey,),  
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'essence_key': 'essence_key',  
        'essence_type': 'essence_type',  
        'enabled': 'enabled',  
        'pristine': 'pristine',  
        'state': 'state',  
        'type': 'type',  
        'hard_time_window': 'hard_time_window',  
        'soft_time_window': 'soft_time_window',  
        'reward': 'reward',  
        'mass': 'mass',  
        'volume': 'volume',  
        'capacity_a': 'capacity_a',  
        'capacity_b': 'capacity_b',  
        'capacity_c': 'capacity_c',  
        'order_features': 'order_features',  
        'order_restrictions': 'order_restrictions',  
        'performer_restrictions': 'performer_restrictions',  
        'performer_blacklist': 'performer_blacklist',  
        'width': 'width',  
        'height': 'height',  
        'length': 'length',  
        'rotation': 'rotation',  
        'box_restrictions': 'box_restrictions',  
        'cargo_features': 'cargo_features',  
        'cargo_restrictions': 'cargo_restrictions',  
        'demands_count': 'demands_count',  
        'trip_key': 'trip_key',  
    }

    read_only_vars = {
        'pristine',  
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, essence_key, *args, **kwargs):  
        """TableOrderFields - a model defined in OpenAPI

        Args:
            essence_key (BasicEssenceKey):

        Keyword Args:
            essence_type (str): Essence type.. defaults to "ORDER", must be one of ["ORDER", "DEMAND", ]  
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            enabled (bool): Using essence for calculations.. [optional] if omitted the server will use the default value of True  
            pristine (bool): A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. . [optional] if omitted the server will use the default value of True  
            state (BasicState): [optional]  
            type (str, none_type): Order\\demand type.. [optional] if omitted the server will use the default value of "null"  
            hard_time_window (BasicTimeWindow): [optional]  
            soft_time_window (BasicTimeWindow): [optional]  
            reward (float): The total reward for orders fulfillment.. [optional] if omitted the server will use the default value of 0  
            mass (float): Weight in kilograms.. [optional] if omitted the server will use the default value of 0  
            volume (float): Volume in cubic meters.. [optional] if omitted the server will use the default value of 0  
            capacity_a (float): Additional capacity parameter (A) for measuring cargoes and compartments in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a compartment). . [optional] if omitted the server will use the default value of 0  
            capacity_b (float): Additional capacity parameter (B) for measuring cargoes and compartments in alternative units. . [optional] if omitted the server will use the default value of 0  
            capacity_c (float): Additional capacity parameter (C) for measuring cargoes and compartments in alternative units. . [optional] if omitted the server will use the default value of 0  
            order_features (OrderFeatures): [optional]  
            order_restrictions (OrderRestrictions): [optional]  
            performer_restrictions (PerformerRestrictions): [optional]  
            performer_blacklist (PerformerBlacklist): [optional]  
            width (float): Width in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            height (float): Height in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            length (float): Length in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            rotation (CargoRotation): [optional]  
            box_restrictions (BoxRestrictions): [optional]  
            cargo_features (CargoFeatures): [optional]  
            cargo_restrictions (CargoRestrictions): [optional]  
            demands_count (int): Demands count.. [optional] if omitted the server will use the default value of 0  
            trip_key (BasicEssenceKey): [optional]  
        """

        essence_type = kwargs.get('essence_type', "ORDER")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.essence_key = essence_key
        self.essence_type = essence_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, essence_key, *args, **kwargs):  
        """TableOrderFields - a model defined in OpenAPI

        Args:
            essence_key (BasicEssenceKey):

        Keyword Args:
            essence_type (str): Essence type.. defaults to "ORDER", must be one of ["ORDER", "DEMAND", ]  
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            enabled (bool): Using essence for calculations.. [optional] if omitted the server will use the default value of True  
            pristine (bool): A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. . [optional] if omitted the server will use the default value of True  
            state (BasicState): [optional]  
            type (str, none_type): Order\\demand type.. [optional] if omitted the server will use the default value of "null"  
            hard_time_window (BasicTimeWindow): [optional]  
            soft_time_window (BasicTimeWindow): [optional]  
            reward (float): The total reward for orders fulfillment.. [optional] if omitted the server will use the default value of 0  
            mass (float): Weight in kilograms.. [optional] if omitted the server will use the default value of 0  
            volume (float): Volume in cubic meters.. [optional] if omitted the server will use the default value of 0  
            capacity_a (float): Additional capacity parameter (A) for measuring cargoes and compartments in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a compartment). . [optional] if omitted the server will use the default value of 0  
            capacity_b (float): Additional capacity parameter (B) for measuring cargoes and compartments in alternative units. . [optional] if omitted the server will use the default value of 0  
            capacity_c (float): Additional capacity parameter (C) for measuring cargoes and compartments in alternative units. . [optional] if omitted the server will use the default value of 0  
            order_features (OrderFeatures): [optional]  
            order_restrictions (OrderRestrictions): [optional]  
            performer_restrictions (PerformerRestrictions): [optional]  
            performer_blacklist (PerformerBlacklist): [optional]  
            width (float): Width in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            height (float): Height in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            length (float): Length in meters, used to check the transport box capacity.. [optional] if omitted the server will use the default value of 0  
            rotation (CargoRotation): [optional]  
            box_restrictions (BoxRestrictions): [optional]  
            cargo_features (CargoFeatures): [optional]  
            cargo_restrictions (CargoRestrictions): [optional]  
            demands_count (int): Demands count.. [optional] if omitted the server will use the default value of 0  
            trip_key (BasicEssenceKey): [optional]  
        """

        essence_type = kwargs.get('essence_type', "ORDER")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.essence_key = essence_key
        self.essence_type = essence_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
