"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
/**
 * @summary The SnsToSqs class.
 */
class SnsToSqs extends constructs_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the SnsToSqs class.
     * @since 1.62.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        let encryptionKeyParam = props.encryptionKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
            // Create the encryptionKey if none was provided
            if (!props.encryptionKey) {
                encryptionKeyParam = core_1.buildEncryptionKey(scope, props.encryptionKeyProps);
            }
        }
        // Setup the SNS topic
        if (!props.existingTopicObj) {
            // If an existingTopicObj was not specified create new topic
            [this.snsTopic, this.encryptionKey] = defaults.buildTopic(this, {
                topicProps: props.topicProps,
                enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
                encryptionKey: encryptionKeyParam
            });
        }
        else {
            // If an existingTopicObj was specified utilize the provided topic
            this.snsTopic = props.existingTopicObj;
        }
        // Setup the queue
        [this.sqsQueue] = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: encryptionKeyParam
        });
        // Setup the SQS queue subscription to the SNS topic
        this.snsTopic.addSubscription(new subscriptions.SqsSubscription(this.sqsQueue));
        // Grant SNS service access to the SQS queue encryption key
        if (this.sqsQueue.encryptionMasterKey) {
            this.sqsQueue.encryptionMasterKey.grant(new iam.ServicePrincipal("sns.amazonaws.com"), 'kms:Decrypt', 'kms:GenerateDataKey*');
        }
    }
}
exports.SnsToSqs = SnsToSqs;
_a = JSII_RTTI_SYMBOL_1;
SnsToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-sns-sqs.SnsToSqs", version: "2.0.0-rc.1" };
//# sourceMappingURL=data:application/json;base64,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