"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from typing import Any, List, Mapping, Optional, Union
from uai_annotation_requests import models, utils
from uai_annotation_requests._hooks import HookContext
from uai_annotation_requests.types import OptionalNullable, UNSET


class AnnotationRequest(BaseSDK):
    def create(
        self,
        *,
        project_id: str,
        clips: Union[List[models.CreateClipDTO], List[models.CreateClipDTOTypedDict]],
        request_reference_id: str,
        callback_url: Optional[str] = None,
        priority: Optional[int] = None,
        display_name: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Create a new annotation request

        This endpoint creates a new annotation request.

        An annotation request can contain one or more clips
        that should be part of the same annotation batch.

        The annotation request and the clips have reference fields where
        you must provide your own reference that is used to identify
        the data in the client system. This reference is used to
        map data between the UAI system and the client system.

        For UAI to be able to process the data of the annotation request,
        data must be made available to the UAI system. This is done by a data intake
        step in the UAI system which makes data from the client
        available to UAI based on the requirements of the integration
        and project. To enable integration specific data exchanges
        the API allows the `clips[].parameters` field of the clip to be
        defined per project. If applicable, a clip parameters schema is agreed upon
        together with UAI for the project.

        Requests to the UAI API must include an authorization token.
        To request a token the client must authenticate against a token endpoint
        with the `client_id` and `client_secret` provided by UAI.
        If the token request is successful a JSON response is returned
        with an access token that can be used to authorize and call the
        UAI API.

        **Example call to token endpoint and response:**

        ```
        curl -X POST https://signin.services.understand.ai/auth/realms/understand.ai/protocol/openid-connect/token \ 
        -H \"content-type: application/x-www-form-urlencoded\" \ 
        -d \"client_id=$CLIENT_ID\" \ 
        -d \"client_secret=$CLIENT_SECRET\" \ 
        -d \"grant_type=client_credentials\" 
        {
        \"access_token\":\"eyJhbGciOiJSUzI1NiIsInR5cCIxxxxxxx....w\",
        \"expires_in\":900,\"refresh_expires_in\":0,
        \"token_type\":\"Bearer\",
        \"not-before-policy\":0,
        \"scope\":\"external-api-audience\" 
        }
        ```

        :param project_id: The ID of the project to process the annotation request. Provided by UAI.
        :param clips: The clips to be annotated in the request
        :param request_reference_id: A reference to data in the client system.  The value of this field must be unique per project.
        :param callback_url: An optional callback URL to send annotation request updates to.
        :param priority: An optional priority value to use for the annotation request.  The priority of an annotation request determines the order of processing within the project.  Annotation requests with higher priority will be processed earlier than annotation requests with lower priority.  By default, the priority is 0 for all annotation requests in the project.
        :param display_name: An optional display name to show in UAI tooling
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateRequest(
            project_id=project_id,
            create_annotation_request_dto=models.CreateAnnotationRequestDTO(
                callback_url=callback_url,
                priority=priority,
                clips=utils.get_pydantic_model(clips, List[models.CreateClipDTO]),
                display_name=display_name,
                request_reference_id=request_reference_id,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v1/projects/{projectId}/annotation-requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_annotation_request_dto,
                False,
                False,
                "json",
                models.CreateAnnotationRequestDTO,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="Create",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        project_id: str,
        clips: Union[List[models.CreateClipDTO], List[models.CreateClipDTOTypedDict]],
        request_reference_id: str,
        callback_url: Optional[str] = None,
        priority: Optional[int] = None,
        display_name: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Create a new annotation request

        This endpoint creates a new annotation request.

        An annotation request can contain one or more clips
        that should be part of the same annotation batch.

        The annotation request and the clips have reference fields where
        you must provide your own reference that is used to identify
        the data in the client system. This reference is used to
        map data between the UAI system and the client system.

        For UAI to be able to process the data of the annotation request,
        data must be made available to the UAI system. This is done by a data intake
        step in the UAI system which makes data from the client
        available to UAI based on the requirements of the integration
        and project. To enable integration specific data exchanges
        the API allows the `clips[].parameters` field of the clip to be
        defined per project. If applicable, a clip parameters schema is agreed upon
        together with UAI for the project.

        Requests to the UAI API must include an authorization token.
        To request a token the client must authenticate against a token endpoint
        with the `client_id` and `client_secret` provided by UAI.
        If the token request is successful a JSON response is returned
        with an access token that can be used to authorize and call the
        UAI API.

        **Example call to token endpoint and response:**

        ```
        curl -X POST https://signin.services.understand.ai/auth/realms/understand.ai/protocol/openid-connect/token \ 
        -H \"content-type: application/x-www-form-urlencoded\" \ 
        -d \"client_id=$CLIENT_ID\" \ 
        -d \"client_secret=$CLIENT_SECRET\" \ 
        -d \"grant_type=client_credentials\" 
        {
        \"access_token\":\"eyJhbGciOiJSUzI1NiIsInR5cCIxxxxxxx....w\",
        \"expires_in\":900,\"refresh_expires_in\":0,
        \"token_type\":\"Bearer\",
        \"not-before-policy\":0,
        \"scope\":\"external-api-audience\" 
        }
        ```

        :param project_id: The ID of the project to process the annotation request. Provided by UAI.
        :param clips: The clips to be annotated in the request
        :param request_reference_id: A reference to data in the client system.  The value of this field must be unique per project.
        :param callback_url: An optional callback URL to send annotation request updates to.
        :param priority: An optional priority value to use for the annotation request.  The priority of an annotation request determines the order of processing within the project.  Annotation requests with higher priority will be processed earlier than annotation requests with lower priority.  By default, the priority is 0 for all annotation requests in the project.
        :param display_name: An optional display name to show in UAI tooling
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateRequest(
            project_id=project_id,
            create_annotation_request_dto=models.CreateAnnotationRequestDTO(
                callback_url=callback_url,
                priority=priority,
                clips=utils.get_pydantic_model(clips, List[models.CreateClipDTO]),
                display_name=display_name,
                request_reference_id=request_reference_id,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/projects/{projectId}/annotation-requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.create_annotation_request_dto,
                False,
                False,
                "json",
                models.CreateAnnotationRequestDTO,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="Create",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        project_id: str,
        field: models.FilterField,
        value: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Get annotation request

        Get an annotation request by different IDs. It is recommended to get
        the annotation request by the annotationRequestId if possible.

        The current progress of an annotation request can be observed by
        the phase field. When the phase is \"COMPLETE\" the annotations are
        ready to be downloaded.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param field: The field to get the annotation request by.
        :param value: The value of the field to get the annotation request by.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRequest(
            project_id=project_id,
            field=field,
            value=value,
        )

        req = self._build_request(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="Get",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestNotFoundDTOData
            )
            raise models.AnnotationRequestNotFoundDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        project_id: str,
        field: models.FilterField,
        value: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Get annotation request

        Get an annotation request by different IDs. It is recommended to get
        the annotation request by the annotationRequestId if possible.

        The current progress of an annotation request can be observed by
        the phase field. When the phase is \"COMPLETE\" the annotations are
        ready to be downloaded.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param field: The field to get the annotation request by.
        :param value: The value of the field to get the annotation request by.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetRequest(
            project_id=project_id,
            field=field,
            value=value,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="Get",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestNotFoundDTOData
            )
            raise models.AnnotationRequestNotFoundDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get_filtered(
        self,
        *,
        project_id: str,
        phase: Optional[models.AnnotationRequestPhase] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.AnnotationRequestCondensedDTO]:
        r"""Get annotation requests filtered by projectId and phase.

        Get annotation requests that match the filter criteria.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param phase: Optional filter for phase. If set only annotation requests currently in the specified phase are returned in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetFilteredRequest(
            project_id=project_id,
            phase=phase,
        )

        req = self._build_request(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/filtered",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetFiltered",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, List[models.AnnotationRequestCondensedDTO]
            )
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_filtered_async(
        self,
        *,
        project_id: str,
        phase: Optional[models.AnnotationRequestPhase] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.AnnotationRequestCondensedDTO]:
        r"""Get annotation requests filtered by projectId and phase.

        Get annotation requests that match the filter criteria.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param phase: Optional filter for phase. If set only annotation requests currently in the specified phase are returned in the response.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetFilteredRequest(
            project_id=project_id,
            phase=phase,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/filtered",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetFiltered",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, List[models.AnnotationRequestCondensedDTO]
            )
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get_by_annotation_request_id(
        self,
        *,
        project_id: str,
        annotation_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Get annotation request by the annotation request ID

        Get an annotation request by the annotation request ID.

        The current progress of an annotation request can be observed by
        the phase field. When the phase is \"COMPLETE\" the annotations are
        ready to be downloaded.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param annotation_request_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetByAnnotationRequestIDRequest(
            project_id=project_id,
            annotation_request_id=annotation_request_id,
        )

        req = self._build_request(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/{annotationRequestId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetByAnnotationRequestId",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestNotFoundDTOData
            )
            raise models.AnnotationRequestNotFoundDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_by_annotation_request_id_async(
        self,
        *,
        project_id: str,
        annotation_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestDTO:
        r"""Get annotation request by the annotation request ID

        Get an annotation request by the annotation request ID.

        The current progress of an annotation request can be observed by
        the phase field. When the phase is \"COMPLETE\" the annotations are
        ready to be downloaded.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param annotation_request_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetByAnnotationRequestIDRequest(
            project_id=project_id,
            annotation_request_id=annotation_request_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/{annotationRequestId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetByAnnotationRequestId",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.AnnotationRequestDTO)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestNotFoundDTOData
            )
            raise models.AnnotationRequestNotFoundDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get_exported_annotations(
        self,
        *,
        project_id: str,
        annotation_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestExportReferenceDTO:
        r"""Request the download URLs for the result annotations.

        This endpoint provides a list of downloadable URLs for a
        completed annotation request. If the annotation request is not yet
        in the COMPLETE phase the response status code will be 404 - not found.

        The download URLs will be in the form of Google Cloud Storage signed URLs
        that are only valid for a short period of time. If the integration client
        fails to download the content within the valid duration new download URLs can be
        requested via this endpoint.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param annotation_request_id: The ID of the annotation request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetExportedAnnotationsRequest(
            project_id=project_id,
            annotation_request_id=annotation_request_id,
        )

        req = self._build_request(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/{annotationRequestId}/annotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetExportedAnnotations",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.AnnotationRequestExportReferenceDTO
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestExportNotReadyDTOData
            )
            raise models.AnnotationRequestExportNotReadyDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_exported_annotations_async(
        self,
        *,
        project_id: str,
        annotation_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AnnotationRequestExportReferenceDTO:
        r"""Request the download URLs for the result annotations.

        This endpoint provides a list of downloadable URLs for a
        completed annotation request. If the annotation request is not yet
        in the COMPLETE phase the response status code will be 404 - not found.

        The download URLs will be in the form of Google Cloud Storage signed URLs
        that are only valid for a short period of time. If the integration client
        fails to download the content within the valid duration new download URLs can be
        requested via this endpoint.

        :param project_id: The ID of the project which is processing the annotation request. Provided by UAI.
        :param annotation_request_id: The ID of the annotation request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetExportedAnnotationsRequest(
            project_id=project_id,
            annotation_request_id=annotation_request_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/projects/{projectId}/annotation-requests/{annotationRequestId}/annotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="GetExportedAnnotations",
                oauth2_scopes=[],
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["400", "401", "403", "404", "4XX", "503", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.AnnotationRequestExportReferenceDTO
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.AnnotationRequestExportNotReadyDTOData
            )
            raise models.AnnotationRequestExportNotReadyDTO(data=response_data)
        if utils.match_response(http_res, ["400", "401", "403", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, ["503", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
