"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .annotationrequestphase import AnnotationRequestPhase
from .clipdto import ClipDTO, ClipDTOTypedDict
from .errordetails import ErrorDetails, ErrorDetailsTypedDict
from .publicapidataintakestrategy import PublicAPIDataIntakeStrategy
from .publicapiexportstrategy import PublicAPIExportStrategy
from .reviewdetails import ReviewDetails, ReviewDetailsTypedDict
from datetime import datetime
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from uai_annotation_requests.types import BaseModel


class AnnotationRequestDTOTypedDict(TypedDict):
    priority: int
    r"""The priority of an annotation request
    determines the order of processing within
    the project.

    Annotation requests with higher priority
    will be processed earlier than annotation
    requests with lower priority.

    By default, the priority is 0 for all
    annotation requests in the project.
    """
    clips: List[ClipDTOTypedDict]
    r"""The clips to be annotated
    in the request
    """
    request_reference_id: str
    r"""A reference to data in
    the user system
    """
    project_id: str
    r"""The ID of the UAI project that is processing
    the annotation request
    """
    updated_at: datetime
    r"""When the annotation request was last updated"""
    created_at: datetime
    r"""When the annotation request was created"""
    export_strategy: PublicAPIExportStrategy
    r"""The export strategy to use

    UPLOAD_WORKFLOW:
    UAI uploads exported data
    via a workflow integration

    DOWNLOAD_GCS:
    Download exported data via
    a download link
    """
    data_intake_strategy: PublicAPIDataIntakeStrategy
    r"""The data intake strategy to use

    UPLOAD_GCS:
    Upload data via a signed
    Google Cloud Storage URL

    DOWNLOAD_WORKFLOW:
    UAI downloads data via a
    workflow integration
    """
    phase: AnnotationRequestPhase
    r"""The processing phase of an
    annotation request

    INTAKE: when data is copied
    to the UAI systems

    PREPROCESSING: when data is being
    prepared for annotation

    ANNOTATION: when data is being annotated

    REVIEW: when annotated data is under
    review

    DELIVERY: when data is being
    delivered

    COMPLETE: when the annotation request
    is complete

    ERROR: when an error occurred during
    processing and execution failed
    """
    display_name: str
    r"""The display name shown in UAI tooling"""
    annotation_request_id: str
    r"""The ID of the annotation request

    The ID can be used in the GET endpoint
    to lookup the annotation request
    """
    review_details: NotRequired[ReviewDetailsTypedDict]
    error_details: NotRequired[ErrorDetailsTypedDict]
    callback_url: NotRequired[str]
    r"""The callback URL to send
    annotation request updates to.
    """


class AnnotationRequestDTO(BaseModel):
    priority: int
    r"""The priority of an annotation request
    determines the order of processing within
    the project.

    Annotation requests with higher priority
    will be processed earlier than annotation
    requests with lower priority.

    By default, the priority is 0 for all
    annotation requests in the project.
    """

    clips: List[ClipDTO]
    r"""The clips to be annotated
    in the request
    """

    request_reference_id: Annotated[str, pydantic.Field(alias="requestReferenceId")]
    r"""A reference to data in
    the user system
    """

    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    r"""The ID of the UAI project that is processing
    the annotation request
    """

    updated_at: Annotated[datetime, pydantic.Field(alias="updatedAt")]
    r"""When the annotation request was last updated"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""When the annotation request was created"""

    export_strategy: Annotated[
        PublicAPIExportStrategy, pydantic.Field(alias="exportStrategy")
    ]
    r"""The export strategy to use

    UPLOAD_WORKFLOW:
    UAI uploads exported data
    via a workflow integration

    DOWNLOAD_GCS:
    Download exported data via
    a download link
    """

    data_intake_strategy: Annotated[
        PublicAPIDataIntakeStrategy, pydantic.Field(alias="dataIntakeStrategy")
    ]
    r"""The data intake strategy to use

    UPLOAD_GCS:
    Upload data via a signed
    Google Cloud Storage URL

    DOWNLOAD_WORKFLOW:
    UAI downloads data via a
    workflow integration
    """

    phase: AnnotationRequestPhase
    r"""The processing phase of an
    annotation request

    INTAKE: when data is copied
    to the UAI systems

    PREPROCESSING: when data is being
    prepared for annotation

    ANNOTATION: when data is being annotated

    REVIEW: when annotated data is under
    review

    DELIVERY: when data is being
    delivered

    COMPLETE: when the annotation request
    is complete

    ERROR: when an error occurred during
    processing and execution failed
    """

    display_name: Annotated[str, pydantic.Field(alias="displayName")]
    r"""The display name shown in UAI tooling"""

    annotation_request_id: Annotated[str, pydantic.Field(alias="annotationRequestId")]
    r"""The ID of the annotation request

    The ID can be used in the GET endpoint
    to lookup the annotation request
    """

    review_details: Annotated[
        Optional[ReviewDetails], pydantic.Field(alias="reviewDetails")
    ] = None

    error_details: Annotated[
        Optional[ErrorDetails], pydantic.Field(alias="errorDetails")
    ] = None

    callback_url: Annotated[Optional[str], pydantic.Field(alias="callbackURL")] = None
    r"""The callback URL to send
    annotation request updates to.
    """
