"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createclipdto import CreateClipDTO, CreateClipDTOTypedDict
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from uai_annotation_requests.types import BaseModel


class CreateAnnotationRequestDTOTypedDict(TypedDict):
    clips: List[CreateClipDTOTypedDict]
    r"""The clips to be annotated
    in the request
    """
    request_reference_id: str
    r"""A reference to
    data in the client system.

    The value of this field must be
    unique per project.
    """
    callback_url: NotRequired[str]
    r"""An optional callback URL to send
    annotation request updates to.
    """
    priority: NotRequired[int]
    r"""An optional priority value to use
    for the annotation request.

    The priority of an annotation request
    determines the order of processing within
    the project.

    Annotation requests with higher priority
    will be processed earlier than annotation
    requests with lower priority.

    By default, the priority is 0 for all
    annotation requests in the project.
    """
    display_name: NotRequired[str]
    r"""An optional display name
    to show in UAI tooling
    """


class CreateAnnotationRequestDTO(BaseModel):
    clips: List[CreateClipDTO]
    r"""The clips to be annotated
    in the request
    """

    request_reference_id: Annotated[str, pydantic.Field(alias="requestReferenceId")]
    r"""A reference to
    data in the client system.

    The value of this field must be
    unique per project.
    """

    callback_url: Annotated[Optional[str], pydantic.Field(alias="callbackURL")] = None
    r"""An optional callback URL to send
    annotation request updates to.
    """

    priority: Optional[int] = None
    r"""An optional priority value to use
    for the annotation request.

    The priority of an annotation request
    determines the order of processing within
    the project.

    Annotation requests with higher priority
    will be processed earlier than annotation
    requests with lower priority.

    By default, the priority is 0 for all
    annotation requests in the project.
    """

    display_name: Annotated[Optional[str], pydantic.Field(alias="displayName")] = None
    r"""An optional display name
    to show in UAI tooling
    """
