"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .annotationrequestphase import AnnotationRequestPhase
from .createannotationrequestdto import (
    CreateAnnotationRequestDTO,
    CreateAnnotationRequestDTOTypedDict,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from uai_annotation_requests.types import BaseModel
from uai_annotation_requests.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)


class CreateUpdatedRequestBodyTypedDict(TypedDict):
    annotation_request_id: NotRequired[str]
    request_reference_id: NotRequired[str]
    phase: NotRequired[AnnotationRequestPhase]
    r"""The processing phase of an
    annotation request

    INTAKE: when data is copied
    to the UAI systems

    PREPROCESSING: when data is being
    prepared for annotation

    ANNOTATION: when data is being annotated

    REVIEW: when annotated data is under
    review

    DELIVERY: when data is being
    delivered

    COMPLETE: when the annotation request
    is complete

    ERROR: when an error occurred during
    processing and execution failed
    """


class CreateUpdatedRequestBody(BaseModel):
    annotation_request_id: Annotated[
        Optional[str], pydantic.Field(alias="annotationRequestId")
    ] = None

    request_reference_id: Annotated[
        Optional[str], pydantic.Field(alias="requestReferenceId")
    ] = None

    phase: Optional[AnnotationRequestPhase] = None
    r"""The processing phase of an
    annotation request

    INTAKE: when data is copied
    to the UAI systems

    PREPROCESSING: when data is being
    prepared for annotation

    ANNOTATION: when data is being annotated

    REVIEW: when annotated data is under
    review

    DELIVERY: when data is being
    delivered

    COMPLETE: when the annotation request
    is complete

    ERROR: when an error occurred during
    processing and execution failed
    """


class CreateRequestTypedDict(TypedDict):
    project_id: str
    r"""The ID of the project to process the annotation request. Provided by UAI."""
    create_annotation_request_dto: CreateAnnotationRequestDTOTypedDict
    r"""The annotation request parameters"""


class CreateRequest(BaseModel):
    project_id: Annotated[
        str,
        pydantic.Field(alias="projectId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the project to process the annotation request. Provided by UAI."""

    create_annotation_request_dto: Annotated[
        CreateAnnotationRequestDTO,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""The annotation request parameters"""
