"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .annotationrequestphase import AnnotationRequestPhase
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from uai_annotation_requests.types import BaseModel
from uai_annotation_requests.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class GetFilteredRequestTypedDict(TypedDict):
    project_id: str
    r"""The ID of the project which is processing the annotation request. Provided by UAI."""
    phase: NotRequired[AnnotationRequestPhase]
    r"""Optional filter for phase. If set only annotation requests currently in the specified
    phase are returned in the response.
    """


class GetFilteredRequest(BaseModel):
    project_id: Annotated[
        str,
        pydantic.Field(alias="projectId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the project which is processing the annotation request. Provided by UAI."""

    phase: Annotated[
        Optional[AnnotationRequestPhase],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Optional filter for phase. If set only annotation requests currently in the specified
    phase are returned in the response.
    """
