"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filterfield import FilterField
import pydantic
from typing_extensions import Annotated, TypedDict
from uai_annotation_requests.types import BaseModel
from uai_annotation_requests.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class GetRequestTypedDict(TypedDict):
    project_id: str
    r"""The ID of the project which is processing the annotation request. Provided by UAI."""
    field: FilterField
    r"""The field to get the annotation request by."""
    value: str
    r"""The value of the field to get the annotation request by."""


class GetRequest(BaseModel):
    project_id: Annotated[
        str,
        pydantic.Field(alias="projectId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The ID of the project which is processing the annotation request. Provided by UAI."""

    field: Annotated[
        FilterField, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The field to get the annotation request by."""

    value: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The value of the field to get the annotation request by."""
