"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-kendra';
const testBucket = defaults.CreateScrapBucket(stack);
const existingIamRole = new iam.Role(stack, 'existingRole', {
    assumedBy: new iam.ServicePrincipal('kendra.amazonaws.com')
});
const sourceProps = {
    urls: {
        seedUrlConfiguration: {
            seedUrls: ["https://aws.amazon.com"]
        }
    },
    crawlDepth: 1,
};
const webCrawlerSource = {
    name: "web-source",
    roleArn: existingIamRole.roleArn,
    type: "WEBCRAWLER",
    dataSourceConfiguration: {
        webCrawlerConfiguration: sourceProps
    }
};
new lib_1.LambdaToKendra(stack, 'minimal-arguments', {
    lambdaFunctionProps: {
        code: lambda.Code.fromAsset(`lambda`),
        runtime: lambda.Runtime.NODEJS_18_X,
        handler: 'index.handler',
    },
    kendraDataSourcesProps: [{
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: testBucket.bucketName,
                }
            }
        },
        webCrawlerSource],
});
core_1.suppressAutoDeleteHandlerWarnings(stack);
//# sourceMappingURL=data:application/json;base64,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