# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
#---------------------------------------------------------------------------


"""
This module contains a widget class and supporting classes for a generic HTML
renderer.  It supports only a subset of the HTML standards, and no Javascript
or CSS, but it is relatively lightweight and has no platform dependencies.  It
is suitable for displaying simple HTML documents, such as the application's
documentation or built-in help pages.

.. note:: Due to some internal dynamic initialization in wxWidgets, this
          module should be imported **before** the :class:`wx.App` object is
          created.
"""

#-- begin-_html --#

import wx

#-- end-_html --#
#-- begin-htmldefs --#
HTML_ALIGN_LEFT = 0
HTML_ALIGN_RIGHT = 0
HTML_ALIGN_JUSTIFY = 0
HTML_ALIGN_TOP = 0
HTML_ALIGN_BOTTOM = 0
HTML_ALIGN_CENTER = 0
HTML_CLR_FOREGROUND = 0
HTML_CLR_BACKGROUND = 0
HTML_CLR_TRANSPARENT_BACKGROUND = 0
HTML_UNITS_PIXELS = 0
HTML_UNITS_PERCENT = 0
HTML_INDENT_LEFT = 0
HTML_INDENT_RIGHT = 0
HTML_INDENT_TOP = 0
HTML_INDENT_BOTTOM = 0
HTML_INDENT_HORIZONTAL = 0
HTML_INDENT_VERTICAL = 0
HTML_INDENT_ALL = 0
HTML_COND_ISANCHOR = 0
HTML_COND_ISIMAGEMAP = 0
HTML_COND_USER = 0
INT_MAX = 0

#-- end-htmldefs --#
#-- begin-htmlcell --#
HTML_SEL_OUT = 0
HTML_SEL_IN = 0
HTML_SEL_CHANGING = 0
HTML_FIND_EXACT = 0
HTML_FIND_NEAREST_BEFORE = 0
HTML_FIND_NEAREST_AFTER = 0
HTML_SCRIPT_NORMAL = 0
HTML_SCRIPT_SUB = 0
HTML_SCRIPT_SUP = 0

class HtmlSelection(object):
    """
    HtmlSelection()
    """

    def __init__(self):
        """
        HtmlSelection()
        """

    def Set(self, *args, **kw):
        """
        Set(fromPos, fromCell, toPos, toCell)
        Set(fromCell, toCell)
        """

    def GetFromCell(self):
        """
        GetFromCell() -> HtmlCell
        """

    def GetToCell(self):
        """
        GetToCell() -> HtmlCell
        """

    def GetFromPos(self):
        """
        GetFromPos() -> wx.Point
        """

    def GetToPos(self):
        """
        GetToPos() -> wx.Point
        """

    def ClearFromToCharacterPos(self):
        """
        ClearFromToCharacterPos()
        """

    def AreFromToCharacterPosSet(self):
        """
        AreFromToCharacterPosSet() -> bool
        """

    def SetFromCharacterPos(self, pos):
        """
        SetFromCharacterPos(pos)
        """

    def SetToCharacterPos(self, pos):
        """
        SetToCharacterPos(pos)
        """

    def GetFromCharacterPos(self):
        """
        GetFromCharacterPos() -> Coord
        """

    def GetToCharacterPos(self):
        """
        GetToCharacterPos() -> Coord
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        """
    FromCell = property(None, None)
    FromCharacterPos = property(None, None)
    FromPos = property(None, None)
    ToCell = property(None, None)
    ToCharacterPos = property(None, None)
    ToPos = property(None, None)
# end of class HtmlSelection


class HtmlRenderingState(object):
    """
    HtmlRenderingState()
    
    Selection state is passed to wxHtmlCell::Draw so that it can render
    itself differently e.g.
    """

    def __init__(self):
        """
        HtmlRenderingState()
        
        Selection state is passed to wxHtmlCell::Draw so that it can render
        itself differently e.g.
        """

    def SetSelectionState(self, s):
        """
        SetSelectionState(s)
        """

    def GetSelectionState(self):
        """
        GetSelectionState() -> HtmlSelectionState
        """

    def SetFgColour(self, c):
        """
        SetFgColour(c)
        """

    def GetFgColour(self):
        """
        GetFgColour() -> wx.Colour
        """

    def SetBgColour(self, c):
        """
        SetBgColour(c)
        """

    def GetBgColour(self):
        """
        GetBgColour() -> wx.Colour
        """

    def SetBgMode(self, m):
        """
        SetBgMode(m)
        """

    def GetBgMode(self):
        """
        GetBgMode() -> int
        """
    BgColour = property(None, None)
    BgMode = property(None, None)
    FgColour = property(None, None)
    SelectionState = property(None, None)
# end of class HtmlRenderingState


class HtmlRenderingStyle(object):
    """
    wxHtmlSelection is data holder with information about text selection.
    """

    def GetSelectedTextColour(self, clr):
        """
        GetSelectedTextColour(clr) -> wx.Colour
        
        Returns the colour to use for the selected text.
        """

    def GetSelectedTextBgColour(self, clr):
        """
        GetSelectedTextBgColour(clr) -> wx.Colour
        
        Returns the colour to use for the selected text's background.
        """
# end of class HtmlRenderingStyle


class HtmlRenderingInfo(object):
    """
    HtmlRenderingInfo()
    
    This class contains information given to cells when drawing them.
    """

    def __init__(self):
        """
        HtmlRenderingInfo()
        
        This class contains information given to cells when drawing them.
        """

    def SetSelection(self, s):
        """
        SetSelection(s)
        
        Accessors.
        """

    def GetSelection(self):
        """
        GetSelection() -> HtmlSelection
        
        Accessors.
        """

    def SetStyle(self, style):
        """
        SetStyle(style)
        
        Accessors.
        """

    def GetStyle(self):
        """
        GetStyle() -> HtmlRenderingStyle
        
        Accessors.
        """

    def GetState(self):
        """
        GetState() -> HtmlRenderingState
        
        Accessors.
        """
    Selection = property(None, None)
    State = property(None, None)
    Style = property(None, None)
# end of class HtmlRenderingInfo


class HtmlCell(wx.Object):
    """
    HtmlCell()
    
    Internal data structure.
    """

    def __init__(self):
        """
        HtmlCell()
        
        Internal data structure.
        """

    def AdjustPagebreak(self, pagebreak, pageHeight):
        """
        AdjustPagebreak(pagebreak, pageHeight) -> (bool, pagebreak)
        
        This method is called when paginating HTML, e.g. when printing.
        """

    def Draw(self, dc, x, y, view_y1, view_y2, info):
        """
        Draw(dc, x, y, view_y1, view_y2, info)
        
        Renders the cell.
        """

    def DrawInvisible(self, dc, x, y, info):
        """
        DrawInvisible(dc, x, y, info)
        
        This method is called instead of Draw() when the cell is certainly out
        of the screen (and thus invisible).
        """

    def Find(self, condition, param):
        """
        Find(condition, param) -> HtmlCell
        
        Returns pointer to itself if this cell matches condition (or if any of
        the cells following in the list matches), NULL otherwise.
        """

    def FindCellByPos(self, x, y, flags=HTML_FIND_EXACT):
        """
        FindCellByPos(x, y, flags=HTML_FIND_EXACT) -> HtmlCell
        
        Find a cell inside this cell positioned at the given coordinates
        (relative to this's positions).
        """

    def GetDescent(self):
        """
        GetDescent() -> int
        
        Returns descent value of the cell (m_Descent member).
        """

    def GetFirstChild(self):
        """
        GetFirstChild() -> HtmlCell
        
        Returns pointer to the first cell in the list.
        """

    def GetHeight(self):
        """
        GetHeight() -> int
        
        Returns height of the cell (m_Height member).
        """

    def GetId(self):
        """
        GetId() -> String
        
        Returns unique cell identifier if there is any, the empty string
        otherwise.
        """

    def GetLink(self, x=0, y=0):
        """
        GetLink(x=0, y=0) -> HtmlLinkInfo
        
        Returns hypertext link if associated with this cell or NULL otherwise.
        """

    def GetMouseCursor(self, window):
        """
        GetMouseCursor(window) -> wx.Cursor
        
        Returns cursor to show when mouse pointer is over the cell.
        """

    def GetMouseCursorAt(self, window, rePos):
        """
        GetMouseCursorAt(window, rePos) -> wx.Cursor
        
        Returns cursor to show when mouse pointer is over the specified point.
        """

    def GetNext(self):
        """
        GetNext() -> HtmlCell
        
        Returns pointer to the next cell in list (see htmlcell.h if you're
        interested in details).
        """

    def GetParent(self):
        """
        GetParent() -> HtmlContainerCell
        
        Returns pointer to parent container.
        """

    def GetPosX(self):
        """
        GetPosX() -> int
        
        Returns X position within parent (the value is relative to parent's
        upper left corner).
        """

    def GetPosY(self):
        """
        GetPosY() -> int
        
        Returns Y position within parent (the value is relative to parent's
        upper left corner).
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns width of the cell (m_Width member).
        """

    def Layout(self, w):
        """
        Layout(w)
        
        Layouts the cell.
        """

    def ProcessMouseClick(self, window, pos, event):
        """
        ProcessMouseClick(window, pos, event) -> bool
        
        This function is simple event handler.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets unique cell identifier.
        """

    def SetLink(self, link):
        """
        SetLink(link)
        
        Sets the hypertext link associated with this cell.
        """

    def SetNext(self, cell):
        """
        SetNext(cell)
        
        Sets the next cell in the list.
        """

    def SetParent(self, p):
        """
        SetParent(p)
        
        Sets parent container of this cell.
        """

    def SetPos(self, x, y):
        """
        SetPos(x, y)
        
        Sets the cell's position within parent container.
        """

    def ConvertToText(self, sel):
        """
        ConvertToText(sel) -> String
        
        Converts the cell into text representation.
        """

    def GetAbsPos(self, rootCell=None):
        """
        GetAbsPos(rootCell=None) -> wx.Point
        """

    def GetRootCell(self):
        """
        GetRootCell() -> HtmlCell
        """
    AbsPos = property(None, None)
    Descent = property(None, None)
    FirstChild = property(None, None)
    Height = property(None, None)
    Id = property(None, None)
    Link = property(None, None)
    Next = property(None, None)
    Parent = property(None, None)
    PosX = property(None, None)
    PosY = property(None, None)
    RootCell = property(None, None)
    Width = property(None, None)
# end of class HtmlCell


class HtmlContainerCell(HtmlCell):
    """
    HtmlContainerCell(parent)
    
    The wxHtmlContainerCell class is an implementation of a cell that may
    contain more cells in it.
    """

    def __init__(self, parent):
        """
        HtmlContainerCell(parent)
        
        The wxHtmlContainerCell class is an implementation of a cell that may
        contain more cells in it.
        """

    def Detach(self, cell):
        """
        Detach(cell)
        
        Detach a child cell.
        """

    def GetAlignHor(self):
        """
        GetAlignHor() -> int
        
        Returns container's horizontal alignment.
        """

    def GetAlignVer(self):
        """
        GetAlignVer() -> int
        
        Returns container's vertical alignment.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        
        Returns the background colour of the container or wxNullColour if no
        background colour is set.
        """

    def GetIndent(self, ind):
        """
        GetIndent(ind) -> int
        
        Returns the indentation.
        """

    def GetIndentUnits(self, ind):
        """
        GetIndentUnits(ind) -> int
        
        Returns the units of indentation for ind where ind is one of the
        wxHTML_INDENT_* constants.
        """

    def InsertCell(self, cell):
        """
        InsertCell(cell)
        
        Inserts a new cell into the container.
        """

    def SetAlign(self, tag):
        """
        SetAlign(tag)
        
        Sets the container's alignment (both horizontal and vertical)
        according to the values stored in tag.
        """

    def SetAlignHor(self, al):
        """
        SetAlignHor(al)
        
        Sets the container's horizontal alignment.
        """

    def SetAlignVer(self, al):
        """
        SetAlignVer(al)
        
        Sets the container's vertical alignment.
        """

    def SetBackgroundColour(self, clr):
        """
        SetBackgroundColour(clr)
        
        Sets the background colour for this container.
        """

    def SetBorder(self, clr1, clr2, border=1):
        """
        SetBorder(clr1, clr2, border=1)
        
        Sets the border (frame) colours.
        """

    def SetIndent(self, i, what, units=HTML_UNITS_PIXELS):
        """
        SetIndent(i, what, units=HTML_UNITS_PIXELS)
        
        Sets the indentation (free space between borders of container and
        subcells).
        """

    def SetMinHeight(self, h, align=HTML_ALIGN_TOP):
        """
        SetMinHeight(h, align=HTML_ALIGN_TOP)
        
        Sets minimal height of the container.
        """

    def SetWidthFloat(self, *args, **kw):
        """
        SetWidthFloat(w, units)
        SetWidthFloat(tag, pixel_scale=1.0)
        
        Sets floating width adjustment.
        """
    AlignHor = property(None, None)
    AlignVer = property(None, None)
    BackgroundColour = property(None, None)
# end of class HtmlContainerCell


class HtmlLinkInfo(wx.Object):
    """
    HtmlLinkInfo()
    HtmlLinkInfo(href, target=wx.EmptyString)
    
    This class stores all necessary information about hypertext links (as
    represented by <A> tag in HTML documents).
    """

    def __init__(self, *args, **kw):
        """
        HtmlLinkInfo()
        HtmlLinkInfo(href, target=wx.EmptyString)
        
        This class stores all necessary information about hypertext links (as
        represented by <A> tag in HTML documents).
        """

    def GetEvent(self):
        """
        GetEvent() -> wx.MouseEvent
        
        Return pointer to event that generated OnLinkClicked() event.
        """

    def GetHref(self):
        """
        GetHref() -> String
        
        Return HREF value of the <A> tag.
        """

    def GetHtmlCell(self):
        """
        GetHtmlCell() -> HtmlCell
        
        Return pointer to the cell that was clicked.
        """

    def GetTarget(self):
        """
        GetTarget() -> String
        
        Return TARGET value of the <A> tag (this value is used to specify in
        which frame should be the page pointed by GetHref() Href opened).
        """
    Event = property(None, None)
    Href = property(None, None)
    HtmlCell = property(None, None)
    Target = property(None, None)
# end of class HtmlLinkInfo


class HtmlColourCell(HtmlCell):
    """
    HtmlColourCell(clr, flags=HTML_CLR_FOREGROUND)
    
    This cell changes the colour of either the background or the
    foreground.
    """

    def __init__(self, clr, flags=HTML_CLR_FOREGROUND):
        """
        HtmlColourCell(clr, flags=HTML_CLR_FOREGROUND)
        
        This cell changes the colour of either the background or the
        foreground.
        """
# end of class HtmlColourCell


class HtmlWidgetCell(HtmlCell):
    """
    HtmlWidgetCell(wnd, w=0)
    
    wxHtmlWidgetCell is a class that provides a connection between HTML
    cells and widgets (an object derived from wxWindow).
    """

    def __init__(self, wnd, w=0):
        """
        HtmlWidgetCell(wnd, w=0)
        
        wxHtmlWidgetCell is a class that provides a connection between HTML
        cells and widgets (an object derived from wxWindow).
        """
# end of class HtmlWidgetCell


class HtmlWordCell(HtmlCell):
    """
    HtmlWordCell(word, dc)
    
    This html cell represents a single word or text fragment in the
    document stream.
    """

    def __init__(self, word, dc):
        """
        HtmlWordCell(word, dc)
        
        This html cell represents a single word or text fragment in the
        document stream.
        """
# end of class HtmlWordCell


class HtmlWordWithTabsCell(HtmlWordCell):
    """
    HtmlWordWithTabsCell(word, wordOrig, linepos, dc)
    
    wxHtmlWordCell is a specialization for storing text fragments with
    embedded tab characters.
    """

    def __init__(self, word, wordOrig, linepos, dc):
        """
        HtmlWordWithTabsCell(word, wordOrig, linepos, dc)
        
        wxHtmlWordCell is a specialization for storing text fragments with
        embedded tab characters.
        """
# end of class HtmlWordWithTabsCell


class HtmlFontCell(HtmlCell):
    """
    HtmlFontCell(font)
    
    This cell represents a font change in the document stream.
    """

    def __init__(self, font):
        """
        HtmlFontCell(font)
        
        This cell represents a font change in the document stream.
        """
# end of class HtmlFontCell


#-- end-htmlcell --#
#-- begin-htmlfilt --#

class HtmlFilter(wx.Object):
    """
    HtmlFilter()
    
    This class is the parent class of input filters for wxHtmlWindow.
    """

    def __init__(self):
        """
        HtmlFilter()
        
        This class is the parent class of input filters for wxHtmlWindow.
        """

    def CanRead(self, file):
        """
        CanRead(file) -> bool
        
        Returns true if this filter is capable of reading file file.
        """

    def ReadFile(self, file):
        """
        ReadFile(file) -> String
        
        Reads the file and returns string with HTML document.
        """
# end of class HtmlFilter


#-- end-htmlfilt --#
#-- begin-htmltag --#

class HtmlTag(object):
    """
    This class represents a single HTML tag.
    """

    def GetAllParams(self):
        """
        GetAllParams() -> String
        
        Returns a string containing all parameters.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns tag's name.
        """

    def GetParam(self, par, with_quotes=False):
        """
        GetParam(par, with_quotes=False) -> String
        
        Returns the value of the parameter.
        """

    def GetParamAsColour(self, par):
        """
        GetParamAsColour(par) -> (bool, clr)
        
        Interprets tag parameter par as colour specification and saves its
        value into wxColour variable pointed by clr.
        """

    def GetParamAsInt(self, par):
        """
        GetParamAsInt(par) -> (bool, value)
        
        Interprets tag parameter par as an integer and saves its value into
        int variable pointed by value.
        """

    def GetParamAsString(self, par, value):
        """
        GetParamAsString(par, value) -> bool
        
        Get the value of the parameter.
        """

    def HasEnding(self):
        """
        HasEnding() -> bool
        
        Returns true if this tag is paired with ending tag, false otherwise.
        """

    def HasParam(self, par):
        """
        HasParam(par) -> bool
        
        Returns true if the tag has a parameter of the given name.
        """

    @staticmethod
    def ParseAsColour(str):
        """
        ParseAsColour(str) -> (bool, clr)
        
        Parses the given string as an HTML colour.
        """
    AllParams = property(None, None)
    Name = property(None, None)
# end of class HtmlTag


#-- end-htmltag --#
#-- begin-htmlpars --#
HTML_URL_PAGE = 0
HTML_URL_IMAGE = 0
HTML_URL_OTHER = 0

class HtmlTagHandler(wx.Object):
    """
    HtmlTagHandler()
    """

    def __init__(self):
        """
        HtmlTagHandler()
        """

    def GetSupportedTags(self):
        """
        GetSupportedTags() -> String
        
        Returns list of supported tags.
        """

    def HandleTag(self, tag):
        """
        HandleTag(tag) -> bool
        
        This is the core method of each handler.
        """

    def SetParser(self, parser):
        """
        SetParser(parser)
        
        Assigns parser to this handler.
        """

    def GetParser(self):
        """
        GetParser() -> HtmlParser
        
        Returns the parser associated with this tag handler.
        """
    Parser = property(None, None)
    SupportedTags = property(None, None)

    def ParseInner(self, tag):
        """
        ParseInner(tag)
        
        This method calls parser's wxHtmlParser::DoParsing method for the
        string between this tag and the paired ending tag:
        """

    def ParseInnerSource(self, source):
        """
        ParseInnerSource(source)
        
        Parses given source as if it was tag's inner code (see
        wxHtmlParser::GetInnerSource).
        """
# end of class HtmlTagHandler


class HtmlParser(object):
    """
    HtmlParser()
    
    Classes derived from this handle the generic parsing of HTML
    documents: it scans the document and divide it into blocks of tags
    (where one block consists of beginning and ending tag and of text
    between these two tags).
    """

    def __init__(self):
        """
        HtmlParser()
        
        Classes derived from this handle the generic parsing of HTML
        documents: it scans the document and divide it into blocks of tags
        (where one block consists of beginning and ending tag and of text
        between these two tags).
        """

    def AddTagHandler(self, handler):
        """
        AddTagHandler(handler)
        
        Adds handler to the internal list ( hash table) of handlers.
        """

    def DoParsing(self):
        """
        DoParsing()
        
        Parses the whole m_Source.
        """

    def DoneParser(self):
        """
        DoneParser()
        
        This must be called after DoParsing().
        """

    def GetFS(self):
        """
        GetFS() -> wx.FileSystem
        
        Returns pointer to the file system.
        """

    def GetProduct(self):
        """
        GetProduct() -> wx.Object
        
        Returns product of parsing.
        """

    def GetSource(self):
        """
        GetSource() -> String
        
        Returns pointer to the source being parsed.
        """

    def InitParser(self, source):
        """
        InitParser(source)
        
        Setups the parser for parsing the source string.
        """

    def OpenURL(self, type, url):
        """
        OpenURL(type, url) -> wx.FSFile
        
        Opens given URL and returns wxFSFile object that can be used to read
        data from it.
        """

    def Parse(self, source):
        """
        Parse(source) -> wx.Object
        
        Proceeds parsing of the document.
        """

    def PopTagHandler(self):
        """
        PopTagHandler()
        
        Restores parser's state before last call to PushTagHandler().
        """

    def PushTagHandler(self, handler, tags):
        """
        PushTagHandler(handler, tags)
        
        Forces the handler to handle additional tags (not returned by
        wxHtmlTagHandler::GetSupportedTags).
        """

    def SetFS(self, fs):
        """
        SetFS(fs)
        
        Sets the virtual file system that will be used to request additional
        files.
        """

    def StopParsing(self):
        """
        StopParsing()
        
        Call this function to interrupt parsing from a tag handler.
        """
    FS = property(None, None)
    Product = property(None, None)
    Source = property(None, None)

    def AddTag(self, tag):
        """
        AddTag(tag)
        
        This may (and may not) be overwritten in derived class.
        """
# end of class HtmlParser


#-- end-htmlpars --#
#-- begin-htmlwin --#
HW_SCROLLBAR_NEVER = 0
HW_SCROLLBAR_AUTO = 0
HW_NO_SELECTION = 0
HW_DEFAULT_STYLE = 0
HTML_OPEN = 0
HTML_BLOCK = 0
HTML_REDIRECT = 0
wxEVT_HTML_CELL_CLICKED = 0
wxEVT_HTML_CELL_HOVER = 0
wxEVT_HTML_LINK_CLICKED = 0

class HtmlWindowInterface(object):
    """
    HtmlWindowInterface()
    
    Abstract interface to a HTML rendering window (such as wxHtmlWindow or
    wxHtmlListBox) that is passed to wxHtmlWinParser.
    """
    HTMLCursor_Default = 0
    HTMLCursor_Link = 0
    HTMLCursor_Text = 0

    def __init__(self):
        """
        HtmlWindowInterface()
        
        Abstract interface to a HTML rendering window (such as wxHtmlWindow or
        wxHtmlListBox) that is passed to wxHtmlWinParser.
        """

    def SetHTMLWindowTitle(self, title):
        """
        SetHTMLWindowTitle(title)
        
        Called by the parser to set window's title to given text.
        """

    def OnHTMLLinkClicked(self, link):
        """
        OnHTMLLinkClicked(link)
        
        Called when a link is clicked.
        """

    def OnHTMLOpeningURL(self, type, url):
        """
        OnHTMLOpeningURL(type, url) -> (HtmlOpeningStatus, redirectTo)
        
        Called when the parser needs to open another URL (e.g.
        """

    def HTMLCoordsToWindow(self, cell, pos):
        """
        HTMLCoordsToWindow(cell, pos) -> wx.Point
        
        Converts coordinates pos relative to given cell to physical
        coordinates in the window.
        """

    def GetHTMLWindow(self):
        """
        GetHTMLWindow() -> wx.Window
        
        Returns the window used for rendering (may be NULL).
        """

    def GetHTMLBackgroundColour(self):
        """
        GetHTMLBackgroundColour() -> wx.Colour
        
        Returns background colour to use by default.
        """

    def SetHTMLBackgroundColour(self, clr):
        """
        SetHTMLBackgroundColour(clr)
        
        Sets window's background to colour clr.
        """

    def SetHTMLBackgroundImage(self, bmpBg):
        """
        SetHTMLBackgroundImage(bmpBg)
        
        Sets window's background to given bitmap.
        """

    def SetHTMLStatusText(self, text):
        """
        SetHTMLStatusText(text)
        
        Sets status bar text.
        """

    def GetHTMLCursor(self, type):
        """
        GetHTMLCursor(type) -> wx.Cursor
        
        Returns mouse cursor of given type.
        """
    HTMLBackgroundColour = property(None, None)
    HTMLWindow = property(None, None)
# end of class HtmlWindowInterface


class HtmlWindow(wx.ScrolledWindow, HtmlWindowInterface):
    """
    HtmlWindow()
    HtmlWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HW_DEFAULT_STYLE, name="htmlWindow")
    
    wxHtmlWindow is probably the only class you will directly use unless
    you want to do something special (like adding new tag handlers or MIME
    filters).
    """

    def __init__(self, *args, **kw):
        """
        HtmlWindow()
        HtmlWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=HW_DEFAULT_STYLE, name="htmlWindow")
        
        wxHtmlWindow is probably the only class you will directly use unless
        you want to do something special (like adding new tag handlers or MIME
        filters).
        """

    def AppendToPage(self, source):
        """
        AppendToPage(source) -> bool
        
        Appends HTML fragment to currently displayed text and refreshes the
        window.
        """

    def GetInternalRepresentation(self):
        """
        GetInternalRepresentation() -> HtmlContainerCell
        
        Returns pointer to the top-level container.
        """

    def GetOpenedAnchor(self):
        """
        GetOpenedAnchor() -> String
        
        Returns anchor within currently opened page (see
        wxHtmlWindow::GetOpenedPage).
        """

    def GetOpenedPage(self):
        """
        GetOpenedPage() -> String
        
        Returns full location of the opened page.
        """

    def GetOpenedPageTitle(self):
        """
        GetOpenedPageTitle() -> String
        
        Returns title of the opened page or wxEmptyString if the current page
        does not contain <TITLE> tag.
        """

    def GetParser(self):
        """
        GetParser() -> HtmlWinParser
        
        Returns a pointer to the current parser.
        """

    def GetRelatedFrame(self):
        """
        GetRelatedFrame() -> wx.Frame
        
        Returns the related frame.
        """

    def HistoryBack(self):
        """
        HistoryBack() -> bool
        
        Moves back to the previous page.
        """

    def HistoryCanBack(self):
        """
        HistoryCanBack() -> bool
        
        Returns true if it is possible to go back in the history i.e.
        """

    def HistoryCanForward(self):
        """
        HistoryCanForward() -> bool
        
        Returns true if it is possible to go forward in the history i.e.
        """

    def HistoryClear(self):
        """
        HistoryClear()
        
        Clears history.
        """

    def HistoryForward(self):
        """
        HistoryForward() -> bool
        
        Moves to next page in history.
        """

    def LoadFile(self, filename):
        """
        LoadFile(filename) -> bool
        
        Loads an HTML page from a file and displays it.
        """

    def LoadPage(self, location):
        """
        LoadPage(location) -> bool
        
        Unlike SetPage() this function first loads the HTML page from location
        and then displays it.
        """

    def OnLinkClicked(self, link):
        """
        OnLinkClicked(link)
        
        Called when user clicks on hypertext link.
        """

    def OnOpeningURL(self, type, url):
        """
        OnOpeningURL(type, url) -> (HtmlOpeningStatus, redirectTo)
        
        Called when an URL is being opened (either when the user clicks on a
        link or an image is loaded).
        """

    def OnSetTitle(self, title):
        """
        OnSetTitle(title)
        
        Called on parsing <TITLE> tag.
        """

    def ReadCustomization(self, cfg, path=wx.EmptyString):
        """
        ReadCustomization(cfg, path=wx.EmptyString)
        
        This reads custom settings from wxConfig.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Selects all text in the window.
        """

    def SelectLine(self, pos):
        """
        SelectLine(pos)
        
        Selects the line of text that pos points at.
        """

    def SelectWord(self, pos):
        """
        SelectWord(pos)
        
        Selects the word at position pos.
        """

    def SelectionToText(self):
        """
        SelectionToText() -> String
        
        Returns the current selection as plain text.
        """

    def SetBorders(self, b):
        """
        SetBorders(b)
        
        This function sets the space between border of window and HTML
        contents.
        """

    def SetFonts(self, normal_face, fixed_face, sizes):
        """
        SetFonts(normal_face, fixed_face, sizes)
        
        This function sets font sizes and faces.
        """

    def SetStandardFonts(self, size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString):
        """
        SetStandardFonts(size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString)
        
        Sets default font sizes and/or default font size.
        """

    def SetPage(self, source):
        """
        SetPage(source) -> bool
        
        Sets the source of a page and displays it, for example:
        """

    def SetRelatedFrame(self, frame, format):
        """
        SetRelatedFrame(frame, format)
        
        Sets the frame in which page title will be displayed.
        """

    def SetRelatedStatusBar(self, *args, **kw):
        """
        SetRelatedStatusBar(index)
        SetRelatedStatusBar(statusbar, index=0)
        
        After calling SetRelatedFrame(), this sets statusbar slot where
        messages will be displayed.
        """

    def ToText(self):
        """
        ToText() -> String
        
        Returns content of currently displayed page as plain text.
        """

    def WriteCustomization(self, cfg, path=wx.EmptyString):
        """
        WriteCustomization(cfg, path=wx.EmptyString)
        
        Saves custom settings into wxConfig.
        """

    @staticmethod
    def AddFilter(filter):
        """
        AddFilter(filter)
        
        Adds an input filter to the static list of available filters.
        """

    @staticmethod
    def GetDefaultHTMLCursor(type):
        """
        GetDefaultHTMLCursor(type) -> wx.Cursor
        
        Retrieves the default cursor for a given HTMLCursor type.
        """

    @staticmethod
    def SetDefaultHTMLCursor(type, cursor):
        """
        SetDefaultHTMLCursor(type, cursor)
        
        Sets the default cursor for a given HTMLCursor type.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    InternalRepresentation = property(None, None)
    OpenedAnchor = property(None, None)
    OpenedPage = property(None, None)
    OpenedPageTitle = property(None, None)
    Parser = property(None, None)
    RelatedFrame = property(None, None)

    def OnCellClicked(self, cell, x, y, event):
        """
        OnCellClicked(cell, x, y, event) -> bool
        
        This method is called when a mouse button is clicked inside
        wxHtmlWindow.
        """

    def OnCellMouseHover(self, cell, x, y):
        """
        OnCellMouseHover(cell, x, y)
        
        This method is called when a mouse moves over an HTML cell.
        """

    def ScrollToAnchor(self, anchor):
        """
        ScrollToAnchor(anchor) -> bool
        """
# end of class HtmlWindow


class HtmlLinkEvent(wx.CommandEvent):
    """
    HtmlLinkEvent(id, linkinfo)
    
    This event class is used for the events generated by wxHtmlWindow.
    """

    def __init__(self, id, linkinfo):
        """
        HtmlLinkEvent(id, linkinfo)
        
        This event class is used for the events generated by wxHtmlWindow.
        """

    def GetLinkInfo(self):
        """
        GetLinkInfo() -> HtmlLinkInfo
        
        Returns the wxHtmlLinkInfo which contains info about the cell clicked
        and the hyperlink it contains.
        """
    LinkInfo = property(None, None)
# end of class HtmlLinkEvent


class HtmlCellEvent(wx.CommandEvent):
    """
    HtmlCellEvent(commandType, id, cell, point, ev)
    
    This event class is used for the events generated by wxHtmlWindow.
    """

    def __init__(self, commandType, id, cell, point, ev):
        """
        HtmlCellEvent(commandType, id, cell, point, ev)
        
        This event class is used for the events generated by wxHtmlWindow.
        """

    def GetCell(self):
        """
        GetCell() -> HtmlCell
        
        Returns the wxHtmlCellEvent associated with the event.
        """

    def GetLinkClicked(self):
        """
        GetLinkClicked() -> bool
        
        Returns true if SetLinkClicked(true) has previously been called; false
        otherwise.
        """

    def GetPoint(self):
        """
        GetPoint() -> wx.Point
        
        Returns the wxPoint associated with the event.
        """

    def GetMouseEvent(self):
        """
        GetMouseEvent() -> wx.MouseEvent
        
        Returns the wxMouseEvent associated with the event.
        """

    def SetLinkClicked(self, linkclicked):
        """
        SetLinkClicked(linkclicked)
        
        Call this function with linkclicked set to true if the cell which has
        been clicked contained a link or false otherwise (which is the
        default).
        """
    Cell = property(None, None)
    LinkClicked = property(None, None)
    MouseEvent = property(None, None)
    Point = property(None, None)
# end of class HtmlCellEvent


EVT_HTML_CELL_CLICKED = wx.PyEventBinder( wxEVT_HTML_CELL_CLICKED, 1 )
EVT_HTML_CELL_HOVER   = wx.PyEventBinder( wxEVT_HTML_CELL_HOVER, 1 )
EVT_HTML_LINK_CLICKED = wx.PyEventBinder( wxEVT_HTML_LINK_CLICKED, 1 )

# deprecated wxEVT aliases
wxEVT_COMMAND_HTML_CELL_CLICKED  = wxEVT_HTML_CELL_CLICKED
wxEVT_COMMAND_HTML_CELL_HOVER    = wxEVT_HTML_CELL_HOVER
wxEVT_COMMAND_HTML_LINK_CLICKED  = wxEVT_HTML_LINK_CLICKED

#-- end-htmlwin --#
#-- begin-htmlprint --#
PAGE_ODD = 0
PAGE_EVEN = 0
PAGE_ALL = 0

class HtmlDCRenderer(wx.Object):
    """
    HtmlDCRenderer()
    
    This class can render HTML document into a specified area of a DC.
    """

    def __init__(self):
        """
        HtmlDCRenderer()
        
        This class can render HTML document into a specified area of a DC.
        """

    def GetTotalWidth(self):
        """
        GetTotalWidth() -> int
        
        Returns the width of the HTML text in pixels.
        """

    def GetTotalHeight(self):
        """
        GetTotalHeight() -> int
        
        Returns the height of the HTML text in pixels.
        """

    def FindNextPageBreak(self, pos):
        """
        FindNextPageBreak(pos) -> int
        
        Finds the next page break after the specified (vertical) position.
        """

    def Render(self, x, y, from_=0, to_=INT_MAX):
        """
        Render(x, y, from_=0, to_=INT_MAX)
        
        Renders HTML text to the DC.
        """

    def SetDC(self, dc, pixel_scale=1.0):
        """
        SetDC(dc, pixel_scale=1.0)
        
        Assign DC instance to the renderer.
        """

    def SetFonts(self, normal_face, fixed_face, sizes):
        """
        SetFonts(normal_face, fixed_face, sizes)
        
        This function sets font sizes and faces.
        """

    def SetStandardFonts(self, size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString):
        """
        SetStandardFonts(size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString)
        
        Sets font sizes to be relative to the given size or the system default
        size; use either specified or default font.
        """

    def SetHtmlText(self, html, basepath=wx.EmptyString, isdir=True):
        """
        SetHtmlText(html, basepath=wx.EmptyString, isdir=True)
        
        Assign text to the renderer.
        """

    def SetHtmlCell(self, cell):
        """
        SetHtmlCell(cell)
        
        Associate the given HTML contents to the renderer.
        """

    def SetSize(self, width, height):
        """
        SetSize(width, height)
        
        Set size of output rectangle, in pixels.
        """
    TotalHeight = property(None, None)
    TotalWidth = property(None, None)
# end of class HtmlDCRenderer


class HtmlEasyPrinting(wx.Object):
    """
    HtmlEasyPrinting(name="Printing", parentWindow=None)
    
    This class provides very simple interface to printing architecture.
    """
    Prompt_Never = 0
    Prompt_Once = 0
    Prompt_Always = 0

    def __init__(self, name="Printing", parentWindow=None):
        """
        HtmlEasyPrinting(name="Printing", parentWindow=None)
        
        This class provides very simple interface to printing architecture.
        """

    def GetName(self):
        """
        GetName() -> String
        
        Returns the current name being used for preview frames and setup
        dialogs.
        """

    def GetPageSetupData(self):
        """
        GetPageSetupData() -> wx.PageSetupDialogData
        
        Returns a pointer to wxPageSetupDialogData instance used by this
        class.
        """

    def GetParentWindow(self):
        """
        GetParentWindow() -> wx.Window
        
        Gets the parent window for dialogs.
        """

    def GetPrintData(self):
        """
        GetPrintData() -> wx.PrintData
        
        Returns pointer to wxPrintData instance used by this class.
        """

    def PageSetup(self):
        """
        PageSetup()
        
        Display page setup dialog and allows the user to modify settings.
        """

    def PreviewFile(self, htmlfile):
        """
        PreviewFile(htmlfile) -> bool
        
        Preview HTML file.
        """

    def PreviewText(self, htmltext, basepath=wx.EmptyString):
        """
        PreviewText(htmltext, basepath=wx.EmptyString) -> bool
        
        Preview HTML text (not file!).
        """

    def PrintFile(self, htmlfile):
        """
        PrintFile(htmlfile) -> bool
        
        Print HTML file.
        """

    def PrintText(self, htmltext, basepath=wx.EmptyString):
        """
        PrintText(htmltext, basepath=wx.EmptyString) -> bool
        
        Print HTML text (not file!).
        """

    def SetFonts(self, normal_face, fixed_face, sizes):
        """
        SetFonts(normal_face, fixed_face, sizes)
        
        Sets fonts.
        """

    def SetName(self, name):
        """
        SetName(name)
        
        Sets the name used for preview frames and setup dialogs.
        """

    def SetStandardFonts(self, size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString):
        """
        SetStandardFonts(size=-1, normal_face=wx.EmptyString, fixed_face=wx.EmptyString)
        
        Sets default font sizes and/or default font size.
        """

    def SetFooter(self, footer, pg=PAGE_ALL):
        """
        SetFooter(footer, pg=PAGE_ALL)
        
        Set page footer.
        """

    def SetHeader(self, header, pg=PAGE_ALL):
        """
        SetHeader(header, pg=PAGE_ALL)
        
        Set page header.
        """

    def SetParentWindow(self, window):
        """
        SetParentWindow(window)
        
        Sets the parent window for dialogs.
        """

    def SetPromptMode(self, promptMode):
        """
        SetPromptMode(promptMode)
        
        Enable or disable showing the dialog before printing.
        """
    Name = property(None, None)
    PageSetupData = property(None, None)
    ParentWindow = property(None, None)
    PrintData = property(None, None)
# end of class HtmlEasyPrinting


class HtmlPrintout(wx.Printout):
    """
    HtmlPrintout(title="Printout")
    
    This class serves as printout class for HTML documents.
    """

    def __init__(self, title="Printout"):
        """
        HtmlPrintout(title="Printout")
        
        This class serves as printout class for HTML documents.
        """

    def SetFonts(self, normal_face, fixed_face, sizes):
        """
        SetFonts(normal_face, fixed_face, sizes)
        
        This function sets font sizes and faces.
        """

    def SetFooter(self, footer, pg=PAGE_ALL):
        """
        SetFooter(footer, pg=PAGE_ALL)
        
        Set page footer.
        """

    def SetHeader(self, header, pg=PAGE_ALL):
        """
        SetHeader(header, pg=PAGE_ALL)
        
        Set page header.
        """

    def SetHtmlFile(self, htmlfile):
        """
        SetHtmlFile(htmlfile)
        
        Prepare the class for printing this HTML file.
        """

    def SetHtmlText(self, html, basepath=wx.EmptyString, isdir=True):
        """
        SetHtmlText(html, basepath=wx.EmptyString, isdir=True)
        
        Prepare the class for printing this HTML text.
        """

    def SetMargins(self, *args, **kw):
        """
        SetMargins(top=25.2, bottom=25.2, left=25.2, right=25.2, spaces=5)
        SetMargins(pageSetupData)
        
        Sets margins in millimeters.
        """

    @staticmethod
    def AddFilter(filter):
        """
        AddFilter(filter)
        
        Adds a filter to the static list of filters for wxHtmlPrintout.
        """
# end of class HtmlPrintout


#-- end-htmlprint --#
#-- begin-htmlwinpars --#

class HtmlWinTagHandler(HtmlTagHandler):
    """
    HtmlWinTagHandler()
    
    This is basically wxHtmlTagHandler except that it is extended with
    protected member m_WParser pointing to the wxHtmlWinParser object
    (value of this member is identical to wxHtmlParser's m_Parser).
    """

    def __init__(self):
        """
        HtmlWinTagHandler()
        
        This is basically wxHtmlTagHandler except that it is extended with
        protected member m_WParser pointing to the wxHtmlWinParser object
        (value of this member is identical to wxHtmlParser's m_Parser).
        """

    def SetParser(self, parser):
        """
        SetParser(parser)
        
        Assigns parser to this handler.
        """

    def GetParser(self):
        """
        GetParser() -> HtmlWinParser
        """
    Parser = property(None, None)
# end of class HtmlWinTagHandler


class HtmlWinParser(HtmlParser):
    """
    HtmlWinParser(wndIface=None)
    
    This class is derived from wxHtmlParser and its main goal is to parse
    HTML input so that it can be displayed in wxHtmlWindow.
    """

    def __init__(self, wndIface=None):
        """
        HtmlWinParser(wndIface=None)
        
        This class is derived from wxHtmlParser and its main goal is to parse
        HTML input so that it can be displayed in wxHtmlWindow.
        """

    def CloseContainer(self):
        """
        CloseContainer() -> HtmlContainerCell
        
        Closes the container, sets actual container to the parent one and
        returns pointer to it (see Cells and Containers).
        """

    def CreateCurrentFont(self):
        """
        CreateCurrentFont() -> wx.Font
        
        Creates font based on current setting (see SetFontSize(),
        SetFontBold(), SetFontItalic(), SetFontFixed(),
        wxHtmlWinParser::SetFontUnderlined) and returns pointer to it.
        """

    def GetActualColor(self):
        """
        GetActualColor() -> wx.Colour
        
        Returns actual text colour.
        """

    def GetAlign(self):
        """
        GetAlign() -> int
        
        Returns default horizontal alignment.
        """

    def GetCharHeight(self):
        """
        GetCharHeight() -> int
        
        Returns (average) char height in standard font.
        """

    def GetCharWidth(self):
        """
        GetCharWidth() -> int
        
        Returns average char width in standard font.
        """

    def GetContainer(self):
        """
        GetContainer() -> HtmlContainerCell
        
        Returns pointer to the currently opened container (see Cells and
        Containers).
        """

    def GetDC(self):
        """
        GetDC() -> wx.DC
        
        Returns pointer to the DC used during parsing.
        """

    def GetFontBold(self):
        """
        GetFontBold() -> int
        
        Returns true if actual font is bold, false otherwise.
        """

    def GetFontFace(self):
        """
        GetFontFace() -> String
        
        Returns actual font face name.
        """

    def GetFontFixed(self):
        """
        GetFontFixed() -> int
        
        Returns true if actual font is fixed face, false otherwise.
        """

    def GetFontItalic(self):
        """
        GetFontItalic() -> int
        
        Returns true if actual font is italic, false otherwise.
        """

    def GetFontSize(self):
        """
        GetFontSize() -> int
        
        Returns actual font size (HTML size varies from -2 to +4)
        """

    def GetFontUnderlined(self):
        """
        GetFontUnderlined() -> int
        
        Returns true if actual font is underlined, false otherwise.
        """

    def GetLink(self):
        """
        GetLink() -> HtmlLinkInfo
        
        Returns actual hypertext link.
        """

    def GetLinkColor(self):
        """
        GetLinkColor() -> wx.Colour
        
        Returns the colour of hypertext link text.
        """

    def GetWindowInterface(self):
        """
        GetWindowInterface() -> HtmlWindowInterface
        
        Returns associated window (wxHtmlWindow).
        """

    def OpenContainer(self):
        """
        OpenContainer() -> HtmlContainerCell
        
        Opens new container and returns pointer to it (see Cells and
        Containers).
        """

    def SetActualColor(self, clr):
        """
        SetActualColor(clr)
        
        Sets actual text colour.
        """

    def SetAlign(self, a):
        """
        SetAlign(a)
        
        Sets default horizontal alignment (see
        wxHtmlContainerCell::SetAlignHor).
        """

    def SetContainer(self, c):
        """
        SetContainer(c) -> HtmlContainerCell
        
        Allows you to directly set opened container.
        """

    def SetDC(self, dc, pixel_scale=1.0e+0):
        """
        SetDC(dc, pixel_scale=1.0e+0)
        
        Sets the DC.
        """

    def SetFontBold(self, x):
        """
        SetFontBold(x)
        
        Sets bold flag of actualfont.
        """

    def SetFontFace(self, face):
        """
        SetFontFace(face)
        
        Sets current font face to face.
        """

    def SetFontFixed(self, x):
        """
        SetFontFixed(x)
        
        Sets fixed face flag of actualfont.
        """

    def SetFontItalic(self, x):
        """
        SetFontItalic(x)
        
        Sets italic flag of actualfont.
        """

    def SetFontSize(self, s):
        """
        SetFontSize(s)
        
        Sets actual font size (HTML size varies from 1 to 7).
        """

    def SetFontUnderlined(self, x):
        """
        SetFontUnderlined(x)
        
        Sets underlined flag of actualfont.
        """

    def SetFonts(self, normal_face, fixed_face, sizes):
        """
        SetFonts(normal_face, fixed_face, sizes)
        
        Sets fonts.
        """

    def SetLink(self, link):
        """
        SetLink(link)
        
        Sets actual hypertext link.
        """

    def SetLinkColor(self, clr):
        """
        SetLinkColor(clr)
        
        Sets colour of hypertext link.
        """
    ActualColor = property(None, None)
    Align = property(None, None)
    CharHeight = property(None, None)
    CharWidth = property(None, None)
    Container = property(None, None)
    DC = property(None, None)
    FontBold = property(None, None)
    FontFace = property(None, None)
    FontFixed = property(None, None)
    FontItalic = property(None, None)
    FontSize = property(None, None)
    FontUnderlined = property(None, None)
    Link = property(None, None)
    LinkColor = property(None, None)
    WindowInterface = property(None, None)
# end of class HtmlWinParser


def HtmlWinParser_AddTagHandler(self, tagHandlerClass):
    """
    HtmlWinParser_AddTagHandler(tagHandlerClass)
    """

#-- end-htmlwinpars --#
#-- begin-helpdata --#

class HtmlBookRecord(object):
    """
    HtmlBookRecord(bookfile, basepath, title, start)
    
    Helper class for wxHtmlHelpData.
    """

    def __init__(self, bookfile, basepath, title, start):
        """
        HtmlBookRecord(bookfile, basepath, title, start)
        
        Helper class for wxHtmlHelpData.
        """

    def GetBookFile(self):
        """
        GetBookFile() -> String
        """

    def GetTitle(self):
        """
        GetTitle() -> String
        """

    def GetStart(self):
        """
        GetStart() -> String
        """

    def GetBasePath(self):
        """
        GetBasePath() -> String
        """

    def SetContentsRange(self, start, end):
        """
        SetContentsRange(start, end)
        """

    def GetContentsStart(self):
        """
        GetContentsStart() -> int
        """

    def GetContentsEnd(self):
        """
        GetContentsEnd() -> int
        """

    def SetTitle(self, title):
        """
        SetTitle(title)
        """

    def SetBasePath(self, path):
        """
        SetBasePath(path)
        """

    def SetStart(self, start):
        """
        SetStart(start)
        """

    def GetFullPath(self, page):
        """
        GetFullPath(page) -> String
        """
    BasePath = property(None, None)
    BookFile = property(None, None)
    ContentsEnd = property(None, None)
    ContentsStart = property(None, None)
    Start = property(None, None)
    Title = property(None, None)
# end of class HtmlBookRecord


class HtmlHelpDataItem(object):
    """
    HtmlHelpDataItem()
    
    Helper class for wxHtmlHelpData.
    """

    def __init__(self):
        """
        HtmlHelpDataItem()
        
        Helper class for wxHtmlHelpData.
        """
    level = property(None, None)
    parent = property(None, None)
    id = property(None, None)
    name = property(None, None)
    page = property(None, None)
    book = property(None, None)

    def GetFullPath(self):
        """
        GetFullPath() -> String
        """

    def GetIndentedName(self):
        """
        GetIndentedName() -> String
        """
    FullPath = property(None, None)
    IndentedName = property(None, None)
# end of class HtmlHelpDataItem


class HtmlHelpData(wx.Object):
    """
    HtmlHelpData()
    
    This class is used by wxHtmlHelpController and wxHtmlHelpFrame to
    access HTML help items.
    """

    def __init__(self):
        """
        HtmlHelpData()
        
        This class is used by wxHtmlHelpController and wxHtmlHelpFrame to
        access HTML help items.
        """

    def AddBook(self, book_url):
        """
        AddBook(book_url) -> bool
        
        Adds new book.
        """

    def FindPageById(self, id):
        """
        FindPageById(id) -> String
        
        Returns page's URL based on integer ID stored in project.
        """

    def FindPageByName(self, page):
        """
        FindPageByName(page) -> String
        
        Returns page's URL based on its (file)name.
        """

    def GetBookRecArray(self):
        """
        GetBookRecArray() -> HtmlBookRecArray
        
        Returns array with help books info.
        """

    def GetContentsArray(self):
        """
        GetContentsArray() -> HtmlHelpDataItems
        
        Returns reference to array with contents entries.
        """

    def GetIndexArray(self):
        """
        GetIndexArray() -> HtmlHelpDataItems
        
        Returns reference to array with index entries.
        """

    def SetTempDir(self, path):
        """
        SetTempDir(path)
        
        Sets the temporary directory where binary cached versions of MS HTML
        Workshop files will be stored.
        """
    BookRecArray = property(None, None)
    ContentsArray = property(None, None)
    IndexArray = property(None, None)
# end of class HtmlHelpData


#-- end-helpdata --#
#-- begin-helpfrm --#
HF_TOOLBAR = 0
HF_CONTENTS = 0
HF_INDEX = 0
HF_SEARCH = 0
HF_BOOKMARKS = 0
HF_OPEN_FILES = 0
HF_PRINT = 0
HF_FLAT_TOOLBAR = 0
HF_MERGE_BOOKS = 0
HF_ICONS_BOOK = 0
HF_ICONS_BOOK_CHAPTER = 0
HF_ICONS_FOLDER = 0
HF_DEFAULT_STYLE = 0

class HtmlHelpFrame(wx.Frame):
    """
    HtmlHelpFrame(data=None)
    HtmlHelpFrame(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, data=None, config=None, rootpath=wx.EmptyString)
    
    This class is used by wxHtmlHelpController to display help.
    """

    def __init__(self, *args, **kw):
        """
        HtmlHelpFrame(data=None)
        HtmlHelpFrame(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, data=None, config=None, rootpath=wx.EmptyString)
        
        This class is used by wxHtmlHelpController to display help.
        """

    def AddToolbarButtons(self, toolBar, style):
        """
        AddToolbarButtons(toolBar, style)
        
        You may override this virtual method to add more buttons to the help
        window's toolbar.
        """

    def Create(self, parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, config=None, rootpath=wx.EmptyString):
        """
        Create(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, config=None, rootpath=wx.EmptyString) -> bool
        
        Creates the frame.
        """

    def GetController(self):
        """
        GetController() -> HtmlHelpController
        
        Returns the help controller associated with the frame.
        """

    def SetController(self, controller):
        """
        SetController(controller)
        
        Sets the help controller associated with the frame.
        """

    def SetTitleFormat(self, format):
        """
        SetTitleFormat(format)
        
        Sets the frame's title format.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Controller = property(None, None)
# end of class HtmlHelpFrame


#-- end-helpfrm --#
#-- begin-helpdlg --#

class HtmlHelpDialog(wx.Dialog):
    """
    HtmlHelpDialog(data=None)
    HtmlHelpDialog(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, data=None)
    
    This class is used by wxHtmlHelpController to display help.
    """

    def __init__(self, *args, **kw):
        """
        HtmlHelpDialog(data=None)
        HtmlHelpDialog(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE, data=None)
        
        This class is used by wxHtmlHelpController to display help.
        """

    def AddToolbarButtons(self, toolBar, style):
        """
        AddToolbarButtons(toolBar, style)
        
        You may override this virtual method to add more buttons to the help
        window's toolbar.
        """

    def Create(self, parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE):
        """
        Create(parent, id=wx.ID_ANY, title=wx.EmptyString, style=HF_DEFAULT_STYLE) -> bool
        
        Creates the dialog.
        """

    def GetController(self):
        """
        GetController() -> HtmlHelpController
        
        Returns the help controller associated with the dialog.
        """

    def SetController(self, controller):
        """
        SetController(controller)
        
        Sets the help controller associated with the dialog.
        """

    def SetTitleFormat(self, format):
        """
        SetTitleFormat(format)
        
        Sets the dialog's title format.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Controller = property(None, None)
# end of class HtmlHelpDialog


#-- end-helpdlg --#
#-- begin-helpwnd --#
ID_HTML_PANEL = 0
ID_HTML_BACK = 0
ID_HTML_FORWARD = 0
ID_HTML_UPNODE = 0
ID_HTML_UP = 0
ID_HTML_DOWN = 0
ID_HTML_PRINT = 0
ID_HTML_OPENFILE = 0
ID_HTML_OPTIONS = 0
ID_HTML_BOOKMARKSLIST = 0
ID_HTML_BOOKMARKSADD = 0
ID_HTML_BOOKMARKSREMOVE = 0
ID_HTML_TREECTRL = 0
ID_HTML_INDEXPAGE = 0
ID_HTML_INDEXLIST = 0
ID_HTML_INDEXTEXT = 0
ID_HTML_INDEXBUTTON = 0
ID_HTML_INDEXBUTTONALL = 0
ID_HTML_NOTEBOOK = 0
ID_HTML_SEARCHPAGE = 0
ID_HTML_SEARCHTEXT = 0
ID_HTML_SEARCHLIST = 0
ID_HTML_SEARCHBUTTON = 0
ID_HTML_SEARCHCHOICE = 0
ID_HTML_COUNTINFO = 0

class HtmlHelpWindow(wx.Window):
    """
    HtmlHelpWindow(data=None)
    HtmlHelpWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.TAB_TRAVERSAL|wx.BORDER_NONE, helpStyle=HF_DEFAULT_STYLE, data=None)
    
    This class is used by wxHtmlHelpController to display help within a
    frame or dialog, but you can use it yourself to create an embedded
    HTML help window.
    """

    def __init__(self, *args, **kw):
        """
        HtmlHelpWindow(data=None)
        HtmlHelpWindow(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.TAB_TRAVERSAL|wx.BORDER_NONE, helpStyle=HF_DEFAULT_STYLE, data=None)
        
        This class is used by wxHtmlHelpController to display help within a
        frame or dialog, but you can use it yourself to create an embedded
        HTML help window.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.TAB_TRAVERSAL|wx.BORDER_NONE, helpStyle=HF_DEFAULT_STYLE):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.TAB_TRAVERSAL|wx.BORDER_NONE, helpStyle=HF_DEFAULT_STYLE) -> bool
        
        Creates the help window.
        """

    def Display(self, *args, **kw):
        """
        Display(x) -> bool
        Display(id) -> bool
        
        Displays page x.
        """

    def DisplayContents(self):
        """
        DisplayContents() -> bool
        
        Displays contents panel.
        """

    def DisplayIndex(self):
        """
        DisplayIndex() -> bool
        
        Displays index panel.
        """

    def GetData(self):
        """
        GetData() -> HtmlHelpData
        
        Returns the wxHtmlHelpData object, which is usually a pointer to the
        controller's data.
        """

    def KeywordSearch(self, keyword, mode=wx.HELP_SEARCH_ALL):
        """
        KeywordSearch(keyword, mode=wx.HELP_SEARCH_ALL) -> bool
        
        Search for given keyword.
        """

    def ReadCustomization(self, cfg, path=wx.EmptyString):
        """
        ReadCustomization(cfg, path=wx.EmptyString)
        
        Reads the user's settings for this window.
        """

    def UseConfig(self, config, rootpath=wx.EmptyString):
        """
        UseConfig(config, rootpath=wx.EmptyString)
        
        Associates a wxConfig object with the help window.
        """

    def WriteCustomization(self, cfg, path=wx.EmptyString):
        """
        WriteCustomization(cfg, path=wx.EmptyString)
        
        Saves the user's settings for this window.
        """

    def RefreshLists(self):
        """
        RefreshLists()
        
        Refresh all panels.
        """

    def GetController(self):
        """
        GetController() -> HtmlHelpController
        """

    def SetController(self, controller):
        """
        SetController(controller)
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Controller = property(None, None)
    Data = property(None, None)

    def CreateSearch(self):
        """
        CreateSearch()
        
        Creates search panel.
        """

    def AddToolbarButtons(self, toolBar, style):
        """
        AddToolbarButtons(toolBar, style)
        
        You may override this virtual method to add more buttons to the help
        window's toolbar.
        """

    def CreateContents(self):
        """
        CreateContents()
        
        Creates contents panel.
        """

    def CreateIndex(self):
        """
        CreateIndex()
        
        Creates index panel.
        """
# end of class HtmlHelpWindow


#-- end-helpwnd --#
#-- begin-helpctrl --#
ID_HTML_HELPFRAME = 0
HF_EMBEDDED = 0
HF_DIALOG = 0
HF_FRAME = 0
HF_MODAL = 0

class HtmlHelpController(wx.HelpControllerBase):
    """
    HtmlHelpController(style=HF_DEFAULT_STYLE, parentWindow=None)
    HtmlHelpController(parentWindow, style=HF_DEFAULT_STYLE)
    
    This help controller provides an easy way of displaying HTML help in
    your application (see HTML Sample, test example).
    """

    def __init__(self, *args, **kw):
        """
        HtmlHelpController(style=HF_DEFAULT_STYLE, parentWindow=None)
        HtmlHelpController(parentWindow, style=HF_DEFAULT_STYLE)
        
        This help controller provides an easy way of displaying HTML help in
        your application (see HTML Sample, test example).
        """

    def AddBook(self, *args, **kw):
        """
        AddBook(bookFile, showWaitMsg=False) -> bool
        AddBook(bookUrl, showWaitMsg=False) -> bool
        
        Adds a book (i.e.
        """

    def Display(self, *args, **kw):
        """
        Display(x) -> bool
        Display(id) -> bool
        
        Displays page x.
        """

    def DisplayContents(self):
        """
        DisplayContents() -> bool
        
        Displays help window and focuses contents panel.
        """

    def DisplayIndex(self):
        """
        DisplayIndex() -> bool
        
        Displays help window and focuses index panel.
        """

    def KeywordSearch(self, keyword, mode=wx.HELP_SEARCH_ALL):
        """
        KeywordSearch(keyword, mode=wx.HELP_SEARCH_ALL) -> bool
        
        Displays the help window, focuses search panel and starts searching.
        """

    def ReadCustomization(self, cfg, path=wx.EmptyString):
        """
        ReadCustomization(cfg, path=wx.EmptyString)
        
        Reads the controller's setting (position of window, etc.)
        """

    def SetShouldPreventAppExit(self, enable):
        """
        SetShouldPreventAppExit(enable)
        
        Sets whether the help frame should prevent application from exiting if
        it's the only remaining top level window.
        """

    def SetTempDir(self, path):
        """
        SetTempDir(path)
        
        Sets the path for storing temporary files - cached binary versions of
        index and contents files.
        """

    def SetTitleFormat(self, format):
        """
        SetTitleFormat(format)
        
        Sets format of title of the frame.
        """

    def UseConfig(self, config, rootpath=wx.EmptyString):
        """
        UseConfig(config, rootpath=wx.EmptyString)
        
        Associates the config object with the controller.
        """

    def WriteCustomization(self, cfg, path=wx.EmptyString):
        """
        WriteCustomization(cfg, path=wx.EmptyString)
        
        Stores controllers setting (position of window etc.)
        """

    def GetHelpWindow(self):
        """
        GetHelpWindow() -> HtmlHelpWindow
        
        Get the current help window.
        """

    def SetHelpWindow(self, helpWindow):
        """
        SetHelpWindow(helpWindow)
        
        Set the help window to be managed by this controller.
        """

    def GetFrame(self):
        """
        GetFrame() -> HtmlHelpFrame
        
        Returns the current help frame.
        """

    def GetDialog(self):
        """
        GetDialog() -> HtmlHelpDialog
        
        Returns the current help dialog.
        """
    Dialog = property(None, None)
    Frame = property(None, None)
    HelpWindow = property(None, None)

    def CreateHelpDialog(self, data):
        """
        CreateHelpDialog(data) -> HtmlHelpDialog
        
        This protected virtual method may be overridden so that when
        specifying the wxHF_DIALOG style, the controller uses a different
        dialog.
        """

    def CreateHelpFrame(self, data):
        """
        CreateHelpFrame(data) -> HtmlHelpFrame
        
        This protected virtual method may be overridden so that the controller
        uses a different frame.
        """
# end of class HtmlHelpController


class HtmlModalHelp(object):
    """
    HtmlModalHelp(parent, helpFile, topic=wx.EmptyString, style=HF_DEFAULT_STYLE|HF_DIALOG|HF_MODAL)
    
    This class uses wxHtmlHelpController to display help in a modal
    dialog.
    """

    def __init__(self, parent, helpFile, topic=wx.EmptyString, style=HF_DEFAULT_STYLE|HF_DIALOG|HF_MODAL):
        """
        HtmlModalHelp(parent, helpFile, topic=wx.EmptyString, style=HF_DEFAULT_STYLE|HF_DIALOG|HF_MODAL)
        
        This class uses wxHtmlHelpController to display help in a modal
        dialog.
        """
# end of class HtmlModalHelp


#-- end-helpctrl --#
#-- begin-htmllbox --#
HLB_DEFAULT_STYLE = 0
HLB_MULTIPLE = 0
HtmlListBoxNameStr = char()

class HtmlListBox(wx.VListBox):
    """
    HtmlListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=HtmlListBoxNameStr)
    HtmlListBox()
    
    wxHtmlListBox is an implementation of wxVListBox which shows HTML
    content in the listbox rows.
    """

    def __init__(self, *args, **kw):
        """
        HtmlListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=HtmlListBoxNameStr)
        HtmlListBox()
        
        wxHtmlListBox is an implementation of wxVListBox which shows HTML
        content in the listbox rows.
        """

    def GetFileSystem(self):
        """
        GetFileSystem() -> wx.FileSystem
        
        Returns the wxFileSystem used by the HTML parser of this object.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=HtmlListBoxNameStr):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, name=HtmlListBoxNameStr) -> bool
        
        Creates the control and optionally sets the initial number of items in
        it (it may also be set or changed later with
        wxVListBox::SetItemCount).
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    FileSystem = property(None, None)

    def OnLinkClicked(self, n, link):
        """
        OnLinkClicked(n, link)
        
        Called when the user clicks on hypertext link.
        """

    def GetSelectedTextBgColour(self, colBg):
        """
        GetSelectedTextBgColour(colBg) -> wx.Colour
        
        This virtual function may be overridden to change the appearance of
        the background of the selected cells in the same way as
        GetSelectedTextColour().
        """

    def GetSelectedTextColour(self, colFg):
        """
        GetSelectedTextColour(colFg) -> wx.Colour
        
        This virtual function may be overridden to customize the appearance of
        the selected cells.
        """

    def OnGetItemMarkup(self, n):
        """
        OnGetItemMarkup(n) -> String
        
        This function may be overridden to decorate HTML returned by
        OnGetItem().
        """

    def OnGetItem(self, n):
        """
        OnGetItem(n) -> String
        
        This method must be implemented in the derived class and should return
        the body (i.e. without html nor body tags) of the HTML fragment for
        the given item.
        """
# end of class HtmlListBox

SimpleHtmlListBoxNameStr = char()

class SimpleHtmlListBox(HtmlListBox, wx.ItemContainer):
    """
    SimpleHtmlListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=HLB_DEFAULT_STYLE, validator=wx.DefaultValidator, name=SimpleHtmlListBoxNameStr)
    SimpleHtmlListBox()
    
    wxSimpleHtmlListBox is an implementation of wxHtmlListBox which shows
    HTML content in the listbox rows.
    """

    def __init__(self, *args, **kw):
        """
        SimpleHtmlListBox(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=HLB_DEFAULT_STYLE, validator=wx.DefaultValidator, name=SimpleHtmlListBoxNameStr)
        SimpleHtmlListBox()
        
        wxSimpleHtmlListBox is an implementation of wxHtmlListBox which shows
        HTML content in the listbox rows.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=HLB_DEFAULT_STYLE, validator=wx.DefaultValidator, name=SimpleHtmlListBoxNameStr):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, choices=[], style=HLB_DEFAULT_STYLE, validator=wx.DefaultValidator, name=SimpleHtmlListBoxNameStr) -> bool
        
        Creates the HTML listbox for two-step construction.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
# end of class SimpleHtmlListBox


#-- end-htmllbox --#