
from __future__ import absolute_import 
__all__ = ["test"] 
from ...._globals import _RECOGNIZED_ELEMENTS_ 
from ...._globals import _DIRECTORY_ 
from ....testing import unittest 
from ... import ccsne 
from ... import sneia 
from .._presets import remove 
from .._presets import save 
import os 

""" 
Changing this filename also requires changing the import line in the 
test_preset_import unittest function 
""" 
_DUMMY_FILENAME_ = "vice_dummy_preset.py" 


@unittest 
def test_save(): 
	""" 
	vice.yields.presets.save unit test 
	""" 
	def test(): 
		""" 
		Test the function which saves the yield file 
		""" 
		spawn_dummy_yield_file() 
		try: 
			save(_DUMMY_FILENAME_) 
		except: 
			return False 
		finally: 
			remove_dummy_yield_file() 
		return True 
	return ["vice.yields.presets.save", test] 


@unittest 
def test_preset_import(): 
	""" 
	from vice.yields.presets import ______ unit test 
	""" 
	def test(): 
		""" 
		Test the import of the preset yield file 
		""" 
		try: 
			from vice.yields.presets import vice_dummy_preset 
		except: 
			return False 
		try: 
			for i in _RECOGNIZED_ELEMENTS_: 
				if ccsne.settings[i] != 0.001: return False 
				if sneia.settings[i] != 0.001: return False 
			ccsne.settings.restore_defaults() 
			sneia.settings.restore_defaults() 
		except: 
			return False 
		return True 
	return ["vice.yields.presets.import", test] 


@unittest 
def test_remove(): 
	""" 
	vice.yields.presets.remove unit test 
	""" 
	def test(): 
		""" 
		Test the function which removes the yield file 
		""" 
		try: 
			remove("vice_dummy_preset.py", force = True) 
		except: 
			return False 
		return "vice_dummy_preset.py" not in os.listdir("%syields/presets/" % (
			_DIRECTORY_)) 
	return ["vice.yields.presets.remove", test] 


def spawn_dummy_yield_file(filename = _DUMMY_FILENAME_): 
	""" 
	Generate a dummy yield file that sets all CCSN and SN Ia yields to 0.001 
	""" 
	cnt = """\

# This file generated by vice/tests/preset.py 
import vice 
for i in vice._globals._RECOGNIZED_ELEMENTS_: 
	vice.yields.ccsne.settings[i] = 0.001 
	vice.yields.sneia.settings[i] = 0.001 

""" 
	os.system("echo \'%s\' >> %s" % (cnt, filename)) 


def remove_dummy_yield_file(filename = _DUMMY_FILENAME_): 
	""" 
	Remove the dummy yield file 
	""" 
	os.system("rm -f %s" % (filename)) 

