from banal import as_bool
from typing import Optional, Dict, Any
from followthemoney.types import registry

from nomenklatura.dataset.util import Named, cleanup
from nomenklatura.dataset.util import type_check, type_require


class DataPublisher(Named):
    """Publisher information, eg. the government authority."""

    def __init__(self, data: Dict[str, Any]):
        name = type_require(registry.string, data.get("name"))
        super().__init__(name)
        self.url = type_require(registry.url, data.get("url"))
        self.description = type_check(registry.string, data.get("description"))
        self.country = type_check(registry.country, data.get("country"))
        self.official = as_bool(data.get("official", False))

    @property
    def country_label(self) -> Optional[str]:
        if self.country is None:
            return None
        return registry.country.caption(self.country)

    def to_dict(self) -> Dict[str, Any]:
        data = {
            "name": self.name,
            "url": self.url,
            "description": self.description,
            "country": self.country,
            "country_label": self.country_label,
            "official": self.official,
        }
        return cleanup(data)
