# cancer site / cancer morphology
cancer_code_map = {
    'C00': 'Lip',
    'C01': 'Base of tongue',
    'C02': 'Other and unspecified parts of tongue',
    'C03': 'Gum',
    'C04': 'Floor of mouth',
    'C05': 'Palate',
    'C06': 'Other and unspecified parts of mouth',
    'C07': 'Parotid gland',
    'C08': 'Other and unspecified major salivary glands',
    'C09': 'Tonsil',
    'C10': 'Oropharynx',
    'C11': 'Nasopharynx',
    'C12': 'Pyriform sinus',
    'C13': 'Hypopharynx',
    'C14': 'Other and ill-defined sites in lip, oral cavity, and pharynx',
    'C15': 'Esophagus',
    'C16': 'Stomach',
    'C17': 'Small intestine',
    'C18': 'Colon',
    'C19': 'Rectosigmoid junction',
    'C20': 'Rectum',
    'C21': 'Anus and anal canal',
    'C22': 'Liver and intrahepatic bile ducts',
    'C23': 'Gallbladder',
    'C24': 'Other and unspecified parts of biliary tract',
    'C25': 'Pancreas',
    'C26': 'Other and ill-defined digestive organs',
    'C30': 'Nasal cavity and middle ear',
    'C31': 'Accessory sinuses',
    'C32': 'Larynx',
    'C33': 'Trachea',
    'C34': 'Bronchus and lung',
    'C37': 'Thymus',
    'C38': 'Heart, mediastinum, and pleura',
    'C40': 'Bones, joints, and articular cartilage of limbs',
    'C41': 'Bones, joints, and articular cartilage of other and unspecified sites',
    'C44': 'Skin',
    'C47': 'Peripheral nerves and autonomic nervous system',
    'C48': 'Retroperitoneum and peritoneum',
    'C49': 'Connective, subcataneous, and other soft tissues',
    'C50': 'Breast', 
    'C51': 'Vulva',
    'C52': 'Vagina',
    'C53': 'Cervix uteri',
    'C54': 'Corpus uteri',
    'C55': 'Uterus, NOS',
    'C56': 'Ovary',
    'C57': 'Other and unspecified female genital organs',
    'C58': 'Placenta',
    'C60': 'Penis',
    'C61': 'Prostate gland',
    'C62': 'Testis',
    'C63': 'Other and unspecified male genital organs',
    'C64': 'Kidney',
    'C65': 'Renal pelvis',
    'C66': 'Ureter',
    'C67': 'Bladder',
    'C68': 'Other and unspecified urinary organs',
    'C69': 'Eye and adnexa',
    'C71': 'Brain',
    'C72': 'Spinal cord, cranial nerves, and other parts of central nervous system',
    'C73': 'Thyroid and other endocrine glands',
    'C74': 'Adrenal Gland', 
    'C75': 'Other endocrine glands and related structures', 
    'C76': 'Other and ill-defined sites',
    'C80': 'Unknown primary site',
    '800': 'Neoplasms, NOS',
    '801': 'Epithelial neoplasms, NOS',
    '802': 'Epithelial neoplasms, NOS',
    '803': 'Epithelial neoplasms, NOS',
    '804': 'Epithelial neoplasms, NOS',
    '805': 'Squamous cell neoplasms',
    '807': 'Squamous cell neoplasms',
    '808': 'Squamous cell neoplasms',
    '809': 'Basal cell neoplasms',
    '812': 'Transitional cell papillomas and carcinomas',
    '813': 'Transitional cell papillomas and carcinomas',
    '814': 'Adenomas and adenocarcinomas',
    '816': 'Adenomas and adenocarcinomas',
    '817': 'Adenomas and adenocarcinomas',
    '818': 'Adenomas and adenocarcinomas',
    '820': 'Adenomas and adenocarcinomas',
    '821': 'Adenomas and adenocarcinomas',
    '823': 'Adenomas and adenocarcinomas',
    '824': 'Adenomas and adenocarcinomas',
    '825': 'Adenomas and adenocarcinomas',
    '826': 'Adenomas and adenocarcinomas',
    '829': 'Adenomas and adenocarcinomas',
    '831': 'Adenomas and adenocarcinomas',
    '832': 'Adenomas and adenocarcinomas',
    '833': 'Adenomas and adenocarcinomas',
    '834': 'Adenomas and adenocarcinomas',
    '837': 'Adenomas and adenocarcinomas',
    '838': 'Adenomas and adenocarcinomas',
    '840': 'Adnexal and skin appendage neoplasms',
    '843': 'Mucoepidermoid neoplasms',
    '844': 'Cystic, mucinous, and serous neoplasms',
    '845': 'Cystic, mucinous, and serous neoplasms',
    '846': 'Cystic, mucinous, and serous neoplasms',
    '847': 'Cystic, mucinous, and serous neoplasms',
    '848': 'Cystic, mucinous, and serous neoplasms',
    '849': 'Cystic, mucinous, and serous neoplasms',
    '850': 'Ductal and lobular neoplasms',
    '851': 'Ductal and lobular neoplasms',
    '852': 'Ductal and lobular neoplasms',
    '853': 'Ductal and lobular neoplasms',
    '854': 'Ductal and lobular neoplasms',
    '855': 'Acinar cell neoplasms',
    '856': 'Complex epithelial neoplasms',
    '857': 'Complex epithelial neoplasms',
    '858': 'Thymic epithelial neoplasms',
    '862': 'Specialized gonadal neoplasms',
    '872': 'Paragangliomas and glomus tumors',
    '873': 'Nevi and melanomas',
    '874': 'Nevi and melanomas',
    '877': 'Nevi and melanomas',
    '880': 'Soft tissue tumors and sarcomas, NOS',
    '881': 'Fibromatous neoplasms',
    '883': 'Fibromatous neoplasms',
    '885': 'Lipomatous neoplasms',
    '889': 'Myomatous neoplasms',
    '890': 'Myomatous neoplasms',
    '891': 'Myomatous neoplasms',
    '892': 'Myomatous neoplasms',
    '892': 'Myomatous neoplasms',
    '893': 'Complex mixed and stromal neoplasms',
    '894': 'Complex mixed and stromal neoplasms',
    '895': 'Complex mixed and stromal neoplasms',
    '898': 'Complex mixed and stromal neoplasms',
    '902': 'Fibroepithelial neoplasms',
    '904': 'Synovial-like neoplasms',
    '905': 'Mesothelial neoplasms',
    '906': 'Germ cell neoplasms',
    '907': 'Germ cell neoplasms',
    '908': 'Germ cell neoplasms',
    '910': 'Trophoblastic neoplasms',
    '911': 'Mesonephromas',
    '912': 'Blood vessel tumors',
    '914': 'Blood vessel tumors',
    '915': 'Blood vessel tumors',
    '918': 'Osseous and chondromatous neoplasms',
    '922': 'Osseous and chondromatous neoplasms',
    '924': 'Osseous and chondromatous neoplasms',
    '926': 'Miscellaneous bone tumors',
    '936': 'Miscellaneous tumors',
    '938': 'Gliomas',
    '940': 'Gliomas',
    '942': 'Gliomas',
    '944': 'Gliomas',
    '945': 'Gliomas',
    '947': 'Gliomas',
    '954': 'Nerve sheath tumors',
    '956': 'Nerve sheath tumors',
}

# lab observations
obs_map = {
    'Hematology': {
        'Basophils': 'basophil',
        'Basos': 'basophil',
        'Eosinophils': 'eosinophil',
        'Eosin': 'eosinophil',
        'Eos': 'eosinophil',
        'Lymphocytes': 'lymphocyte',
        'Lymphs': 'lymphocyte',
        'Lymph': 'lymphocyte',
        'Monocytes': 'monocyte', 
        'Monos': 'monocyte',
        'Mono': 'monocyte', 
        'Neutrophils': 'neutrophil',
        
        # NOTE: Hb also exists in Biochemistry, but the procedure is different (arterial blood gas test instead of CBC)
        'Hb': 'hemoglobin',
        'Hct': 'hematocrit',
        'Plt': 'platelet',
        
        'MCH': 'mean_corpuscular_hemoglobin',
        'MCHC': 'mean_corpuscular_hemoglobin_concentration',
        'MCV': 'mean_corpuscular_volume',
        'MPV': 'mean_platelet_volume',
        'Mean Platelet Volume': 'mean_platelet_volume',
        'RBC': 'red_blood_cell',
        'RDW': 'red_cell_distribution_width',
        'WBC': 'white_blood_cell',

        'INR': 'prothrombin_time_international_normalized_ratio',
        'aPTT': 'activated_partial_thromboplastin_time',
        'APTT': 'activated_partial_thromboplastin_time',
    },
    'Biochemistry': {
        'Albumin': 'albumin',
        'Bicarbonate': 'bicarbonate',
        'Carcinoembryonic Antigen': 'carcinoembryonic_antigen',
        'Chloride': 'chloride',
        'Creatinine': 'creatinine',
        'Glucose': 'glucose',
        'Glucose, Random': 'glucose',
        'Magnesium': 'magnesium',
        'Phosphate': 'phosphate',
        'Potassium': 'potassium',
        'Sodium': 'sodium',
        'Total Bilirubin': 'total_bilirubin',
        'Tot Bilirubin': 'total_bilirubin',
        'Bilirubin,Total': 'total_bilirubin',
        'RDW-CV': 'red_cell_distribution_width',

        'AST': 'aspartate_aminotransferase',
        'ALT': 'alanine_aminotransferase',
        'ALP': 'alkaline_phosphatase',
        'Alkaline Phosphatase': 'alkaline_phosphatase',
        'CA 19-9': 'carbohydrate_antigen_19-9',
        'LDH': 'lactate_dehydrogenase',
        'Lactate Dehydrogenase': 'lactate_dehydrogenase',
    }
}

symp_cols = [
    'esas_pain',
    'esas_tiredness',
    'esas_nausea',
    'esas_depression',
    'esas_anxiety',
    'esas_drowsiness',
    'esas_appetite',
    'esas_well_being',
    'esas_shortness_of_breath',
    'patient_ecog',
]
lab_cols = [
    'alanine_aminotransferase',
    'albumin',
    'alkaline_phosphatase',
    'aspartate_aminotransferase',
    'basophil',
    'bicarbonate',
    'chloride',
    'creatinine',
    'eosinophil',
    'glucose',
    'hematocrit',
    'hemoglobin',
    'lactate_dehydrogenase',
    'lymphocyte',
    'magnesium',
    'mean_corpuscular_hemoglobin',
    'mean_corpuscular_hemoglobin_concentration',
    'mean_corpuscular_volume',
    'mean_platelet_volume',
    'monocyte',
    'neutrophil',
    'phosphate',
    'platelet',
    'potassium',
    'red_blood_cell',
    'red_cell_distribution_width',
    'sodium',
    'total_bilirubin',
    'white_blood_cell',
]
symp_change_cols = [f'{col}_change' for col in symp_cols]
lab_change_cols = [f'{col}_change' for col in lab_cols]
drug_cols = [
    '%_ideal_dose_given_CISPLATIN',
    '%_ideal_dose_given_FLUOROURACIL', 
    '%_ideal_dose_given_ETOPOSIDE',
    '%_ideal_dose_given_CARBOPLATIN', 
    '%_ideal_dose_given_OXALIPLATIN',
    '%_ideal_dose_given_PEMBROLIZUMAB', 
    '%_ideal_dose_given_NIVOLUMAB',
    '%_ideal_dose_given_DOCETAXEL', 
    '%_ideal_dose_given_CYCLOPHOSPHAMIDE',
    '%_ideal_dose_given_DURVALUMAB', 
    '%_ideal_dose_given_CETUXIMAB',
    '%_ideal_dose_given_RAMUCIRUMAB', 
    '%_ideal_dose_given_RALTITREXED',
    '%_ideal_dose_given_IPILIMUMAB', 
    '%_ideal_dose_given_MITOMYCIN',
    '%_ideal_dose_given_PANITUMUMAB', 
    '%_ideal_dose_given_CAPECITABINE',
    '%_ideal_dose_given_ERLOTINIB',
]