/* Copyright (c) 2024 PaddlePaddle Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */

#pragma once

#include <vector>
#include "paddle/phi/common/scalar.h"
#include "paddle/phi/core/distributed/auto_parallel/dist_meta_tensor.h"
#include "paddle/phi/core/distributed/type_defs.h"

namespace phi {
namespace distributed {
SpmdInfo CoalesceTensorInferSpmd(const std::vector<DistMetaTensor>& input,
                                 DataType dtype,
                                 bool copy_data,
                                 bool set_constant,
                                 bool persist_output,
                                 float constant,
                                 bool use_align,
                                 int align_size,
                                 int size_of_dtype,
                                 const std::vector<int64_t>& concated_shapes,
                                 const std::vector<int64_t>& concated_ranks);
}  // namespace distributed
}  // namespace phi
