// Copyright (c) 2025 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

namespace phi {
namespace funcs {
inline bool CanDispatchMaskFillShortcut(const DDim& input_dim,
                                        const DDim& mask_dim) {
  int64_t broadcast_dim = -1;
  for (size_t i = 0; i < input_dim.size(); i++) {
    if (input_dim[i] != mask_dim[i]) {
      broadcast_dim = i;
      break;
    }
  }

  for (size_t i = broadcast_dim; i < mask_dim.size(); i++) {
    if (mask_dim[i] != 1) {
      return false;
    }
  }
  return true;
}
}  // namespace funcs
}  // namespace phi
