# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAssetSourceResult',
    'AwaitableGetAssetSourceResult',
    'get_asset_source',
    'get_asset_source_output',
]

@pulumi.output_type
class GetAssetSourceResult:
    """
    A collection of values returned by getAssetSource.
    """
    def __init__(__self__, are_historical_metrics_collected=None, are_realtime_metrics_collected=None, asset_source_id=None, assets_compartment_id=None, compartment_id=None, defined_tags=None, discovery_credentials=None, discovery_schedule_id=None, display_name=None, environment_id=None, freeform_tags=None, id=None, inventory_id=None, lifecycle_details=None, replication_credentials=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None, vcenter_endpoint=None):
        if are_historical_metrics_collected and not isinstance(are_historical_metrics_collected, bool):
            raise TypeError("Expected argument 'are_historical_metrics_collected' to be a bool")
        pulumi.set(__self__, "are_historical_metrics_collected", are_historical_metrics_collected)
        if are_realtime_metrics_collected and not isinstance(are_realtime_metrics_collected, bool):
            raise TypeError("Expected argument 'are_realtime_metrics_collected' to be a bool")
        pulumi.set(__self__, "are_realtime_metrics_collected", are_realtime_metrics_collected)
        if asset_source_id and not isinstance(asset_source_id, str):
            raise TypeError("Expected argument 'asset_source_id' to be a str")
        pulumi.set(__self__, "asset_source_id", asset_source_id)
        if assets_compartment_id and not isinstance(assets_compartment_id, str):
            raise TypeError("Expected argument 'assets_compartment_id' to be a str")
        pulumi.set(__self__, "assets_compartment_id", assets_compartment_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if discovery_credentials and not isinstance(discovery_credentials, list):
            raise TypeError("Expected argument 'discovery_credentials' to be a list")
        pulumi.set(__self__, "discovery_credentials", discovery_credentials)
        if discovery_schedule_id and not isinstance(discovery_schedule_id, str):
            raise TypeError("Expected argument 'discovery_schedule_id' to be a str")
        pulumi.set(__self__, "discovery_schedule_id", discovery_schedule_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inventory_id and not isinstance(inventory_id, str):
            raise TypeError("Expected argument 'inventory_id' to be a str")
        pulumi.set(__self__, "inventory_id", inventory_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if replication_credentials and not isinstance(replication_credentials, list):
            raise TypeError("Expected argument 'replication_credentials' to be a list")
        pulumi.set(__self__, "replication_credentials", replication_credentials)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcenter_endpoint and not isinstance(vcenter_endpoint, str):
            raise TypeError("Expected argument 'vcenter_endpoint' to be a str")
        pulumi.set(__self__, "vcenter_endpoint", vcenter_endpoint)

    @property
    @pulumi.getter(name="areHistoricalMetricsCollected")
    def are_historical_metrics_collected(self) -> bool:
        """
        Flag indicating whether historical metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_historical_metrics_collected")

    @property
    @pulumi.getter(name="areRealtimeMetricsCollected")
    def are_realtime_metrics_collected(self) -> bool:
        """
        Flag indicating whether real-time metrics are collected for assets, originating from this asset source.
        """
        return pulumi.get(self, "are_realtime_metrics_collected")

    @property
    @pulumi.getter(name="assetSourceId")
    def asset_source_id(self) -> str:
        return pulumi.get(self, "asset_source_id")

    @property
    @pulumi.getter(name="assetsCompartmentId")
    def assets_compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that is going to be used to create assets.
        """
        return pulumi.get(self, "assets_compartment_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryCredentials")
    def discovery_credentials(self) -> Sequence['outputs.GetAssetSourceDiscoveryCredentialResult']:
        """
        Credentials for an asset source.
        """
        return pulumi.get(self, "discovery_credentials")

    @property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of an attached discovery schedule.
        """
        return pulumi.get(self, "discovery_schedule_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the asset source. Does not have to be unique, and it's mutable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the inventory that will contain created assets.
        """
        return pulumi.get(self, "inventory_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The detailed state of the asset source.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Sequence['outputs.GetAssetSourceReplicationCredentialResult']:
        """
        Credentials for an asset source.
        """
        return pulumi.get(self, "replication_credentials")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the asset source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the asset source was created in the RFC3339 format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The point in time that the asset source was last updated in the RFC3339 format.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of asset source. Indicates external origin of the assets that are read by assigning this asset source.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcenterEndpoint")
    def vcenter_endpoint(self) -> str:
        """
        Endpoint for VMware asset discovery and replication in the form of ```https://<host>:<port>/sdk```
        """
        return pulumi.get(self, "vcenter_endpoint")


class AwaitableGetAssetSourceResult(GetAssetSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetSourceResult(
            are_historical_metrics_collected=self.are_historical_metrics_collected,
            are_realtime_metrics_collected=self.are_realtime_metrics_collected,
            asset_source_id=self.asset_source_id,
            assets_compartment_id=self.assets_compartment_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            discovery_credentials=self.discovery_credentials,
            discovery_schedule_id=self.discovery_schedule_id,
            display_name=self.display_name,
            environment_id=self.environment_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            inventory_id=self.inventory_id,
            lifecycle_details=self.lifecycle_details,
            replication_credentials=self.replication_credentials,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            vcenter_endpoint=self.vcenter_endpoint)


def get_asset_source(asset_source_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetSourceResult:
    """
    This data source provides details about a specific Asset Source resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets the asset source by ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_asset_source = oci.CloudBridge.get_asset_source(asset_source_id=test_asset_source_oci_cloud_bridge_asset_source["id"])
    ```


    :param str asset_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the asset source.
    """
    __args__ = dict()
    __args__['assetSourceId'] = asset_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAssetSource:getAssetSource', __args__, opts=opts, typ=GetAssetSourceResult).value

    return AwaitableGetAssetSourceResult(
        are_historical_metrics_collected=pulumi.get(__ret__, 'are_historical_metrics_collected'),
        are_realtime_metrics_collected=pulumi.get(__ret__, 'are_realtime_metrics_collected'),
        asset_source_id=pulumi.get(__ret__, 'asset_source_id'),
        assets_compartment_id=pulumi.get(__ret__, 'assets_compartment_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        discovery_credentials=pulumi.get(__ret__, 'discovery_credentials'),
        discovery_schedule_id=pulumi.get(__ret__, 'discovery_schedule_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        inventory_id=pulumi.get(__ret__, 'inventory_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        replication_credentials=pulumi.get(__ret__, 'replication_credentials'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        vcenter_endpoint=pulumi.get(__ret__, 'vcenter_endpoint'))


@_utilities.lift_output_func(get_asset_source)
def get_asset_source_output(asset_source_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssetSourceResult]:
    """
    This data source provides details about a specific Asset Source resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets the asset source by ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_asset_source = oci.CloudBridge.get_asset_source(asset_source_id=test_asset_source_oci_cloud_bridge_asset_source["id"])
    ```


    :param str asset_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the asset source.
    """
    ...
