# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConsoleHistoriesResult',
    'AwaitableGetConsoleHistoriesResult',
    'get_console_histories',
    'get_console_histories_output',
]

@pulumi.output_type
class GetConsoleHistoriesResult:
    """
    A collection of values returned by getConsoleHistories.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, console_histories=None, filters=None, id=None, instance_id=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if console_histories and not isinstance(console_histories, list):
            raise TypeError("Expected argument 'console_histories' to be a list")
        pulumi.set(__self__, "console_histories", console_histories)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain of an instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consoleHistories")
    def console_histories(self) -> Sequence['outputs.GetConsoleHistoriesConsoleHistoryResult']:
        """
        The list of console_histories.
        """
        return pulumi.get(self, "console_histories")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConsoleHistoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The OCID of the instance this console history was fetched from.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the console history.
        """
        return pulumi.get(self, "state")


class AwaitableGetConsoleHistoriesResult(GetConsoleHistoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConsoleHistoriesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            console_histories=self.console_histories,
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            state=self.state)


def get_console_histories(availability_domain: Optional[str] = None,
                          compartment_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetConsoleHistoriesFilterArgs', 'GetConsoleHistoriesFilterArgsDict']]] = None,
                          instance_id: Optional[str] = None,
                          state: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConsoleHistoriesResult:
    """
    This data source provides the list of Console Histories in Oracle Cloud Infrastructure Core service.

    Lists the console history metadata for the specified compartment or instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_console_histories = oci.Core.get_console_histories(compartment_id=compartment_id,
        availability_domain=console_history_availability_domain,
        instance_id=test_instance["id"],
        state=console_history_state)
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['instanceId'] = instance_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getConsoleHistories:getConsoleHistories', __args__, opts=opts, typ=GetConsoleHistoriesResult).value

    return AwaitableGetConsoleHistoriesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        console_histories=pulumi.get(__ret__, 'console_histories'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_console_histories)
def get_console_histories_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                 compartment_id: Optional[pulumi.Input[str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetConsoleHistoriesFilterArgs', 'GetConsoleHistoriesFilterArgsDict']]]]] = None,
                                 instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConsoleHistoriesResult]:
    """
    This data source provides the list of Console Histories in Oracle Cloud Infrastructure Core service.

    Lists the console history metadata for the specified compartment or instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_console_histories = oci.Core.get_console_histories(compartment_id=compartment_id,
        availability_domain=console_history_availability_domain,
        instance_id=test_instance["id"],
        state=console_history_state)
    ```


    :param str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str instance_id: The OCID of the instance.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    ...
