# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupBackupArgs', 'VolumeGroupBackup']

@pulumi.input_type
class VolumeGroupBackupArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_details: Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VolumeGroupBackup resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['VolumeGroupBackupSourceDetailsArgs'] source_details: Details of the volume group backup source in the cloud.
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental.
               * Allowed values are :
               * FULL
               * INCREMENTAL
        :param pulumi.Input[str] volume_group_id: The OCID of the volume group that needs to be backed up.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_group_id is not None:
            pulumi.set(__self__, "volume_group_id", volume_group_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']]:
        """
        Details of the volume group backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup to create. If omitted, defaults to incremental.
        * Allowed values are :
        * FULL
        * INCREMENTAL
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the volume group that needs to be backed up.
        """
        return pulumi.get(self, "volume_group_id")

    @volume_group_id.setter
    def volume_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_group_id", value)


@pulumi.input_type
class _VolumeGroupBackupState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 size_in_gbs: Optional[pulumi.Input[str]] = None,
                 size_in_mbs: Optional[pulumi.Input[str]] = None,
                 source_details: Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 source_volume_group_backup_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_request_received: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unique_size_in_gbs: Optional[pulumi.Input[str]] = None,
                 unique_size_in_mbs: Optional[pulumi.Input[str]] = None,
                 volume_backup_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 volume_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupBackup resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] expiration_time: The date and time the volume group backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for volume group backups that were created automatically by a scheduled-backup policy. For manually created volume group backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] size_in_gbs: The aggregate size of the volume group backup, in GBs.
        :param pulumi.Input[str] size_in_mbs: The aggregate size of the volume group backup, in MBs.
        :param pulumi.Input['VolumeGroupBackupSourceDetailsArgs'] source_details: Details of the volume group backup source in the cloud.
        :param pulumi.Input[str] source_type: Specifies whether the volume group backup was created manually, or via scheduled backup policy.
        :param pulumi.Input[str] source_volume_group_backup_id: The OCID of the source volume group backup.
        :param pulumi.Input[str] state: The current state of a volume group backup.
        :param pulumi.Input[str] time_created: The date and time the volume group backup was created. This is the time the actual point-in-time image of the volume group data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_request_received: The date and time the request to create the volume group backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental.
               * Allowed values are :
               * FULL
               * INCREMENTAL
        :param pulumi.Input[str] unique_size_in_gbs: The aggregate size used by the volume group backup, in GBs.  It is typically smaller than `size_in_gbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        :param pulumi.Input[str] unique_size_in_mbs: The aggregate size used by the volume group backup, in MBs.  It is typically smaller than `size_in_mbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_backup_ids: OCIDs for the volume backups in this volume group backup.
        :param pulumi.Input[str] volume_group_id: The OCID of the volume group that needs to be backed up.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if size_in_gbs is not None:
            pulumi.set(__self__, "size_in_gbs", size_in_gbs)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if source_volume_group_backup_id is not None:
            pulumi.set(__self__, "source_volume_group_backup_id", source_volume_group_backup_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_request_received is not None:
            pulumi.set(__self__, "time_request_received", time_request_received)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unique_size_in_gbs is not None:
            pulumi.set(__self__, "unique_size_in_gbs", unique_size_in_gbs)
        if unique_size_in_mbs is not None:
            pulumi.set(__self__, "unique_size_in_mbs", unique_size_in_mbs)
        if volume_backup_ids is not None:
            pulumi.set(__self__, "volume_backup_ids", volume_backup_ids)
        if volume_group_id is not None:
            pulumi.set(__self__, "volume_group_id", volume_group_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the volume group backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for volume group backups that were created automatically by a scheduled-backup policy. For manually created volume group backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregate size of the volume group backup, in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @size_in_gbs.setter
    def size_in_gbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_gbs", value)

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregate size of the volume group backup, in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_mbs", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']]:
        """
        Details of the volume group backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['VolumeGroupBackupSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the volume group backup was created manually, or via scheduled backup policy.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="sourceVolumeGroupBackupId")
    def source_volume_group_backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the source volume group backup.
        """
        return pulumi.get(self, "source_volume_group_backup_id")

    @source_volume_group_backup_id.setter
    def source_volume_group_backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_volume_group_backup_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of a volume group backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the volume group backup was created. This is the time the actual point-in-time image of the volume group data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeRequestReceived")
    def time_request_received(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the request to create the volume group backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_request_received")

    @time_request_received.setter
    def time_request_received(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_request_received", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup to create. If omitted, defaults to incremental.
        * Allowed values are :
        * FULL
        * INCREMENTAL
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uniqueSizeInGbs")
    def unique_size_in_gbs(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregate size used by the volume group backup, in GBs.  It is typically smaller than `size_in_gbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_gbs")

    @unique_size_in_gbs.setter
    def unique_size_in_gbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_size_in_gbs", value)

    @property
    @pulumi.getter(name="uniqueSizeInMbs")
    def unique_size_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregate size used by the volume group backup, in MBs.  It is typically smaller than `size_in_mbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_mbs")

    @unique_size_in_mbs.setter
    def unique_size_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_size_in_mbs", value)

    @property
    @pulumi.getter(name="volumeBackupIds")
    def volume_backup_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        OCIDs for the volume backups in this volume group backup.
        """
        return pulumi.get(self, "volume_backup_ids")

    @volume_backup_ids.setter
    def volume_backup_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volume_backup_ids", value)

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the volume group that needs to be backed up.
        """
        return pulumi.get(self, "volume_group_id")

    @volume_group_id.setter
    def volume_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_group_id", value)


class VolumeGroupBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeGroupBackupSourceDetailsArgs', 'VolumeGroupBackupSourceDetailsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Volume Group Backup resource in Oracle Cloud Infrastructure Core service.

        Creates a new backup volume group of the specified volume group.
        For more information, see [Volume Groups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/volumegroups.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_group_backup = oci.core.VolumeGroupBackup("test_volume_group_backup",
            volume_group_id=test_volume_group["id"],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_group_backup_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            type=volume_group_backup_type)
        ```

        ## Import

        VolumeGroupBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeGroupBackup:VolumeGroupBackup test_volume_group_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['VolumeGroupBackupSourceDetailsArgs', 'VolumeGroupBackupSourceDetailsArgsDict']] source_details: Details of the volume group backup source in the cloud.
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental.
               * Allowed values are :
               * FULL
               * INCREMENTAL
        :param pulumi.Input[str] volume_group_id: The OCID of the volume group that needs to be backed up.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VolumeGroupBackupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Volume Group Backup resource in Oracle Cloud Infrastructure Core service.

        Creates a new backup volume group of the specified volume group.
        For more information, see [Volume Groups](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/volumegroups.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_volume_group_backup = oci.core.VolumeGroupBackup("test_volume_group_backup",
            volume_group_id=test_volume_group["id"],
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=volume_group_backup_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            type=volume_group_backup_type)
        ```

        ## Import

        VolumeGroupBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/volumeGroupBackup:VolumeGroupBackup test_volume_group_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_details: Optional[pulumi.Input[Union['VolumeGroupBackupSourceDetailsArgs', 'VolumeGroupBackupSourceDetailsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupBackupArgs.__new__(VolumeGroupBackupArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["type"] = type
            __props__.__dict__["volume_group_id"] = volume_group_id
            __props__.__dict__["expiration_time"] = None
            __props__.__dict__["size_in_gbs"] = None
            __props__.__dict__["size_in_mbs"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["source_volume_group_backup_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_request_received"] = None
            __props__.__dict__["unique_size_in_gbs"] = None
            __props__.__dict__["unique_size_in_mbs"] = None
            __props__.__dict__["volume_backup_ids"] = None
        super(VolumeGroupBackup, __self__).__init__(
            'oci:Core/volumeGroupBackup:VolumeGroupBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            expiration_time: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            size_in_gbs: Optional[pulumi.Input[str]] = None,
            size_in_mbs: Optional[pulumi.Input[str]] = None,
            source_details: Optional[pulumi.Input[Union['VolumeGroupBackupSourceDetailsArgs', 'VolumeGroupBackupSourceDetailsArgsDict']]] = None,
            source_type: Optional[pulumi.Input[str]] = None,
            source_volume_group_backup_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_request_received: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            unique_size_in_gbs: Optional[pulumi.Input[str]] = None,
            unique_size_in_mbs: Optional[pulumi.Input[str]] = None,
            volume_backup_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            volume_group_id: Optional[pulumi.Input[str]] = None) -> 'VolumeGroupBackup':
        """
        Get an existing VolumeGroupBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] expiration_time: The date and time the volume group backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for volume group backups that were created automatically by a scheduled-backup policy. For manually created volume group backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] size_in_gbs: The aggregate size of the volume group backup, in GBs.
        :param pulumi.Input[str] size_in_mbs: The aggregate size of the volume group backup, in MBs.
        :param pulumi.Input[Union['VolumeGroupBackupSourceDetailsArgs', 'VolumeGroupBackupSourceDetailsArgsDict']] source_details: Details of the volume group backup source in the cloud.
        :param pulumi.Input[str] source_type: Specifies whether the volume group backup was created manually, or via scheduled backup policy.
        :param pulumi.Input[str] source_volume_group_backup_id: The OCID of the source volume group backup.
        :param pulumi.Input[str] state: The current state of a volume group backup.
        :param pulumi.Input[str] time_created: The date and time the volume group backup was created. This is the time the actual point-in-time image of the volume group data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_request_received: The date and time the request to create the volume group backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] type: The type of backup to create. If omitted, defaults to incremental.
               * Allowed values are :
               * FULL
               * INCREMENTAL
        :param pulumi.Input[str] unique_size_in_gbs: The aggregate size used by the volume group backup, in GBs.  It is typically smaller than `size_in_gbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        :param pulumi.Input[str] unique_size_in_mbs: The aggregate size used by the volume group backup, in MBs.  It is typically smaller than `size_in_mbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_backup_ids: OCIDs for the volume backups in this volume group backup.
        :param pulumi.Input[str] volume_group_id: The OCID of the volume group that needs to be backed up.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupBackupState.__new__(_VolumeGroupBackupState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["size_in_gbs"] = size_in_gbs
        __props__.__dict__["size_in_mbs"] = size_in_mbs
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["source_volume_group_backup_id"] = source_volume_group_backup_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_request_received"] = time_request_received
        __props__.__dict__["type"] = type
        __props__.__dict__["unique_size_in_gbs"] = unique_size_in_gbs
        __props__.__dict__["unique_size_in_mbs"] = unique_size_in_mbs
        __props__.__dict__["volume_backup_ids"] = volume_backup_ids
        __props__.__dict__["volume_group_id"] = volume_group_id
        return VolumeGroupBackup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that will contain the volume group backup. This parameter is optional, by default backup will be created in the same compartment and source volume group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[str]:
        """
        The date and time the volume group backup will expire and be automatically deleted. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). This parameter will always be present for volume group backups that were created automatically by a scheduled-backup policy. For manually created volume group backups, it will be absent, signifying that there is no expiration time and the backup will last forever until manually deleted.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="sizeInGbs")
    def size_in_gbs(self) -> pulumi.Output[str]:
        """
        The aggregate size of the volume group backup, in GBs.
        """
        return pulumi.get(self, "size_in_gbs")

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> pulumi.Output[str]:
        """
        The aggregate size of the volume group backup, in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output[Optional['outputs.VolumeGroupBackupSourceDetails']]:
        """
        Details of the volume group backup source in the cloud.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        Specifies whether the volume group backup was created manually, or via scheduled backup policy.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="sourceVolumeGroupBackupId")
    def source_volume_group_backup_id(self) -> pulumi.Output[str]:
        """
        The OCID of the source volume group backup.
        """
        return pulumi.get(self, "source_volume_group_backup_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of a volume group backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the volume group backup was created. This is the time the actual point-in-time image of the volume group data was taken. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeRequestReceived")
    def time_request_received(self) -> pulumi.Output[str]:
        """
        The date and time the request to create the volume group backup was received. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_request_received")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of backup to create. If omitted, defaults to incremental.
        * Allowed values are :
        * FULL
        * INCREMENTAL
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueSizeInGbs")
    def unique_size_in_gbs(self) -> pulumi.Output[str]:
        """
        The aggregate size used by the volume group backup, in GBs.  It is typically smaller than `size_in_gbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_gbs")

    @property
    @pulumi.getter(name="uniqueSizeInMbs")
    def unique_size_in_mbs(self) -> pulumi.Output[str]:
        """
        The aggregate size used by the volume group backup, in MBs.  It is typically smaller than `size_in_mbs`, depending on the space consumed on the volume group and whether the volume backup is full or incremental.
        """
        return pulumi.get(self, "unique_size_in_mbs")

    @property
    @pulumi.getter(name="volumeBackupIds")
    def volume_backup_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        OCIDs for the volume backups in this volume group backup.
        """
        return pulumi.get(self, "volume_backup_ids")

    @property
    @pulumi.getter(name="volumeGroupId")
    def volume_group_id(self) -> pulumi.Output[str]:
        """
        The OCID of the volume group that needs to be backed up.
        """
        return pulumi.get(self, "volume_group_id")

