# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudExadataInfrastructureArgs', 'CloudExadataInfrastructure']

@pulumi.input_type
class CloudExadataInfrastructureArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 shape: pulumi.Input[str],
                 cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CloudExadataInfrastructure resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the cloud Exadata infrastructure is located.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[str] shape: The shape of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[int] compute_count: (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]] customer_contacts: (Updatable) Customer contacts.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] storage_count: (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "shape", shape)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain where the cloud Exadata infrastructure is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        The shape of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]]:
        """
        (Updatable) Customer contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]]):
        pulumi.set(self, "customer_contacts", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _CloudExadataInfrastructureState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[int]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 available_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 cpu_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_server_version: Optional[pulumi.Input[str]] = None,
                 defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']] = None,
                 max_cpu_count: Optional[pulumi.Input[int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[str]] = None,
                 monthly_storage_server_version: Optional[pulumi.Input[str]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 storage_server_version: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 total_storage_size_in_gbs: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CloudExadataInfrastructure resources.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] availability_domain: The availability domain where the cloud Exadata infrastructure is located.
        :param pulumi.Input[int] available_storage_size_in_gbs: The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[int] cpu_count: The total number of CPU cores allocated.
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]] customer_contacts: (Updatable) Customer contacts.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs']]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] monthly_storage_server_version: The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[str] shape: The shape of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] state: The current lifecycle state of the cloud Exadata infrastructure resource.
        :param pulumi.Input[int] storage_count: (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] time_created: The date and time the cloud Exadata infrastructure resource was created.
        :param pulumi.Input[int] total_storage_size_in_gbs: The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        if activated_storage_count is not None:
            pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_storage_count is not None:
            pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if available_storage_size_in_gbs is not None:
            pulumi.set(__self__, "available_storage_size_in_gbs", available_storage_size_in_gbs)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if customer_contacts is not None:
            pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            pulumi.set(__self__, "db_server_version", db_server_version)
        if defined_file_system_configurations is not None:
            pulumi.set(__self__, "defined_file_system_configurations", defined_file_system_configurations)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_cpu_count is not None:
            pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if monthly_storage_server_version is not None:
            pulumi.set(__self__, "monthly_storage_server_version", monthly_storage_server_version)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_version is not None:
            pulumi.set(__self__, "storage_server_version", storage_server_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if total_storage_size_in_gbs is not None:
            pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activated_storage_count", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain where the cloud Exadata infrastructure is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @available_storage_size_in_gbs.setter
    def available_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of CPU cores allocated.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]]:
        """
        (Updatable) Customer contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @customer_contacts.setter
    def customer_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactArgs']]]]):
        pulumi.set(self, "customer_contacts", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_server_version", value)

    @property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs']]]]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @defined_file_system_configurations.setter
    def defined_file_system_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs']]]]):
        pulumi.set(self, "defined_file_system_configurations", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_count", value)

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @monthly_storage_server_version.setter
    def monthly_storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monthly_storage_server_version", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[str]]:
        """
        The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_server_version", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the cloud Exadata infrastructure resource was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

    @total_storage_size_in_gbs.setter
    def total_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_storage_size_in_gbs", value)


class CloudExadataInfrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactArgs', 'CloudExadataInfrastructureCustomerContactArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Cloud Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

        Creates a cloud Exadata infrastructure resource. This resource is used to create either an [Exadata Cloud Service](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm) instance or an Autonomous Database on dedicated Exadata infrastructure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_exadata_infrastructure = oci.database.CloudExadataInfrastructure("test_cloud_exadata_infrastructure",
            availability_domain=cloud_exadata_infrastructure_availability_domain,
            compartment_id=compartment_id,
            display_name=cloud_exadata_infrastructure_display_name,
            shape=cloud_exadata_infrastructure_shape,
            cluster_placement_group_id=cloud_exadata_infrastructure_cluster_placement_group_id,
            compute_count=cloud_exadata_infrastructure_compute_count,
            customer_contacts=[{
                "email": cloud_exadata_infrastructure_customer_contacts_email,
            }],
            defined_tags=cloud_exadata_infrastructure_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            maintenance_window={
                "custom_action_timeout_in_mins": cloud_exadata_infrastructure_maintenance_window_custom_action_timeout_in_mins,
                "days_of_weeks": [{
                    "name": cloud_exadata_infrastructure_maintenance_window_days_of_week_name,
                }],
                "hours_of_days": cloud_exadata_infrastructure_maintenance_window_hours_of_day,
                "is_custom_action_timeout_enabled": cloud_exadata_infrastructure_maintenance_window_is_custom_action_timeout_enabled,
                "is_monthly_patching_enabled": cloud_exadata_infrastructure_maintenance_window_is_monthly_patching_enabled,
                "lead_time_in_weeks": cloud_exadata_infrastructure_maintenance_window_lead_time_in_weeks,
                "months": [{
                    "name": cloud_exadata_infrastructure_maintenance_window_months_name,
                }],
                "patching_mode": cloud_exadata_infrastructure_maintenance_window_patching_mode,
                "preference": cloud_exadata_infrastructure_maintenance_window_preference,
                "weeks_of_months": cloud_exadata_infrastructure_maintenance_window_weeks_of_month,
            },
            storage_count=cloud_exadata_infrastructure_storage_count,
            subscription_id=tenant_subscription_id)
        ```

        ## Import

        CloudExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudExadataInfrastructure:CloudExadataInfrastructure test_cloud_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain where the cloud Exadata infrastructure is located.
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactArgs', 'CloudExadataInfrastructureCustomerContactArgsDict']]]] customer_contacts: (Updatable) Customer contacts.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[str] shape: The shape of the cloud Exadata infrastructure resource.
        :param pulumi.Input[int] storage_count: (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudExadataInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cloud Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

        Creates a cloud Exadata infrastructure resource. This resource is used to create either an [Exadata Cloud Service](https://docs.cloud.oracle.com/iaas/Content/Database/Concepts/exaoverview.htm) instance or an Autonomous Database on dedicated Exadata infrastructure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_exadata_infrastructure = oci.database.CloudExadataInfrastructure("test_cloud_exadata_infrastructure",
            availability_domain=cloud_exadata_infrastructure_availability_domain,
            compartment_id=compartment_id,
            display_name=cloud_exadata_infrastructure_display_name,
            shape=cloud_exadata_infrastructure_shape,
            cluster_placement_group_id=cloud_exadata_infrastructure_cluster_placement_group_id,
            compute_count=cloud_exadata_infrastructure_compute_count,
            customer_contacts=[{
                "email": cloud_exadata_infrastructure_customer_contacts_email,
            }],
            defined_tags=cloud_exadata_infrastructure_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            maintenance_window={
                "custom_action_timeout_in_mins": cloud_exadata_infrastructure_maintenance_window_custom_action_timeout_in_mins,
                "days_of_weeks": [{
                    "name": cloud_exadata_infrastructure_maintenance_window_days_of_week_name,
                }],
                "hours_of_days": cloud_exadata_infrastructure_maintenance_window_hours_of_day,
                "is_custom_action_timeout_enabled": cloud_exadata_infrastructure_maintenance_window_is_custom_action_timeout_enabled,
                "is_monthly_patching_enabled": cloud_exadata_infrastructure_maintenance_window_is_monthly_patching_enabled,
                "lead_time_in_weeks": cloud_exadata_infrastructure_maintenance_window_lead_time_in_weeks,
                "months": [{
                    "name": cloud_exadata_infrastructure_maintenance_window_months_name,
                }],
                "patching_mode": cloud_exadata_infrastructure_maintenance_window_patching_mode,
                "preference": cloud_exadata_infrastructure_maintenance_window_preference,
                "weeks_of_months": cloud_exadata_infrastructure_maintenance_window_weeks_of_month,
            },
            storage_count=cloud_exadata_infrastructure_storage_count,
            subscription_id=tenant_subscription_id)
        ```

        ## Import

        CloudExadataInfrastructures can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudExadataInfrastructure:CloudExadataInfrastructure test_cloud_exadata_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudExadataInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudExadataInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactArgs', 'CloudExadataInfrastructureCustomerContactArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudExadataInfrastructureArgs.__new__(CloudExadataInfrastructureArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["customer_contacts"] = customer_contacts
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["maintenance_window"] = maintenance_window
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["storage_count"] = storage_count
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["available_storage_size_in_gbs"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["defined_file_system_configurations"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["monthly_storage_server_version"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["total_storage_size_in_gbs"] = None
        super(CloudExadataInfrastructure, __self__).__init__(
            'oci:Database/cloudExadataInfrastructure:CloudExadataInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[int]] = None,
            additional_storage_count: Optional[pulumi.Input[int]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            available_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[int]] = None,
            cpu_count: Optional[pulumi.Input[int]] = None,
            customer_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactArgs', 'CloudExadataInfrastructureCustomerContactArgsDict']]]]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_server_version: Optional[pulumi.Input[str]] = None,
            defined_file_system_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs', 'CloudExadataInfrastructureDefinedFileSystemConfigurationArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
            max_cpu_count: Optional[pulumi.Input[int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[str]] = None,
            monthly_storage_server_version: Optional[pulumi.Input[str]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_count: Optional[pulumi.Input[int]] = None,
            storage_server_version: Optional[pulumi.Input[str]] = None,
            subscription_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            total_storage_size_in_gbs: Optional[pulumi.Input[int]] = None) -> 'CloudExadataInfrastructure':
        """
        Get an existing CloudExadataInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] activated_storage_count: The requested number of additional storage servers activated for the Exadata infrastructure.
        :param pulumi.Input[int] additional_storage_count: The requested number of additional storage servers for the Exadata infrastructure.
        :param pulumi.Input[str] availability_domain: The availability domain where the cloud Exadata infrastructure is located.
        :param pulumi.Input[int] available_storage_size_in_gbs: The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        :param pulumi.Input[str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] compute_count: (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        :param pulumi.Input[int] cpu_count: The total number of CPU cores allocated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactArgs', 'CloudExadataInfrastructureCustomerContactArgsDict']]]] customer_contacts: (Updatable) Customer contacts.
        :param pulumi.Input[float] data_storage_size_in_tbs: Size, in terabytes, of the DATA disk group.
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[str] db_server_version: The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureDefinedFileSystemConfigurationArgs', 'CloudExadataInfrastructureDefinedFileSystemConfigurationArgsDict']]]] defined_file_system_configurations: Details of the file system configuration of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']] maintenance_window: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_cpu_count: The total number of CPU cores available.
        :param pulumi.Input[float] max_data_storage_in_tbs: The total available DATA disk group size.
        :param pulumi.Input[int] max_db_node_storage_in_gbs: The total local node storage available in GBs.
        :param pulumi.Input[int] max_memory_in_gbs: The total memory available in GBs.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] monthly_db_server_version: The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] monthly_storage_server_version: The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[str] shape: The shape of the cloud Exadata infrastructure resource.
        :param pulumi.Input[str] state: The current lifecycle state of the cloud Exadata infrastructure resource.
        :param pulumi.Input[int] storage_count: (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        :param pulumi.Input[str] storage_server_version: The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        :param pulumi.Input[str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] time_created: The date and time the cloud Exadata infrastructure resource was created.
        :param pulumi.Input[int] total_storage_size_in_gbs: The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudExadataInfrastructureState.__new__(_CloudExadataInfrastructureState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["available_storage_size_in_gbs"] = available_storage_size_in_gbs
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["customer_contacts"] = customer_contacts
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["defined_file_system_configurations"] = defined_file_system_configurations
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["monthly_storage_server_version"] = monthly_storage_server_version
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["total_storage_size_in_gbs"] = total_storage_size_in_gbs
        return CloudExadataInfrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[int]:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain where the cloud Exadata infrastructure is located.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[int]:
        """
        The total number of CPU cores allocated.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureCustomerContact']]:
        """
        (Updatable) Customer contacts.
        """
        return pulumi.get(self, "customer_contacts")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "db_server_version")

    @property
    @pulumi.getter(name="definedFileSystemConfigurations")
    def defined_file_system_configurations(self) -> pulumi.Output[Sequence['outputs.CloudExadataInfrastructureDefinedFileSystemConfiguration']]:
        """
        Details of the file system configuration of the Exadata infrastructure.
        """
        return pulumi.get(self, "defined_file_system_configurations")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.CloudExadataInfrastructureMaintenanceWindow']:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[int]:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[float]:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[int]:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[int]:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[str]:
        """
        The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_db_server_version")

    @property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> pulumi.Output[str]:
        """
        The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[str]:
        """
        The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "storage_server_version")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the cloud Exadata infrastructure resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

