# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult',
    'AwaitableGetManagedDatabaseOptimizerStatisticsCollectionOperationsResult',
    'get_managed_database_optimizer_statistics_collection_operations',
    'get_managed_database_optimizer_statistics_collection_operations_output',
]

@pulumi.output_type
class GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult:
    """
    A collection of values returned by getManagedDatabaseOptimizerStatisticsCollectionOperations.
    """
    def __init__(__self__, end_time_less_than_or_equal_to=None, filter_by=None, filters=None, id=None, limit=None, managed_database_id=None, optimizer_statistics_collection_operations_collections=None, start_time_greater_than_or_equal_to=None, task_type=None):
        if end_time_less_than_or_equal_to and not isinstance(end_time_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'end_time_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "end_time_less_than_or_equal_to", end_time_less_than_or_equal_to)
        if filter_by and not isinstance(filter_by, str):
            raise TypeError("Expected argument 'filter_by' to be a str")
        pulumi.set(__self__, "filter_by", filter_by)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if optimizer_statistics_collection_operations_collections and not isinstance(optimizer_statistics_collection_operations_collections, list):
            raise TypeError("Expected argument 'optimizer_statistics_collection_operations_collections' to be a list")
        pulumi.set(__self__, "optimizer_statistics_collection_operations_collections", optimizer_statistics_collection_operations_collections)
        if start_time_greater_than_or_equal_to and not isinstance(start_time_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'start_time_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "start_time_greater_than_or_equal_to", start_time_greater_than_or_equal_to)
        if task_type and not isinstance(task_type, str):
            raise TypeError("Expected argument 'task_type' to be a str")
        pulumi.set(__self__, "task_type", task_type)

    @property
    @pulumi.getter(name="endTimeLessThanOrEqualTo")
    def end_time_less_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "end_time_less_than_or_equal_to")

    @property
    @pulumi.getter(name="filterBy")
    def filter_by(self) -> Optional[str]:
        return pulumi.get(self, "filter_by")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseOptimizerStatisticsCollectionOperationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="optimizerStatisticsCollectionOperationsCollections")
    def optimizer_statistics_collection_operations_collections(self) -> Sequence['outputs.GetManagedDatabaseOptimizerStatisticsCollectionOperationsOptimizerStatisticsCollectionOperationsCollectionResult']:
        """
        The list of optimizer_statistics_collection_operations_collection.
        """
        return pulumi.get(self, "optimizer_statistics_collection_operations_collections")

    @property
    @pulumi.getter(name="startTimeGreaterThanOrEqualTo")
    def start_time_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "start_time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[str]:
        return pulumi.get(self, "task_type")


class AwaitableGetManagedDatabaseOptimizerStatisticsCollectionOperationsResult(GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult(
            end_time_less_than_or_equal_to=self.end_time_less_than_or_equal_to,
            filter_by=self.filter_by,
            filters=self.filters,
            id=self.id,
            limit=self.limit,
            managed_database_id=self.managed_database_id,
            optimizer_statistics_collection_operations_collections=self.optimizer_statistics_collection_operations_collections,
            start_time_greater_than_or_equal_to=self.start_time_greater_than_or_equal_to,
            task_type=self.task_type)


def get_managed_database_optimizer_statistics_collection_operations(end_time_less_than_or_equal_to: Optional[str] = None,
                                                                    filter_by: Optional[str] = None,
                                                                    filters: Optional[Sequence[Union['GetManagedDatabaseOptimizerStatisticsCollectionOperationsFilterArgs', 'GetManagedDatabaseOptimizerStatisticsCollectionOperationsFilterArgsDict']]] = None,
                                                                    limit: Optional[int] = None,
                                                                    managed_database_id: Optional[str] = None,
                                                                    start_time_greater_than_or_equal_to: Optional[str] = None,
                                                                    task_type: Optional[str] = None,
                                                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseOptimizerStatisticsCollectionOperationsResult:
    """
    This data source provides the list of Managed Database Optimizer Statistics Collection Operations in Oracle Cloud Infrastructure Database Management service.

    Lists the optimizer statistics (Auto and Manual) task operation summary for the specified Managed Database.
    The summary includes the details of each operation and the number of tasks grouped by status: Completed, In Progress, Failed, and so on.
    Optionally, you can specify a date-time range (of seven days) to obtain the list of operations that fall within the specified time range.
    If the date-time range is not specified, then the operations in the last seven days are listed.
    This API also enables the pagination of results and the opc-next-page response header indicates whether there is a next page.
    If you use the same header value in a consecutive request, the next page records are returned.
    To obtain the required results, you can apply the different types of filters supported by this API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_collection_operations = oci.DatabaseManagement.get_managed_database_optimizer_statistics_collection_operations(managed_database_id=test_managed_database["id"],
        end_time_less_than_or_equal_to=managed_database_optimizer_statistics_collection_operation_end_time_less_than_or_equal_to,
        filter_by=managed_database_optimizer_statistics_collection_operation_filter_by,
        start_time_greater_than_or_equal_to=managed_database_optimizer_statistics_collection_operation_start_time_greater_than_or_equal_to,
        task_type=managed_database_optimizer_statistics_collection_operation_task_type)
    ```


    :param str end_time_less_than_or_equal_to: The end time of the time range to retrieve the optimizer statistics of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str filter_by: The parameter used to filter the optimizer statistics operations. Any property of the OptimizerStatisticsCollectionOperationSummary can be used to define the filter condition. The allowed conditional operators are AND or OR, and the allowed binary operators are are >, < and =. Any other operator is regarded invalid. Example: jobName=<replace with job name> AND status=<replace with status>
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str start_time_greater_than_or_equal_to: The start time of the time range to retrieve the optimizer statistics of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str task_type: The filter types of the optimizer statistics tasks.
    """
    __args__ = dict()
    __args__['endTimeLessThanOrEqualTo'] = end_time_less_than_or_equal_to
    __args__['filterBy'] = filter_by
    __args__['filters'] = filters
    __args__['limit'] = limit
    __args__['managedDatabaseId'] = managed_database_id
    __args__['startTimeGreaterThanOrEqualTo'] = start_time_greater_than_or_equal_to
    __args__['taskType'] = task_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseOptimizerStatisticsCollectionOperations:getManagedDatabaseOptimizerStatisticsCollectionOperations', __args__, opts=opts, typ=GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult).value

    return AwaitableGetManagedDatabaseOptimizerStatisticsCollectionOperationsResult(
        end_time_less_than_or_equal_to=pulumi.get(__ret__, 'end_time_less_than_or_equal_to'),
        filter_by=pulumi.get(__ret__, 'filter_by'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        optimizer_statistics_collection_operations_collections=pulumi.get(__ret__, 'optimizer_statistics_collection_operations_collections'),
        start_time_greater_than_or_equal_to=pulumi.get(__ret__, 'start_time_greater_than_or_equal_to'),
        task_type=pulumi.get(__ret__, 'task_type'))


@_utilities.lift_output_func(get_managed_database_optimizer_statistics_collection_operations)
def get_managed_database_optimizer_statistics_collection_operations_output(end_time_less_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                                                           filter_by: Optional[pulumi.Input[Optional[str]]] = None,
                                                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedDatabaseOptimizerStatisticsCollectionOperationsFilterArgs', 'GetManagedDatabaseOptimizerStatisticsCollectionOperationsFilterArgsDict']]]]] = None,
                                                                           limit: Optional[pulumi.Input[Optional[int]]] = None,
                                                                           managed_database_id: Optional[pulumi.Input[str]] = None,
                                                                           start_time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                                                           task_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseOptimizerStatisticsCollectionOperationsResult]:
    """
    This data source provides the list of Managed Database Optimizer Statistics Collection Operations in Oracle Cloud Infrastructure Database Management service.

    Lists the optimizer statistics (Auto and Manual) task operation summary for the specified Managed Database.
    The summary includes the details of each operation and the number of tasks grouped by status: Completed, In Progress, Failed, and so on.
    Optionally, you can specify a date-time range (of seven days) to obtain the list of operations that fall within the specified time range.
    If the date-time range is not specified, then the operations in the last seven days are listed.
    This API also enables the pagination of results and the opc-next-page response header indicates whether there is a next page.
    If you use the same header value in a consecutive request, the next page records are returned.
    To obtain the required results, you can apply the different types of filters supported by this API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_optimizer_statistics_collection_operations = oci.DatabaseManagement.get_managed_database_optimizer_statistics_collection_operations(managed_database_id=test_managed_database["id"],
        end_time_less_than_or_equal_to=managed_database_optimizer_statistics_collection_operation_end_time_less_than_or_equal_to,
        filter_by=managed_database_optimizer_statistics_collection_operation_filter_by,
        start_time_greater_than_or_equal_to=managed_database_optimizer_statistics_collection_operation_start_time_greater_than_or_equal_to,
        task_type=managed_database_optimizer_statistics_collection_operation_task_type)
    ```


    :param str end_time_less_than_or_equal_to: The end time of the time range to retrieve the optimizer statistics of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str filter_by: The parameter used to filter the optimizer statistics operations. Any property of the OptimizerStatisticsCollectionOperationSummary can be used to define the filter condition. The allowed conditional operators are AND or OR, and the allowed binary operators are are >, < and =. Any other operator is regarded invalid. Example: jobName=<replace with job name> AND status=<replace with status>
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str start_time_greater_than_or_equal_to: The start time of the time range to retrieve the optimizer statistics of a Managed Database in UTC in ISO-8601 format, which is "yyyy-MM-dd'T'hh:mm:ss.sss'Z'".
    :param str task_type: The filter types of the optimizer statistics tasks.
    """
    ...
