# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReportDefinitionsResult',
    'AwaitableGetReportDefinitionsResult',
    'get_report_definitions',
    'get_report_definitions_output',
]

@pulumi.output_type
class GetReportDefinitionsResult:
    """
    A collection of values returned by getReportDefinitions.
    """
    def __init__(__self__, access_level=None, category=None, compartment_id=None, compartment_id_in_subtree=None, data_source=None, display_name=None, filters=None, id=None, is_seeded=None, report_definition_collections=None, state=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if data_source and not isinstance(data_source, str):
            raise TypeError("Expected argument 'data_source' to be a str")
        pulumi.set(__self__, "data_source", data_source)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_seeded and not isinstance(is_seeded, bool):
            raise TypeError("Expected argument 'is_seeded' to be a bool")
        pulumi.set(__self__, "is_seeded", is_seeded)
        if report_definition_collections and not isinstance(report_definition_collections, list):
            raise TypeError("Expected argument 'report_definition_collections' to be a list")
        pulumi.set(__self__, "report_definition_collections", report_definition_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Specifies the name of the category that this report belongs to.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the report definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[str]:
        """
        Specifies the name of a resource that provides data for the report. For example alerts, events.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Name of the report definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReportDefinitionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> Optional[bool]:
        """
        Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        """
        return pulumi.get(self, "is_seeded")

    @property
    @pulumi.getter(name="reportDefinitionCollections")
    def report_definition_collections(self) -> Sequence['outputs.GetReportDefinitionsReportDefinitionCollectionResult']:
        """
        The list of report_definition_collection.
        """
        return pulumi.get(self, "report_definition_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the report.
        """
        return pulumi.get(self, "state")


class AwaitableGetReportDefinitionsResult(GetReportDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReportDefinitionsResult(
            access_level=self.access_level,
            category=self.category,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            data_source=self.data_source,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_seeded=self.is_seeded,
            report_definition_collections=self.report_definition_collections,
            state=self.state)


def get_report_definitions(access_level: Optional[str] = None,
                           category: Optional[str] = None,
                           compartment_id: Optional[str] = None,
                           compartment_id_in_subtree: Optional[bool] = None,
                           data_source: Optional[str] = None,
                           display_name: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetReportDefinitionsFilterArgs', 'GetReportDefinitionsFilterArgsDict']]] = None,
                           is_seeded: Optional[bool] = None,
                           state: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReportDefinitionsResult:
    """
    This data source provides the list of Report Definitions in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of report definitions.
    The ListReportDefinitions operation returns only the report definitions in the specified `compartmentId`.
    It also returns the seeded report definitions which are available to all the compartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_report_definitions = oci.DataSafe.get_report_definitions(compartment_id=compartment_id,
        access_level=report_definition_access_level,
        category=report_definition_category,
        compartment_id_in_subtree=report_definition_compartment_id_in_subtree,
        data_source=report_definition_data_source,
        display_name=report_definition_display_name,
        is_seeded=report_definition_is_seeded,
        state=report_definition_state)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str category: An optional filter to return only resources that match the specified category.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str data_source: Specifies the name of a resource that provides data for the report. For example  alerts, events.
    :param str display_name: The name of the report definition to query.
    :param bool is_seeded: A boolean flag indicating to list seeded report definitions. Set this parameter to get list of seeded report definitions.
    :param str state: An optional filter to return only resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['category'] = category
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['dataSource'] = data_source
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isSeeded'] = is_seeded
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getReportDefinitions:getReportDefinitions', __args__, opts=opts, typ=GetReportDefinitionsResult).value

    return AwaitableGetReportDefinitionsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        category=pulumi.get(__ret__, 'category'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        data_source=pulumi.get(__ret__, 'data_source'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_seeded=pulumi.get(__ret__, 'is_seeded'),
        report_definition_collections=pulumi.get(__ret__, 'report_definition_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_report_definitions)
def get_report_definitions_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                  category: Optional[pulumi.Input[Optional[str]]] = None,
                                  compartment_id: Optional[pulumi.Input[str]] = None,
                                  compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                  data_source: Optional[pulumi.Input[Optional[str]]] = None,
                                  display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetReportDefinitionsFilterArgs', 'GetReportDefinitionsFilterArgsDict']]]]] = None,
                                  is_seeded: Optional[pulumi.Input[Optional[bool]]] = None,
                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReportDefinitionsResult]:
    """
    This data source provides the list of Report Definitions in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of report definitions.
    The ListReportDefinitions operation returns only the report definitions in the specified `compartmentId`.
    It also returns the seeded report definitions which are available to all the compartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_report_definitions = oci.DataSafe.get_report_definitions(compartment_id=compartment_id,
        access_level=report_definition_access_level,
        category=report_definition_category,
        compartment_id_in_subtree=report_definition_compartment_id_in_subtree,
        data_source=report_definition_data_source,
        display_name=report_definition_display_name,
        is_seeded=report_definition_is_seeded,
        state=report_definition_state)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str category: An optional filter to return only resources that match the specified category.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str data_source: Specifies the name of a resource that provides data for the report. For example  alerts, events.
    :param str display_name: The name of the report definition to query.
    :param bool is_seeded: A boolean flag indicating to list seeded report definitions. Set this parameter to get list of seeded report definitions.
    :param str state: An optional filter to return only resources that match the specified lifecycle state.
    """
    ...
