# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceProviderActionsResult',
    'AwaitableGetServiceProviderActionsResult',
    'get_service_provider_actions',
    'get_service_provider_actions_output',
]

@pulumi.output_type
class GetServiceProviderActionsResult:
    """
    A collection of values returned by getServiceProviderActions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, resource_type=None, service_provider_action_summary_collections=None, service_provider_service_types=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if service_provider_action_summary_collections and not isinstance(service_provider_action_summary_collections, list):
            raise TypeError("Expected argument 'service_provider_action_summary_collections' to be a list")
        pulumi.set(__self__, "service_provider_action_summary_collections", service_provider_action_summary_collections)
        if service_provider_service_types and not isinstance(service_provider_service_types, list):
            raise TypeError("Expected argument 'service_provider_service_types' to be a list")
        pulumi.set(__self__, "service_provider_service_types", service_provider_service_types)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceProviderActionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        resourceType for which the ServiceProviderAction is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceProviderActionSummaryCollections")
    def service_provider_action_summary_collections(self) -> Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionResult']:
        """
        The list of service_provider_action_summary_collection.
        """
        return pulumi.get(self, "service_provider_action_summary_collections")

    @property
    @pulumi.getter(name="serviceProviderServiceTypes")
    def service_provider_service_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "service_provider_service_types")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Service Provider Action.
        """
        return pulumi.get(self, "state")


class AwaitableGetServiceProviderActionsResult(GetServiceProviderActionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceProviderActionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            resource_type=self.resource_type,
            service_provider_action_summary_collections=self.service_provider_action_summary_collections,
            service_provider_service_types=self.service_provider_service_types,
            state=self.state)


def get_service_provider_actions(compartment_id: Optional[str] = None,
                                 filters: Optional[Sequence[Union['GetServiceProviderActionsFilterArgs', 'GetServiceProviderActionsFilterArgsDict']]] = None,
                                 name: Optional[str] = None,
                                 resource_type: Optional[str] = None,
                                 service_provider_service_types: Optional[Sequence[str]] = None,
                                 state: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceProviderActionsResult:
    """
    This data source provides the list of Service Provider Actions in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists all the ServiceProviderActions available in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider_actions = oci.DelegateAccessControl.get_service_provider_actions(compartment_id=compartment_id,
        name=service_provider_action_name,
        resource_type=service_provider_action_resource_type,
        service_provider_service_types=service_provider_action_service_provider_service_type,
        state=service_provider_action_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str name: A filter to return only resources that match the entire name given.
    :param str resource_type: A filter to return only resources that match the given resource type.
    :param Sequence[str] service_provider_service_types: A filter to return only resources that match the given Service Provider service type.
    :param str state: A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['resourceType'] = resource_type
    __args__['serviceProviderServiceTypes'] = service_provider_service_types
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getServiceProviderActions:getServiceProviderActions', __args__, opts=opts, typ=GetServiceProviderActionsResult).value

    return AwaitableGetServiceProviderActionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        service_provider_action_summary_collections=pulumi.get(__ret__, 'service_provider_action_summary_collections'),
        service_provider_service_types=pulumi.get(__ret__, 'service_provider_service_types'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_service_provider_actions)
def get_service_provider_actions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServiceProviderActionsFilterArgs', 'GetServiceProviderActionsFilterArgsDict']]]]] = None,
                                        name: Optional[pulumi.Input[Optional[str]]] = None,
                                        resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                                        service_provider_service_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                        state: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceProviderActionsResult]:
    """
    This data source provides the list of Service Provider Actions in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists all the ServiceProviderActions available in the system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_provider_actions = oci.DelegateAccessControl.get_service_provider_actions(compartment_id=compartment_id,
        name=service_provider_action_name,
        resource_type=service_provider_action_resource_type,
        service_provider_service_types=service_provider_action_service_provider_service_type,
        state=service_provider_action_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str name: A filter to return only resources that match the entire name given.
    :param str resource_type: A filter to return only resources that match the given resource type.
    :param Sequence[str] service_provider_service_types: A filter to return only resources that match the given Service Provider service type.
    :param str state: A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
    """
    ...
