# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRepositoryRefResult',
    'AwaitableGetRepositoryRefResult',
    'get_repository_ref',
    'get_repository_ref_output',
]

@pulumi.output_type
class GetRepositoryRefResult:
    """
    A collection of values returned by getRepositoryRef.
    """
    def __init__(__self__, commit_id=None, defined_tags=None, freeform_tags=None, full_ref_name=None, id=None, object_id=None, ref_name=None, ref_type=None, repository_id=None):
        if commit_id and not isinstance(commit_id, str):
            raise TypeError("Expected argument 'commit_id' to be a str")
        pulumi.set(__self__, "commit_id", commit_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if full_ref_name and not isinstance(full_ref_name, str):
            raise TypeError("Expected argument 'full_ref_name' to be a str")
        pulumi.set(__self__, "full_ref_name", full_ref_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if ref_type and not isinstance(ref_type, str):
            raise TypeError("Expected argument 'ref_type' to be a str")
        pulumi.set(__self__, "ref_type", ref_type)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> str:
        """
        Commit ID pointed to by the new branch.
        """
        return pulumi.get(self, "commit_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="fullRefName")
    def full_ref_name(self) -> str:
        """
        Unique full reference name inside a repository.
        """
        return pulumi.get(self, "full_ref_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        SHA-1 hash value of the object pointed to by the tag.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> str:
        """
        Unique reference name inside a repository.
        """
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="refType")
    def ref_type(self) -> str:
        """
        The type of reference (BRANCH or TAG).
        """
        return pulumi.get(self, "ref_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        The OCID of the repository containing the reference.
        """
        return pulumi.get(self, "repository_id")


class AwaitableGetRepositoryRefResult(GetRepositoryRefResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryRefResult(
            commit_id=self.commit_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            full_ref_name=self.full_ref_name,
            id=self.id,
            object_id=self.object_id,
            ref_name=self.ref_name,
            ref_type=self.ref_type,
            repository_id=self.repository_id)


def get_repository_ref(ref_name: Optional[str] = None,
                       repository_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryRefResult:
    """
    This data source provides details about a specific Repository Ref resource in Oracle Cloud Infrastructure Devops service.

    This API will be deprecated on Wed, 12 June 2024 01:00:00 GMT as it does not get recognized when refName has '/'. This will be replaced by "/repositories/{repositoryId}/refs". Retrieves a repository's reference by its name with preference for branches over tags if the name is ambiguous. This can be disambiguated by using full names like "heads/<name>" or "tags/<name>".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_ref = oci.DevOps.get_repository_ref(ref_name=repository_ref_ref_name,
        repository_id=test_repository["id"])
    ```


    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryRef:getRepositoryRef', __args__, opts=opts, typ=GetRepositoryRefResult).value

    return AwaitableGetRepositoryRefResult(
        commit_id=pulumi.get(__ret__, 'commit_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        full_ref_name=pulumi.get(__ret__, 'full_ref_name'),
        id=pulumi.get(__ret__, 'id'),
        object_id=pulumi.get(__ret__, 'object_id'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        ref_type=pulumi.get(__ret__, 'ref_type'),
        repository_id=pulumi.get(__ret__, 'repository_id'))


@_utilities.lift_output_func(get_repository_ref)
def get_repository_ref_output(ref_name: Optional[pulumi.Input[str]] = None,
                              repository_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryRefResult]:
    """
    This data source provides details about a specific Repository Ref resource in Oracle Cloud Infrastructure Devops service.

    This API will be deprecated on Wed, 12 June 2024 01:00:00 GMT as it does not get recognized when refName has '/'. This will be replaced by "/repositories/{repositoryId}/refs". Retrieves a repository's reference by its name with preference for branches over tags if the name is ambiguous. This can be disambiguated by using full names like "heads/<name>" or "tags/<name>".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_ref = oci.DevOps.get_repository_ref(ref_name=repository_ref_ref_name,
        repository_id=test_repository["id"])
    ```


    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    ...
