# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['FusionEnvironmentDataMaskingActivityArgs', 'FusionEnvironmentDataMaskingActivity']

@pulumi.input_type
class FusionEnvironmentDataMaskingActivityArgs:
    def __init__(__self__, *,
                 fusion_environment_id: pulumi.Input[str],
                 is_resume_data_masking: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a FusionEnvironmentDataMaskingActivity resource.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[bool] is_resume_data_masking: This allows the Data Safe service to resume the previously failed data masking activity.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if is_resume_data_masking is not None:
            pulumi.set(__self__, "is_resume_data_masking", is_resume_data_masking)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Input[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter(name="isResumeDataMasking")
    def is_resume_data_masking(self) -> Optional[pulumi.Input[bool]]:
        """
        This allows the Data Safe service to resume the previously failed data masking activity.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_resume_data_masking")

    @is_resume_data_masking.setter
    def is_resume_data_masking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_resume_data_masking", value)


@pulumi.input_type
class _FusionEnvironmentDataMaskingActivityState:
    def __init__(__self__, *,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 is_resume_data_masking: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_masking_finish: Optional[pulumi.Input[str]] = None,
                 time_masking_start: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionEnvironmentDataMaskingActivity resources.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[bool] is_resume_data_masking: This allows the Data Safe service to resume the previously failed data masking activity.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DataMaskingActivity.
        :param pulumi.Input[str] time_masking_finish: The time the data masking activity ended. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_masking_start: The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        if fusion_environment_id is not None:
            pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if is_resume_data_masking is not None:
            pulumi.set(__self__, "is_resume_data_masking", is_resume_data_masking)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_masking_finish is not None:
            pulumi.set(__self__, "time_masking_finish", time_masking_finish)
        if time_masking_start is not None:
            pulumi.set(__self__, "time_masking_start", time_masking_start)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter(name="isResumeDataMasking")
    def is_resume_data_masking(self) -> Optional[pulumi.Input[bool]]:
        """
        This allows the Data Safe service to resume the previously failed data masking activity.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_resume_data_masking")

    @is_resume_data_masking.setter
    def is_resume_data_masking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_resume_data_masking", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DataMaskingActivity.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeMaskingFinish")
    def time_masking_finish(self) -> Optional[pulumi.Input[str]]:
        """
        The time the data masking activity ended. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_finish")

    @time_masking_finish.setter
    def time_masking_finish(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_masking_finish", value)

    @property
    @pulumi.getter(name="timeMaskingStart")
    def time_masking_start(self) -> Optional[pulumi.Input[str]]:
        """
        The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_start")

    @time_masking_start.setter
    def time_masking_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_masking_start", value)


class FusionEnvironmentDataMaskingActivity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 is_resume_data_masking: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Fusion Environment Data Masking Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new DataMaskingActivity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_data_masking_activity = oci.fusion_apps.FusionEnvironmentDataMaskingActivity("test_fusion_environment_data_masking_activity",
            fusion_environment_id=test_fusion_environment["id"],
            is_resume_data_masking=fusion_environment_data_masking_activity_is_resume_data_masking)
        ```

        ## Import

        FusionEnvironmentDataMaskingActivities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentDataMaskingActivity:FusionEnvironmentDataMaskingActivity test_fusion_environment_data_masking_activity "fusionEnvironments/{fusionEnvironmentId}/dataMaskingActivities/{dataMaskingActivityId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[bool] is_resume_data_masking: This allows the Data Safe service to resume the previously failed data masking activity.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionEnvironmentDataMaskingActivityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fusion Environment Data Masking Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new DataMaskingActivity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_data_masking_activity = oci.fusion_apps.FusionEnvironmentDataMaskingActivity("test_fusion_environment_data_masking_activity",
            fusion_environment_id=test_fusion_environment["id"],
            is_resume_data_masking=fusion_environment_data_masking_activity_is_resume_data_masking)
        ```

        ## Import

        FusionEnvironmentDataMaskingActivities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentDataMaskingActivity:FusionEnvironmentDataMaskingActivity test_fusion_environment_data_masking_activity "fusionEnvironments/{fusionEnvironmentId}/dataMaskingActivities/{dataMaskingActivityId}"
        ```

        :param str resource_name: The name of the resource.
        :param FusionEnvironmentDataMaskingActivityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionEnvironmentDataMaskingActivityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 is_resume_data_masking: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionEnvironmentDataMaskingActivityArgs.__new__(FusionEnvironmentDataMaskingActivityArgs)

            if fusion_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'fusion_environment_id'")
            __props__.__dict__["fusion_environment_id"] = fusion_environment_id
            __props__.__dict__["is_resume_data_masking"] = is_resume_data_masking
            __props__.__dict__["state"] = None
            __props__.__dict__["time_masking_finish"] = None
            __props__.__dict__["time_masking_start"] = None
        super(FusionEnvironmentDataMaskingActivity, __self__).__init__(
            'oci:FusionApps/fusionEnvironmentDataMaskingActivity:FusionEnvironmentDataMaskingActivity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fusion_environment_id: Optional[pulumi.Input[str]] = None,
            is_resume_data_masking: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_masking_finish: Optional[pulumi.Input[str]] = None,
            time_masking_start: Optional[pulumi.Input[str]] = None) -> 'FusionEnvironmentDataMaskingActivity':
        """
        Get an existing FusionEnvironmentDataMaskingActivity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[bool] is_resume_data_masking: This allows the Data Safe service to resume the previously failed data masking activity.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the DataMaskingActivity.
        :param pulumi.Input[str] time_masking_finish: The time the data masking activity ended. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_masking_start: The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionEnvironmentDataMaskingActivityState.__new__(_FusionEnvironmentDataMaskingActivityState)

        __props__.__dict__["fusion_environment_id"] = fusion_environment_id
        __props__.__dict__["is_resume_data_masking"] = is_resume_data_masking
        __props__.__dict__["state"] = state
        __props__.__dict__["time_masking_finish"] = time_masking_finish
        __props__.__dict__["time_masking_start"] = time_masking_start
        return FusionEnvironmentDataMaskingActivity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Output[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter(name="isResumeDataMasking")
    def is_resume_data_masking(self) -> pulumi.Output[bool]:
        """
        This allows the Data Safe service to resume the previously failed data masking activity.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "is_resume_data_masking")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DataMaskingActivity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeMaskingFinish")
    def time_masking_finish(self) -> pulumi.Output[str]:
        """
        The time the data masking activity ended. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_finish")

    @property
    @pulumi.getter(name="timeMaskingStart")
    def time_masking_start(self) -> pulumi.Output[str]:
        """
        The time the data masking activity started. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_masking_start")

