# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogAnalyticsObjectCollectionRuleArgs', 'LogAnalyticsObjectCollectionRule']

@pulumi.input_type
class LogAnalyticsObjectCollectionRuleArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 log_group_id: pulumi.Input[str],
                 log_source_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 os_bucket_name: pulumi.Input[str],
                 os_namespace: pulumi.Input[str],
                 char_encoding: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_historic_collection: Optional[pulumi.Input[bool]] = None,
                 log_set: Optional[pulumi.Input[str]] = None,
                 log_set_ext_regex: Optional[pulumi.Input[str]] = None,
                 log_set_key: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]] = None,
                 poll_since: Optional[pulumi.Input[str]] = None,
                 poll_till: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogAnalyticsObjectCollectionRule resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        :param pulumi.Input[str] log_group_id: (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        :param pulumi.Input[str] log_source_name: (Updatable) Name of the Logging Analytics Source to use for the processing.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[str] os_bucket_name: Name of the Object Storage bucket.
        :param pulumi.Input[str] os_namespace: Object Storage namespace.
        :param pulumi.Input[str] char_encoding: (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        :param pulumi.Input[str] collection_type: The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        :param pulumi.Input[str] entity_id: (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this rule is currently enabled.
        :param pulumi.Input[bool] is_force_historic_collection: Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        :param pulumi.Input[str] log_set: (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        :param pulumi.Input[str] log_set_ext_regex: (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        :param pulumi.Input[str] log_set_key: (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        :param pulumi.Input[str] log_type: Type of files/objects in this object collection rule.
        :param pulumi.Input[str] name: A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_name_filters: (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]] overrides: (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        :param pulumi.Input[str] poll_since: The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        :param pulumi.Input[str] poll_till: The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        :param pulumi.Input[str] timezone: (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_source_name", log_source_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "os_bucket_name", os_bucket_name)
        pulumi.set(__self__, "os_namespace", os_namespace)
        if char_encoding is not None:
            pulumi.set(__self__, "char_encoding", char_encoding)
        if collection_type is not None:
            pulumi.set(__self__, "collection_type", collection_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_force_historic_collection is not None:
            pulumi.set(__self__, "is_force_historic_collection", is_force_historic_collection)
        if log_set is not None:
            pulumi.set(__self__, "log_set", log_set)
        if log_set_ext_regex is not None:
            pulumi.set(__self__, "log_set_ext_regex", log_set_ext_regex)
        if log_set_key is not None:
            pulumi.set(__self__, "log_set_key", log_set_key)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_name_filters is not None:
            pulumi.set(__self__, "object_name_filters", object_name_filters)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if poll_since is not None:
            pulumi.set(__self__, "poll_since", poll_since)
        if poll_till is not None:
            pulumi.set(__self__, "poll_till", poll_till)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logSourceName")
    def log_source_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the Logging Analytics Source to use for the processing.
        """
        return pulumi.get(self, "log_source_name")

    @log_source_name.setter
    def log_source_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_source_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="osBucketName")
    def os_bucket_name(self) -> pulumi.Input[str]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "os_bucket_name")

    @os_bucket_name.setter
    def os_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_bucket_name", value)

    @property
    @pulumi.getter(name="osNamespace")
    def os_namespace(self) -> pulumi.Input[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "os_namespace")

    @os_namespace.setter
    def os_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_namespace", value)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        """
        return pulumi.get(self, "char_encoding")

    @char_encoding.setter
    def char_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "char_encoding", value)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        """
        return pulumi.get(self, "collection_type")

    @collection_type.setter
    def collection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isForceHistoricCollection")
    def is_force_historic_collection(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        """
        return pulumi.get(self, "is_force_historic_collection")

    @is_force_historic_collection.setter
    def is_force_historic_collection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_historic_collection", value)

    @property
    @pulumi.getter(name="logSet")
    def log_set(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        """
        return pulumi.get(self, "log_set")

    @log_set.setter
    def log_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set", value)

    @property
    @pulumi.getter(name="logSetExtRegex")
    def log_set_ext_regex(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        """
        return pulumi.get(self, "log_set_ext_regex")

    @log_set_ext_regex.setter
    def log_set_ext_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set_ext_regex", value)

    @property
    @pulumi.getter(name="logSetKey")
    def log_set_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        """
        return pulumi.get(self, "log_set_key")

    @log_set_key.setter
    def log_set_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set_key", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of files/objects in this object collection rule.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        """
        return pulumi.get(self, "object_name_filters")

    @object_name_filters.setter
    def object_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_name_filters", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]]:
        """
        (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="pollSince")
    def poll_since(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        """
        return pulumi.get(self, "poll_since")

    @poll_since.setter
    def poll_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_since", value)

    @property
    @pulumi.getter(name="pollTill")
    def poll_till(self) -> Optional[pulumi.Input[str]]:
        """
        The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        """
        return pulumi.get(self, "poll_till")

    @poll_till.setter
    def poll_till(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_till", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _LogAnalyticsObjectCollectionRuleState:
    def __init__(__self__, *,
                 char_encoding: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_historic_collection: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_set: Optional[pulumi.Input[str]] = None,
                 log_set_ext_regex: Optional[pulumi.Input[str]] = None,
                 log_set_key: Optional[pulumi.Input[str]] = None,
                 log_source_name: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_bucket_name: Optional[pulumi.Input[str]] = None,
                 os_namespace: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]] = None,
                 poll_since: Optional[pulumi.Input[str]] = None,
                 poll_till: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogAnalyticsObjectCollectionRule resources.
        :param pulumi.Input[str] char_encoding: (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        :param pulumi.Input[str] collection_type: The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        :param pulumi.Input[str] entity_id: (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this rule is currently enabled.
        :param pulumi.Input[bool] is_force_historic_collection: Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        :param pulumi.Input[str] lifecycle_details: A detailed status of the life cycle state.
        :param pulumi.Input[str] log_group_id: (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        :param pulumi.Input[str] log_set: (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        :param pulumi.Input[str] log_set_ext_regex: (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        :param pulumi.Input[str] log_set_key: (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        :param pulumi.Input[str] log_source_name: (Updatable) Name of the Logging Analytics Source to use for the processing.
        :param pulumi.Input[str] log_type: Type of files/objects in this object collection rule.
        :param pulumi.Input[str] name: A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_name_filters: (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        :param pulumi.Input[str] os_bucket_name: Name of the Object Storage bucket.
        :param pulumi.Input[str] os_namespace: Object Storage namespace.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]] overrides: (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        :param pulumi.Input[str] poll_since: The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        :param pulumi.Input[str] poll_till: The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        :param pulumi.Input[str] state: The current state of the rule.
        :param pulumi.Input[str] time_created: The time when this rule was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when this rule was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] timezone: (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if char_encoding is not None:
            pulumi.set(__self__, "char_encoding", char_encoding)
        if collection_type is not None:
            pulumi.set(__self__, "collection_type", collection_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if is_force_historic_collection is not None:
            pulumi.set(__self__, "is_force_historic_collection", is_force_historic_collection)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if log_set is not None:
            pulumi.set(__self__, "log_set", log_set)
        if log_set_ext_regex is not None:
            pulumi.set(__self__, "log_set_ext_regex", log_set_ext_regex)
        if log_set_key is not None:
            pulumi.set(__self__, "log_set_key", log_set_key)
        if log_source_name is not None:
            pulumi.set(__self__, "log_source_name", log_source_name)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object_name_filters is not None:
            pulumi.set(__self__, "object_name_filters", object_name_filters)
        if os_bucket_name is not None:
            pulumi.set(__self__, "os_bucket_name", os_bucket_name)
        if os_namespace is not None:
            pulumi.set(__self__, "os_namespace", os_namespace)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if poll_since is not None:
            pulumi.set(__self__, "poll_since", poll_since)
        if poll_till is not None:
            pulumi.set(__self__, "poll_till", poll_till)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        """
        return pulumi.get(self, "char_encoding")

    @char_encoding.setter
    def char_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "char_encoding", value)

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        """
        return pulumi.get(self, "collection_type")

    @collection_type.setter
    def collection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isForceHistoricCollection")
    def is_force_historic_collection(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        """
        return pulumi.get(self, "is_force_historic_collection")

    @is_force_historic_collection.setter
    def is_force_historic_collection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_force_historic_collection", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A detailed status of the life cycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logSet")
    def log_set(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        """
        return pulumi.get(self, "log_set")

    @log_set.setter
    def log_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set", value)

    @property
    @pulumi.getter(name="logSetExtRegex")
    def log_set_ext_regex(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        """
        return pulumi.get(self, "log_set_ext_regex")

    @log_set_ext_regex.setter
    def log_set_ext_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set_ext_regex", value)

    @property
    @pulumi.getter(name="logSetKey")
    def log_set_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        """
        return pulumi.get(self, "log_set_key")

    @log_set_key.setter
    def log_set_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_set_key", value)

    @property
    @pulumi.getter(name="logSourceName")
    def log_source_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the Logging Analytics Source to use for the processing.
        """
        return pulumi.get(self, "log_source_name")

    @log_source_name.setter
    def log_source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_source_name", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of files/objects in this object collection rule.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        """
        return pulumi.get(self, "object_name_filters")

    @object_name_filters.setter
    def object_name_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_name_filters", value)

    @property
    @pulumi.getter(name="osBucketName")
    def os_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "os_bucket_name")

    @os_bucket_name.setter
    def os_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_bucket_name", value)

    @property
    @pulumi.getter(name="osNamespace")
    def os_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "os_namespace")

    @os_namespace.setter
    def os_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_namespace", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]]:
        """
        (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsObjectCollectionRuleOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="pollSince")
    def poll_since(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        """
        return pulumi.get(self, "poll_since")

    @poll_since.setter
    def poll_since(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_since", value)

    @property
    @pulumi.getter(name="pollTill")
    def poll_till(self) -> Optional[pulumi.Input[str]]:
        """
        The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        """
        return pulumi.get(self, "poll_till")

    @poll_till.setter
    def poll_till(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "poll_till", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this rule was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this rule was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


class LogAnalyticsObjectCollectionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 char_encoding: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_historic_collection: Optional[pulumi.Input[bool]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_set: Optional[pulumi.Input[str]] = None,
                 log_set_ext_regex: Optional[pulumi.Input[str]] = None,
                 log_set_key: Optional[pulumi.Input[str]] = None,
                 log_source_name: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_bucket_name: Optional[pulumi.Input[str]] = None,
                 os_namespace: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsObjectCollectionRuleOverrideArgs', 'LogAnalyticsObjectCollectionRuleOverrideArgsDict']]]]] = None,
                 poll_since: Optional[pulumi.Input[str]] = None,
                 poll_till: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Log Analytics Object Collection Rule resource in Oracle Cloud Infrastructure Log Analytics service.

        Create a configuration to collect logs from object storage bucket.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_object_collection_rule = oci.log_analytics.LogAnalyticsObjectCollectionRule("test_log_analytics_object_collection_rule",
            compartment_id=compartment_id,
            log_group_id=test_log_group["id"],
            log_source_name=log_analytics_object_collection_rule_log_source_name,
            name=log_analytics_object_collection_rule_name,
            namespace=log_analytics_object_collection_rule_namespace,
            os_bucket_name=test_bucket["name"],
            os_namespace=log_analytics_object_collection_rule_os_namespace,
            char_encoding=log_analytics_object_collection_rule_char_encoding,
            collection_type=log_analytics_object_collection_rule_collection_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=log_analytics_object_collection_rule_description,
            entity_id=test_entity["id"],
            freeform_tags={
                "bar-key": "value",
            },
            is_enabled=log_analytics_object_collection_rule_is_enabled,
            is_force_historic_collection=log_analytics_object_collection_rule_is_force_historic_collection,
            log_set=log_analytics_object_collection_rule_log_set,
            log_set_ext_regex=log_analytics_object_collection_rule_log_set_ext_regex,
            log_set_key=log_analytics_object_collection_rule_log_set_key,
            log_type=log_analytics_object_collection_rule_log_type,
            object_name_filters=log_analytics_object_collection_rule_object_name_filters,
            overrides=log_analytics_object_collection_rule_overrides,
            poll_since=log_analytics_object_collection_rule_poll_since,
            poll_till=log_analytics_object_collection_rule_poll_till,
            timezone=log_analytics_object_collection_rule_timezone)
        ```

        ## Import

        LogAnalyticsObjectCollectionRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/logAnalyticsObjectCollectionRule:LogAnalyticsObjectCollectionRule test_log_analytics_object_collection_rule "namespaces/{namespaceName}/logAnalyticsObjectCollectionRules/{logAnalyticsObjectCollectionRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] char_encoding: (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        :param pulumi.Input[str] collection_type: The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        :param pulumi.Input[str] entity_id: (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this rule is currently enabled.
        :param pulumi.Input[bool] is_force_historic_collection: Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        :param pulumi.Input[str] log_group_id: (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        :param pulumi.Input[str] log_set: (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        :param pulumi.Input[str] log_set_ext_regex: (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        :param pulumi.Input[str] log_set_key: (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        :param pulumi.Input[str] log_source_name: (Updatable) Name of the Logging Analytics Source to use for the processing.
        :param pulumi.Input[str] log_type: Type of files/objects in this object collection rule.
        :param pulumi.Input[str] name: A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_name_filters: (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        :param pulumi.Input[str] os_bucket_name: Name of the Object Storage bucket.
        :param pulumi.Input[str] os_namespace: Object Storage namespace.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsObjectCollectionRuleOverrideArgs', 'LogAnalyticsObjectCollectionRuleOverrideArgsDict']]]] overrides: (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        :param pulumi.Input[str] poll_since: The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        :param pulumi.Input[str] poll_till: The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        :param pulumi.Input[str] timezone: (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnalyticsObjectCollectionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Log Analytics Object Collection Rule resource in Oracle Cloud Infrastructure Log Analytics service.

        Create a configuration to collect logs from object storage bucket.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_log_analytics_object_collection_rule = oci.log_analytics.LogAnalyticsObjectCollectionRule("test_log_analytics_object_collection_rule",
            compartment_id=compartment_id,
            log_group_id=test_log_group["id"],
            log_source_name=log_analytics_object_collection_rule_log_source_name,
            name=log_analytics_object_collection_rule_name,
            namespace=log_analytics_object_collection_rule_namespace,
            os_bucket_name=test_bucket["name"],
            os_namespace=log_analytics_object_collection_rule_os_namespace,
            char_encoding=log_analytics_object_collection_rule_char_encoding,
            collection_type=log_analytics_object_collection_rule_collection_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=log_analytics_object_collection_rule_description,
            entity_id=test_entity["id"],
            freeform_tags={
                "bar-key": "value",
            },
            is_enabled=log_analytics_object_collection_rule_is_enabled,
            is_force_historic_collection=log_analytics_object_collection_rule_is_force_historic_collection,
            log_set=log_analytics_object_collection_rule_log_set,
            log_set_ext_regex=log_analytics_object_collection_rule_log_set_ext_regex,
            log_set_key=log_analytics_object_collection_rule_log_set_key,
            log_type=log_analytics_object_collection_rule_log_type,
            object_name_filters=log_analytics_object_collection_rule_object_name_filters,
            overrides=log_analytics_object_collection_rule_overrides,
            poll_since=log_analytics_object_collection_rule_poll_since,
            poll_till=log_analytics_object_collection_rule_poll_till,
            timezone=log_analytics_object_collection_rule_timezone)
        ```

        ## Import

        LogAnalyticsObjectCollectionRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/logAnalyticsObjectCollectionRule:LogAnalyticsObjectCollectionRule test_log_analytics_object_collection_rule "namespaces/{namespaceName}/logAnalyticsObjectCollectionRules/{logAnalyticsObjectCollectionRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param LogAnalyticsObjectCollectionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnalyticsObjectCollectionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 char_encoding: Optional[pulumi.Input[str]] = None,
                 collection_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 is_force_historic_collection: Optional[pulumi.Input[bool]] = None,
                 log_group_id: Optional[pulumi.Input[str]] = None,
                 log_set: Optional[pulumi.Input[str]] = None,
                 log_set_ext_regex: Optional[pulumi.Input[str]] = None,
                 log_set_key: Optional[pulumi.Input[str]] = None,
                 log_source_name: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os_bucket_name: Optional[pulumi.Input[str]] = None,
                 os_namespace: Optional[pulumi.Input[str]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsObjectCollectionRuleOverrideArgs', 'LogAnalyticsObjectCollectionRuleOverrideArgsDict']]]]] = None,
                 poll_since: Optional[pulumi.Input[str]] = None,
                 poll_till: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnalyticsObjectCollectionRuleArgs.__new__(LogAnalyticsObjectCollectionRuleArgs)

            __props__.__dict__["char_encoding"] = char_encoding
            __props__.__dict__["collection_type"] = collection_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["entity_id"] = entity_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["is_force_historic_collection"] = is_force_historic_collection
            if log_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_id'")
            __props__.__dict__["log_group_id"] = log_group_id
            __props__.__dict__["log_set"] = log_set
            __props__.__dict__["log_set_ext_regex"] = log_set_ext_regex
            __props__.__dict__["log_set_key"] = log_set_key
            if log_source_name is None and not opts.urn:
                raise TypeError("Missing required property 'log_source_name'")
            __props__.__dict__["log_source_name"] = log_source_name
            __props__.__dict__["log_type"] = log_type
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["object_name_filters"] = object_name_filters
            if os_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'os_bucket_name'")
            __props__.__dict__["os_bucket_name"] = os_bucket_name
            if os_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'os_namespace'")
            __props__.__dict__["os_namespace"] = os_namespace
            __props__.__dict__["overrides"] = overrides
            __props__.__dict__["poll_since"] = poll_since
            __props__.__dict__["poll_till"] = poll_till
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LogAnalyticsObjectCollectionRule, __self__).__init__(
            'oci:LogAnalytics/logAnalyticsObjectCollectionRule:LogAnalyticsObjectCollectionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            char_encoding: Optional[pulumi.Input[str]] = None,
            collection_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entity_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            is_force_historic_collection: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            log_group_id: Optional[pulumi.Input[str]] = None,
            log_set: Optional[pulumi.Input[str]] = None,
            log_set_ext_regex: Optional[pulumi.Input[str]] = None,
            log_set_key: Optional[pulumi.Input[str]] = None,
            log_source_name: Optional[pulumi.Input[str]] = None,
            log_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            object_name_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os_bucket_name: Optional[pulumi.Input[str]] = None,
            os_namespace: Optional[pulumi.Input[str]] = None,
            overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsObjectCollectionRuleOverrideArgs', 'LogAnalyticsObjectCollectionRuleOverrideArgsDict']]]]] = None,
            poll_since: Optional[pulumi.Input[str]] = None,
            poll_till: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None) -> 'LogAnalyticsObjectCollectionRule':
        """
        Get an existing LogAnalyticsObjectCollectionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] char_encoding: (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        :param pulumi.Input[str] collection_type: The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        :param pulumi.Input[str] entity_id: (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: (Updatable) Whether or not this rule is currently enabled.
        :param pulumi.Input[bool] is_force_historic_collection: Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        :param pulumi.Input[str] lifecycle_details: A detailed status of the life cycle state.
        :param pulumi.Input[str] log_group_id: (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        :param pulumi.Input[str] log_set: (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        :param pulumi.Input[str] log_set_ext_regex: (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        :param pulumi.Input[str] log_set_key: (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        :param pulumi.Input[str] log_source_name: (Updatable) Name of the Logging Analytics Source to use for the processing.
        :param pulumi.Input[str] log_type: Type of files/objects in this object collection rule.
        :param pulumi.Input[str] name: A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_name_filters: (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        :param pulumi.Input[str] os_bucket_name: Name of the Object Storage bucket.
        :param pulumi.Input[str] os_namespace: Object Storage namespace.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogAnalyticsObjectCollectionRuleOverrideArgs', 'LogAnalyticsObjectCollectionRuleOverrideArgsDict']]]] overrides: (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        :param pulumi.Input[str] poll_since: The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        :param pulumi.Input[str] poll_till: The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        :param pulumi.Input[str] state: The current state of the rule.
        :param pulumi.Input[str] time_created: The time when this rule was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when this rule was last updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] timezone: (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnalyticsObjectCollectionRuleState.__new__(_LogAnalyticsObjectCollectionRuleState)

        __props__.__dict__["char_encoding"] = char_encoding
        __props__.__dict__["collection_type"] = collection_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["is_force_historic_collection"] = is_force_historic_collection
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["log_set"] = log_set
        __props__.__dict__["log_set_ext_regex"] = log_set_ext_regex
        __props__.__dict__["log_set_key"] = log_set_key
        __props__.__dict__["log_source_name"] = log_source_name
        __props__.__dict__["log_type"] = log_type
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["object_name_filters"] = object_name_filters
        __props__.__dict__["os_bucket_name"] = os_bucket_name
        __props__.__dict__["os_namespace"] = os_namespace
        __props__.__dict__["overrides"] = overrides
        __props__.__dict__["poll_since"] = poll_since
        __props__.__dict__["poll_till"] = poll_till
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["timezone"] = timezone
        return LogAnalyticsObjectCollectionRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> pulumi.Output[str]:
        """
        (Updatable) An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        """
        return pulumi.get(self, "char_encoding")

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> pulumi.Output[str]:
        """
        The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Logging Analytics entity OCID. Associates the processed logs with the given entity (optional).
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isForceHistoricCollection")
    def is_force_historic_collection(self) -> pulumi.Output[bool]:
        """
        Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        """
        return pulumi.get(self, "is_force_historic_collection")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A detailed status of the life cycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Logging Analytics Log group OCID to associate the processed logs with.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logSet")
    def log_set(self) -> pulumi.Output[str]:
        """
        (Updatable) The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        """
        return pulumi.get(self, "log_set")

    @property
    @pulumi.getter(name="logSetExtRegex")
    def log_set_ext_regex(self) -> pulumi.Output[str]:
        """
        (Updatable) The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        """
        return pulumi.get(self, "log_set_ext_regex")

    @property
    @pulumi.getter(name="logSetKey")
    def log_set_key(self) -> pulumi.Output[str]:
        """
        (Updatable) An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        """
        return pulumi.get(self, "log_set_key")

    @property
    @pulumi.getter(name="logSourceName")
    def log_source_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the Logging Analytics Source to use for the processing.
        """
        return pulumi.get(self, "log_source_name")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Output[str]:
        """
        Type of files/objects in this object collection rule.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name given to the rule. The name must be unique within the tenancy, and cannot be modified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Logging Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        """
        return pulumi.get(self, "object_name_filters")

    @property
    @pulumi.getter(name="osBucketName")
    def os_bucket_name(self) -> pulumi.Output[str]:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "os_bucket_name")

    @property
    @pulumi.getter(name="osNamespace")
    def os_namespace(self) -> pulumi.Output[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "os_namespace")

    @property
    @pulumi.getter
    def overrides(self) -> pulumi.Output[Sequence['outputs.LogAnalyticsObjectCollectionRuleOverride']]:
        """
        (Updatable) The override is used to modify some important configuration properties for objects matching a specific pattern inside the bucket. Supported propeties for override are: logSourceName, charEncoding, entityId. Supported matchType for override are "contains".
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="pollSince")
    def poll_since(self) -> pulumi.Output[str]:
        """
        The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC or HISTORIC_LIVE collection types. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        """
        return pulumi.get(self, "poll_since")

    @property
    @pulumi.getter(name="pollTill")
    def poll_till(self) -> pulumi.Output[str]:
        """
        The newest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. Use this for HISTORIC collection type. When collectionType is LIVE or HISTORIC_LIVE, specifying pollTill will result in error.
        """
        return pulumi.get(self, "poll_till")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when this rule was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when this rule was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        (Updatable) Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "timezone")

