# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubscriptionsResult',
    'AwaitableGetSubscriptionsResult',
    'get_subscriptions',
    'get_subscriptions_output',
]

@pulumi.output_type
class GetSubscriptionsResult:
    """
    A collection of values returned by getSubscriptions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, osp_home_region=None, subscription_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if subscription_collections and not isinstance(subscription_collections, list):
            raise TypeError("Expected argument 'subscription_collections' to be a list")
        pulumi.set(__self__, "subscription_collections", subscription_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="subscriptionCollections")
    def subscription_collections(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionResult']:
        """
        The list of subscription_collection.
        """
        return pulumi.get(self, "subscription_collections")


class AwaitableGetSubscriptionsResult(GetSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            osp_home_region=self.osp_home_region,
            subscription_collections=self.subscription_collections)


def get_subscriptions(compartment_id: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]] = None,
                      osp_home_region: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionsResult:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Osp Gateway service.

    Get the subscription data for the compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.OspGateway.get_subscriptions(compartment_id=compartment_id,
        osp_home_region=subscription_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getSubscriptions:getSubscriptions', __args__, opts=opts, typ=GetSubscriptionsResult).value

    return AwaitableGetSubscriptionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'),
        subscription_collections=pulumi.get(__ret__, 'subscription_collections'))


@_utilities.lift_output_func(get_subscriptions)
def get_subscriptions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSubscriptionsFilterArgs', 'GetSubscriptionsFilterArgsDict']]]]] = None,
                             osp_home_region: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionsResult]:
    """
    This data source provides the list of Subscriptions in Oracle Cloud Infrastructure Osp Gateway service.

    Get the subscription data for the compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscriptions = oci.OspGateway.get_subscriptions(compartment_id=compartment_id,
        osp_home_region=subscription_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    ...
