# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResourceQuotasResult',
    'AwaitableGetResourceQuotasResult',
    'get_resource_quotas',
    'get_resource_quotas_output',
]

@pulumi.output_type
class GetResourceQuotasResult:
    """
    A collection of values returned by getResourceQuotas.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, resource_quotum_collections=None, service_entitlement=None, service_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_quotum_collections and not isinstance(resource_quotum_collections, list):
            raise TypeError("Expected argument 'resource_quotum_collections' to be a list")
        pulumi.set(__self__, "resource_quotum_collections", resource_quotum_collections)
        if service_entitlement and not isinstance(service_entitlement, str):
            raise TypeError("Expected argument 'service_entitlement' to be a str")
        pulumi.set(__self__, "service_entitlement", service_entitlement)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResourceQuotasFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceQuotumCollections")
    def resource_quotum_collections(self) -> Sequence['outputs.GetResourceQuotasResourceQuotumCollectionResult']:
        """
        The list of resource_quotum_collection.
        """
        return pulumi.get(self, "resource_quotum_collections")

    @property
    @pulumi.getter(name="serviceEntitlement")
    def service_entitlement(self) -> Optional[str]:
        return pulumi.get(self, "service_entitlement")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")


class AwaitableGetResourceQuotasResult(GetResourceQuotasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceQuotasResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            resource_quotum_collections=self.resource_quotum_collections,
            service_entitlement=self.service_entitlement,
            service_name=self.service_name)


def get_resource_quotas(compartment_id: Optional[str] = None,
                        filters: Optional[Sequence[Union['GetResourceQuotasFilterArgs', 'GetResourceQuotasFilterArgsDict']]] = None,
                        service_entitlement: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceQuotasResult:
    """
    This data source provides the list of Resource Quotas in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the resource quota details under a tenancy
    > **Important**: Calls to this API will only succeed against the endpoint in the home region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resource_quotas = oci.UsageProxy.get_resource_quotas(compartment_id=compartment_id,
        service_name=test_service["name"],
        service_entitlement=resource_quota_service_entitlement)
    ```


    :param str compartment_id: The OCID of the root compartment.
    :param str service_entitlement: Service entitlement Id.
    :param str service_name: Service Name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['serviceEntitlement'] = service_entitlement
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getResourceQuotas:getResourceQuotas', __args__, opts=opts, typ=GetResourceQuotasResult).value

    return AwaitableGetResourceQuotasResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resource_quotum_collections=pulumi.get(__ret__, 'resource_quotum_collections'),
        service_entitlement=pulumi.get(__ret__, 'service_entitlement'),
        service_name=pulumi.get(__ret__, 'service_name'))


@_utilities.lift_output_func(get_resource_quotas)
def get_resource_quotas_output(compartment_id: Optional[pulumi.Input[str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResourceQuotasFilterArgs', 'GetResourceQuotasFilterArgsDict']]]]] = None,
                               service_entitlement: Optional[pulumi.Input[Optional[str]]] = None,
                               service_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResourceQuotasResult]:
    """
    This data source provides the list of Resource Quotas in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the resource quota details under a tenancy
    > **Important**: Calls to this API will only succeed against the endpoint in the home region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resource_quotas = oci.UsageProxy.get_resource_quotas(compartment_id=compartment_id,
        service_name=test_service["name"],
        service_entitlement=resource_quota_service_entitlement)
    ```


    :param str compartment_id: The OCID of the root compartment.
    :param str service_entitlement: Service entitlement Id.
    :param str service_name: Service Name.
    """
    ...
