""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.unvs.schemas import apis


class UNVSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UNVSClient, self).__init__(config, transport, middleware, logger)

    def get_mobile(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """GetMobile - 一键登录

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BusinessId** (str) - (Required) 业务ID
        - **Token** (str) - (Required) token
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Data** (dict) - 见 **PhoneInfo** 模型定义
        - **Message** (str) - 发生错误时表示错误字符串
        - **ReqUuid** (str) - 本次请求Uuid

        **Response Model**

        **PhoneInfo**
        - **Phone** (str) - 返回的电话号码


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetMobileRequestSchema().dumps(d)

        resp = self.invoke("GetMobile", d, **kwargs)
        return apis.GetMobileResponseSchema().loads(resp)

    def verify_mobile(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """VerifyMobile - 号码检测

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BusinessId** (str) - (Required) 业务ID
        - **Phone** (str) - (Required) 需要检测的手机号
        - **Token** (str) - (Required) token
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Data** (dict) - 见 **VerifyInfo** 模型定义
        - **Message** (str) - 发生错误时表示错误字符串
        - **ReqUuid** (str) - 本次请求Uuid

        **Response Model**

        **VerifyInfo**
        - **VerifyResult** (str) - 检测结果：PASS：一致，REJECT：不一致


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.VerifyMobileRequestSchema().dumps(d)

        resp = self.invoke("VerifyMobile", d, **kwargs)
        return apis.VerifyMobileResponseSchema().loads(resp)
